/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.XmlNamespace;

public class JRXmlWriteHelper {
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_NAMESPACE_PREFIX = "xsi";
    public static final String XML_NAMESPACE_ATTRIBUTE = "xmlns";
    public static final String XML_SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    private final Writer writer;
    private final List indents;
    private int indent;
    private final List elementStack;
    private StringBuffer buffer;
    private StackElement lastElement;
    protected static final Pattern PATTERN_CDATA_CLOSE = Pattern.compile("\\]\\]\\>");
    protected static final String ESCAPED_CDATA_CLOSE = "]]]]><![CDATA[>";

    public JRXmlWriteHelper(Writer writer) {
        this.writer = writer;
        this.indents = new ArrayList();
        this.indent = 0;
        this.elementStack = new ArrayList();
        this.lastElement = null;
        this.clearBuffer();
    }

    public void writeProlog(String encoding) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
    }

    public void writePublicDoctype(String rootElement, String description, String dtdLocation) throws IOException {
        this.writer.write("<!DOCTYPE " + rootElement + " PUBLIC \"" + description + "\" \"" + dtdLocation + "\">\n\n");
    }

    public void startElement(String name) {
        this.startElement(name, null);
    }

    public void startElement(String name, XmlNamespace namespace) {
        boolean startsNS = false;
        XmlNamespace elementNS = null;
        if (namespace == null) {
            elementNS = this.getParentNamespace();
        } else {
            elementNS = this.findContextNamespace(namespace.getNamespaceURI());
            if (elementNS == null) {
                startsNS = true;
                elementNS = namespace;
            }
        }
        ++this.indent;
        this.lastElement = new StackElement(name, elementNS);
        this.elementStack.add(this.lastElement);
        if (startsNS) {
            String xmlnsAttr = XML_NAMESPACE_ATTRIBUTE;
            if (namespace.getPrefix() != null) {
                xmlnsAttr = xmlnsAttr + ":" + namespace.getPrefix();
            }
            this.lastElement.addAttribute(xmlnsAttr, namespace.getNamespaceURI(), false);
            if (this.indent == 1) {
                String xmlSchemaXmlns = "xmlns:xsi";
                this.lastElement.addAttribute(xmlSchemaXmlns, XML_SCHEMA_NAMESPACE, false);
            }
            if (namespace.getSchemaURI() != null) {
                String schemaLocationAttr = JRXmlWriteHelper.getQualifiedName(XML_SCHEMA_LOCATION_ATTRIBUTE, XML_SCHEMA_NAMESPACE_PREFIX);
                String schemaLocation = namespace.getNamespaceURI() + " " + namespace.getSchemaURI();
                this.lastElement.addAttribute(schemaLocationAttr, schemaLocation, false);
            }
        }
    }

    protected XmlNamespace getParentNamespace() {
        return this.lastElement == null ? null : this.lastElement.namespace;
    }

    protected XmlNamespace findContextNamespace(String namespaceURI) {
        XmlNamespace ns = null;
        ListIterator it = this.elementStack.listIterator(this.elementStack.size());
        while (it.hasPrevious()) {
            StackElement element = (StackElement)it.previous();
            if (element.namespace == null || !namespaceURI.equals(element.namespace.getNamespaceURI())) continue;
            ns = element.namespace;
            break;
        }
        return ns;
    }

    protected static String getQualifiedName(String name, XmlNamespace ns) {
        return ns == null ? name : JRXmlWriteHelper.getQualifiedName(name, ns.getPrefix());
    }

    protected static String getQualifiedName(String name, String nsPrefix) {
        String qName = nsPrefix == null ? name : nsPrefix + ":" + name;
        return qName;
    }

    protected void writeParents(boolean content) throws IOException {
        int stackSize = this.elementStack.size();
        for (int startWrite = stackSize - 1; startWrite >= 0; --startWrite) {
            StackElement element = (StackElement)this.elementStack.get(startWrite);
            if (element.hasChildren) break;
            if (startWrite < stackSize - 1) {
                element.hasChildren = true;
                continue;
            }
            element.hasChildren |= content;
        }
        for (int i = startWrite + 1; i < stackSize; ++i) {
            StackElement element = (StackElement)this.elementStack.get(i);
            this.writeElementAttributes(element, i);
        }
    }

    public void writeCDATA(String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append("<![CDATA[");
            this.buffer.append(JRXmlWriteHelper.encodeCDATA(data));
            this.buffer.append("]]>\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data) throws IOException {
        this.writeCDATAElement(name, this.getParentNamespace(), data);
    }

    public void writeCDATAElement(String name, XmlNamespace namespace, String data) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            String qName = JRXmlWriteHelper.getQualifiedName(name, namespace);
            this.buffer.append(qName);
            this.buffer.append("><![CDATA[");
            this.buffer.append(JRXmlWriteHelper.encodeCDATA(data));
            this.buffer.append("]]></");
            this.buffer.append(qName);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String name, String data, String attName, String attValue) throws IOException {
        this.writeCDATAElement(name, data, attName, (Object)attValue);
    }

    public void writeCDATAElement(String name, String data, String attName, Object attValue) throws IOException {
        this.writeCDATAElement(name, this.getParentNamespace(), data, attName, attValue);
    }

    public void writeCDATAElement(String name, XmlNamespace namespace, String data, String attName, Object attValue) throws IOException {
        if (data != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            String qName = JRXmlWriteHelper.getQualifiedName(name, namespace);
            this.buffer.append(qName);
            if (attValue != null) {
                this.buffer.append(' ');
                this.buffer.append(attName);
                this.buffer.append("=\"");
                this.buffer.append(attValue);
                this.buffer.append("\"");
            }
            this.buffer.append("><![CDATA[");
            this.buffer.append(JRXmlWriteHelper.encodeCDATA(data));
            this.buffer.append("]]></");
            this.buffer.append(qName);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    protected void writeElementAttributes(StackElement element, int level) throws IOException {
        this.buffer.append(this.getIndent(level));
        this.buffer.append('<');
        this.buffer.append(element.qName);
        for (Attribute att : element.atts) {
            this.buffer.append(' ');
            this.buffer.append(att.name);
            this.buffer.append("=\"");
            this.buffer.append(att.value);
            this.buffer.append('\"');
        }
        if (element.hasChildren) {
            this.buffer.append(">\n");
        } else {
            this.buffer.append("/>\n");
        }
        this.flushBuffer();
    }

    public void closeElement() throws IOException {
        this.closeElement(false);
    }

    public void closeElement(boolean skipIfEmpty) throws IOException {
        --this.indent;
        if (skipIfEmpty && !this.lastElement.hasAttributes && !this.lastElement.hasChildren) {
            this.clearBuffer();
        } else {
            this.writeParents(false);
            if (this.lastElement.hasChildren) {
                this.buffer.append(this.getIndent(this.indent));
                this.buffer.append("</");
                this.buffer.append(this.lastElement.qName);
                this.buffer.append(">\n");
                this.flushBuffer();
            }
        }
        this.elementStack.remove(this.indent);
        this.lastElement = this.indent > 0 ? (StackElement)this.elementStack.get(this.indent - 1) : null;
    }

    protected char[] getIndent(int level) {
        if (level >= this.indents.size()) {
            for (int i = this.indents.size(); i <= level; ++i) {
                char[] str = new char[i];
                Arrays.fill(str, '\t');
                this.indents.add(str);
            }
        }
        return (char[])this.indents.get(level);
    }

    protected void flushBuffer() throws IOException {
        this.writer.write(this.buffer.toString());
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.buffer = new StringBuffer();
    }

    public void writeExpression(String name, JRExpression expression, boolean writeClass) throws IOException {
        this.writeExpression(name, expression, writeClass, null);
    }

    public void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass) throws IOException {
        this.writeExpression(name, namespace, expression, writeClass, null);
    }

    public void writeExpression(String name, JRExpression expression, boolean writeClass, String defaultClassName) throws IOException {
        this.writeExpression(name, this.getParentNamespace(), expression, writeClass, defaultClassName);
    }

    public void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass, String defaultClassName) throws IOException {
        if (expression != null) {
            if (writeClass && (defaultClassName == null || !defaultClassName.equals(expression.getValueClassName()))) {
                this.writeCDATAElement(name, namespace, expression.getText(), "class", expression.getValueClassName());
            } else {
                this.writeCDATAElement(name, namespace, expression.getText());
            }
        }
    }

    protected void writeAttribute(String name, String value) {
        this.lastElement.addAttribute(name, value);
    }

    public void addAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value) {
        if (value != null) {
            this.writeAttribute(name, JRStringUtil.xmlEncode(value));
        }
    }

    public void addAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, value);
        }
    }

    public void addEncodedAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.writeAttribute(name, JRStringUtil.xmlEncode(value));
        }
    }

    public void addAttribute(String name, Object value) {
        if (value != null) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, int value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttributePositive(String name, int value) {
        if (value > 0) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, float value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, double value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.writeAttribute(name, String.valueOf(value));
        }
    }

    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, boolean value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void addAttribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, Color color) {
        if (color != null) {
            this.writeAttribute(name, "#" + JRColorUtil.getColorHexa(color));
        }
    }

    public void addAttribute(String name, Color value, Color defaultValue) {
        if (value != null && value.getRGB() != defaultValue.getRGB()) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, byte value, Map xmlValues) {
        String xmlValue = (String)xmlValues.get(new Byte(value));
        this.writeAttribute(name, xmlValue);
    }

    public void addAttribute(String name, int value, Map xmlValues) {
        String xmlValue = (String)xmlValues.get(new Integer(value));
        this.writeAttribute(name, xmlValue);
    }

    public void addAttribute(String name, byte value, Map xmlValues, byte defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value, xmlValues);
        }
    }

    public void addAttribute(String name, Object value, Map xmlValues) {
        if (value != null) {
            String xmlValue = (String)xmlValues.get(value);
            this.writeAttribute(name, xmlValue);
        }
    }

    public void addAttribute(String name, Object value, Map xmlValues, Object defaultValue) {
        if (!value.equals(defaultValue)) {
            this.addAttribute(name, value, xmlValues);
        }
    }

    public Writer getUnderlyingWriter() {
        return this.writer;
    }

    protected static String encodeCDATA(String data) {
        if (data == null) {
            return null;
        }
        Matcher matcher = PATTERN_CDATA_CLOSE.matcher(data);
        return matcher.replaceAll(ESCAPED_CDATA_CLOSE);
    }

    protected static class StackElement {
        String name;
        List atts;
        boolean hasChildren;
        XmlNamespace namespace;
        String qName;
        boolean hasAttributes = false;

        StackElement(String name, XmlNamespace namespace) {
            this.name = name;
            this.atts = new ArrayList();
            this.hasChildren = false;
            this.namespace = namespace;
            this.qName = JRXmlWriteHelper.getQualifiedName(this.name, this.namespace);
        }

        void addAttribute(String attName, String value) {
            this.addAttribute(attName, value, true);
        }

        void addAttribute(String attName, String value, boolean count) {
            this.atts.add(new Attribute(attName, value));
            this.hasAttributes |= count;
        }
    }

    protected static class Attribute {
        String name;
        String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

