/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JREmptyQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.olap.JRMondrianQueryExecuter;
import net.sf.jasperreports.olap.JRMondrianQueryExecuterFactory;
import net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuter;
import net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRMdxQueryExecuterFactory
implements JRQueryExecuterFactory {
    private static final Log log = LogFactory.getLog(JRMdxQueryExecuterFactory.class);
    private static final Object[] MDX_BUILTIN_PARAMETERS;

    @Override
    public Object[] getBuiltinParameters() {
        return MDX_BUILTIN_PARAMETERS;
    }

    @Override
    public JRQueryExecuter createQueryExecuter(JRDataset dataset, Map parameters) throws JRException {
        JRQueryExecuter queryExecuter;
        if (this.getParameterValue(parameters, "MONDRIAN_CONNECTION") != null) {
            queryExecuter = new JRMondrianQueryExecuter(dataset, parameters);
        } else if (this.getParameterValue(parameters, "XMLA_URL") != null) {
            queryExecuter = new JRXmlaQueryExecuter(dataset, parameters);
        } else {
            log.warn((Object)"No Mondrian connection or XMLA URL set for MDX query");
            queryExecuter = new JREmptyQueryExecuter();
        }
        return queryExecuter;
    }

    protected final Object getParameterValue(Map valueParams, String name) {
        JRValueParameter valueParam = (JRValueParameter)valueParams.get(name);
        return valueParam == null ? null : valueParam.getValue();
    }

    @Override
    public boolean supportsQueryParameterType(String className) {
        return true;
    }

    static {
        Object[] mondrianParams = new JRMondrianQueryExecuterFactory().getBuiltinParameters();
        Object[] xmlaParams = new JRXmlaQueryExecuterFactory().getBuiltinParameters();
        MDX_BUILTIN_PARAMETERS = new Object[mondrianParams.length + xmlaParams.length];
        System.arraycopy(mondrianParams, 0, MDX_BUILTIN_PARAMETERS, 0, mondrianParams.length);
        System.arraycopy(xmlaParams, 0, MDX_BUILTIN_PARAMETERS, mondrianParams.length, xmlaParams.length);
    }
}

