/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.handler.CefDownloadHandler;

public class DownloadDialog
extends JDialog
implements CefDownloadHandler {
    private final Frame owner_;
    private final Map<Integer, DownloadObject> downloadObjects_ = new HashMap<Integer, DownloadObject>();
    private final JPanel downloadPanel_ = new JPanel();
    private final DownloadDialog dialog_;

    public DownloadDialog(Frame frame) {
        super(frame, "Downloads", false);
        this.setVisible(false);
        this.setSize(400, 300);
        this.owner_ = frame;
        this.dialog_ = this;
        this.downloadPanel_.setLayout(new BoxLayout(this.downloadPanel_, 1));
        this.add(this.downloadPanel_);
    }

    public void onBeforeDownload(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, String string, CefBeforeDownloadCallback cefBeforeDownloadCallback) {
        cefBeforeDownloadCallback.Continue(string, true);
        DownloadObject downloadObject = new DownloadObject(cefDownloadItem, string);
        this.downloadObjects_.put(cefDownloadItem.getId(), downloadObject);
        this.downloadPanel_.add(downloadObject);
    }

    public void onDownloadUpdated(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, CefDownloadItemCallback cefDownloadItemCallback) {
        DownloadObject downloadObject = this.downloadObjects_.get(cefDownloadItem.getId());
        if (downloadObject == null) {
            return;
        }
        downloadObject.update(cefDownloadItem, cefDownloadItemCallback);
    }

    private class DownloadObject
    extends JPanel {
        private boolean isHidden_ = true;
        private final int identifier_;
        private JLabel fileName_ = new JLabel();
        private JLabel status_ = new JLabel();
        private JButton dlAbort_ = new JButton();
        private JButton dlRemoveEntry_ = new JButton("x");
        private CefDownloadItemCallback callback_;
        private Color bgColor_;

        DownloadObject(CefDownloadItem cefDownloadItem, String string) {
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.setMaximumSize(new Dimension(DownloadDialog.this.dialog_.getWidth() - 10, 80));
            this.identifier_ = cefDownloadItem.getId();
            this.bgColor_ = this.identifier_ % 2 == 0 ? Color.WHITE : Color.YELLOW;
            this.setBackground(this.bgColor_);
            this.fileName_.setText(string);
            this.add((Component)this.fileName_, "North");
            this.status_.setAlignmentX(0.0f);
            this.add((Component)this.status_, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setOpaque(true);
            jPanel.setBackground(this.bgColor_);
            this.dlAbort_.setText("Abort");
            this.dlAbort_.setEnabled(false);
            this.dlAbort_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DownloadObject.this.callback_ != null) {
                        DownloadObject.this.fileName_.setText("ABORTED - " + DownloadObject.this.fileName_.getText());
                        DownloadObject.this.callback_.cancel();
                    }
                }
            });
            jPanel.add(this.dlAbort_);
            this.dlRemoveEntry_.setEnabled(false);
            this.dlRemoveEntry_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadObject downloadObject = (DownloadObject)DownloadDialog.this.downloadObjects_.remove(DownloadObject.this.identifier_);
                    if (downloadObject != null) {
                        DownloadDialog.this.downloadPanel_.remove(downloadObject);
                        DownloadDialog.this.dialog_.repaint();
                    }
                }
            });
            jPanel.add(this.dlRemoveEntry_);
            this.add((Component)jPanel, "South");
            this.update(cefDownloadItem, null);
        }

        String humanReadableByteCount(long l) {
            int n = 1024;
            if (l < (long)n) {
                return l + " B";
            }
            int n2 = (int)(Math.log(l) / Math.log(n));
            String string = "" + "kMGTPE".charAt(n2 - 1);
            return String.format("%.1f %sB", (double)l / Math.pow(n, n2), string);
        }

        void update(CefDownloadItem cefDownloadItem, CefDownloadItemCallback cefDownloadItemCallback) {
            int n = cefDownloadItem.getPercentComplete();
            String string = this.humanReadableByteCount(cefDownloadItem.getReceivedBytes());
            String string2 = this.humanReadableByteCount(cefDownloadItem.getTotalBytes());
            String string3 = this.humanReadableByteCount(cefDownloadItem.getCurrentSpeed()) + "it/s";
            if (cefDownloadItem.getReceivedBytes() >= 5L && this.isHidden_) {
                DownloadDialog.this.dialog_.setVisible(true);
                DownloadDialog.this.dialog_.toFront();
                DownloadDialog.this.owner_.toBack();
                this.isHidden_ = false;
            }
            Runtime.getRuntime().runFinalization();
            this.callback_ = cefDownloadItemCallback;
            this.status_.setText(string + " of " + string2 + " - " + n + "% - " + string3);
            this.dlAbort_.setEnabled(cefDownloadItem.isInProgress());
            this.dlRemoveEntry_.setEnabled(!cefDownloadItem.isInProgress() || cefDownloadItem.isCanceled() || cefDownloadItem.isComplete());
            if (!(cefDownloadItem.isInProgress() || cefDownloadItem.isCanceled() || cefDownloadItem.isComplete())) {
                this.fileName_.setText("FAILED - " + this.fileName_.getText());
                cefDownloadItemCallback.cancel();
            }
        }
    }
}

