/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import tests.detailed.dialog.UrlRequestDialogReply;

public class UrlRequestDialog
extends JDialog {
    private final Vector<JRadioButton> requestMethods = new Vector();
    private final Map<JCheckBox, Integer> requestFlags = new HashMap<JCheckBox, Integer>();
    private final TableModel headerTblModel = new TableModel(true);
    private final TableModel postDataModel = new TableModel(false);
    private final JTextField urlField;
    private final JTextField cookieUrl;
    private final Frame owner_;

    private CefRequest createRequest() {
        Object object;
        Object object2;
        String string = this.urlField.getText();
        if (string.isEmpty() || string.trim().equalsIgnoreCase("http://")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(UrlRequestDialog.this.owner_, "Please specify at least an URL. Otherwise the CefRequest is invalid");
                }
            });
            return null;
        }
        CefRequest cefRequest = CefRequest.create();
        if (cefRequest == null) {
            return null;
        }
        String string2 = this.cookieUrl.getText();
        if (string2.isEmpty() || string2.trim().equalsIgnoreCase("http://")) {
            string2 = string;
        }
        String string3 = "GET";
        for (int i = 0; i < this.requestMethods.size(); ++i) {
            JRadioButton jRadioButton = this.requestMethods.get(i);
            if (!jRadioButton.isSelected()) continue;
            string3 = jRadioButton.getText();
            break;
        }
        CefPostData cefPostData = null;
        int n = this.postDataModel.getRowCount();
        if (n > 0) {
            cefPostData = CefPostData.create();
        } else if (string3.equalsIgnoreCase("POST") || string3.equalsIgnoreCase("PUT")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(UrlRequestDialog.this.owner_, "The methods POST and PUT require at least one row of data.");
                }
            });
            return null;
        }
        if (cefPostData != null) {
            for (int i = 0; i < n; ++i) {
                CefPostDataElement cefPostDataElement;
                String string4 = (String)this.postDataModel.getValueAt(i, 0);
                if (string4.trim().isEmpty() || (cefPostDataElement = CefPostDataElement.create()) == null) continue;
                object2 = new File(string4);
                if (((File)object2).isFile()) {
                    cefPostDataElement.setToFile(string4);
                } else {
                    object = string4.getBytes();
                    cefPostDataElement.setToBytes(((Object)object).length, (byte[])object);
                }
                cefPostData.addElement(cefPostDataElement);
            }
        }
        HashMap<Object, Object> hashMap = null;
        int n2 = this.headerTblModel.getRowCount();
        if (n2 > 0) {
            hashMap = new HashMap<Object, Object>();
            for (int i = 0; i < n2; ++i) {
                object2 = (String)this.headerTblModel.getValueAt(i, 0);
                object = (String)this.headerTblModel.getValueAt(i, 1);
                if (((String)object2).trim().isEmpty()) continue;
                hashMap.put(object2, object);
            }
        }
        int n3 = 0;
        object2 = this.requestFlags.entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            Map.Entry<JCheckBox, Integer> entry = object.next();
            if (!entry.getKey().isSelected()) continue;
            n3 |= entry.getValue().intValue();
        }
        cefRequest.set(string, string3, cefPostData, hashMap);
        cefRequest.setFirstPartyForCookies(string2);
        cefRequest.setFlags(n3);
        return cefRequest;
    }

    public UrlRequestDialog(Frame frame, String string) {
        super(frame, string, false);
        this.setSize(1200, 600);
        this.setLayout(new BorderLayout());
        this.owner_ = frame;
        this.urlField = new JTextField("http://");
        JPanel jPanel = this.createPanelWithTitle("Request URL", 1, 0);
        jPanel.add(this.urlField);
        this.cookieUrl = new JTextField("http://");
        JPanel jPanel2 = this.createPanelWithTitle("Cookie-URL", 1, 0);
        jPanel2.add(this.cookieUrl);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = this.createPanelWithTitle("HTTP Request Mode", 1, 0);
        this.addRequestMode(jPanel3, buttonGroup, "GET", true);
        this.addRequestMode(jPanel3, buttonGroup, "HEAD", false);
        this.addRequestMode(jPanel3, buttonGroup, "POST", false);
        this.addRequestMode(jPanel3, buttonGroup, "PUT", false);
        this.addRequestMode(jPanel3, buttonGroup, "DELETE", false);
        JPanel jPanel4 = this.createPanelWithTitle("Flags", 0, 1);
        this.addRequestFlag(jPanel4, "Skip cache", 1, "If set the cache will be skipped when handling the request", false);
        this.addRequestFlag(jPanel4, "Allow cached credentials", 2, "If set user name, password, and cookies may be sent with the request, and cookies may be saved from the response.", false);
        this.addRequestFlag(jPanel4, "Report Upload Progress", 8, "If set upload progress events will be generated when a request has a body", false);
        this.addRequestFlag(jPanel4, "Report RawHeaders", 32, "If set the headers sent and received for the request will be recorded", false);
        this.addRequestFlag(jPanel4, "No download data", 64, "If set the CefURLRequestClient.onDownloadData method will not be called", false);
        this.addRequestFlag(jPanel4, "No retry on 5xx", 128, "If set 5XX redirect errors will be propagated to the observer instead of automatically re-tried.", false);
        JPanel jPanel5 = this.createPanelWithTable("Header Values", this.headerTblModel);
        this.headerTblModel.addEntry("User-Agent", "Mozilla/5.0 JCEF Example Agent");
        this.headerTblModel.addEntry("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        JPanel jPanel6 = this.createPanelWithTable("Post Data", this.postDataModel);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel7.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel7.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel7.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel8 = new JPanel(new GridLayout(2, 0));
        jPanel8.add(jPanel5);
        jPanel8.add(jPanel6);
        JButton jButton = new JButton("Abort");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UrlRequestDialog.this.setVisible(false);
                UrlRequestDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton("Send");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CefRequest cefRequest = UrlRequestDialog.this.createRequest();
                if (cefRequest == null) {
                    return;
                }
                UrlRequestDialogReply urlRequestDialogReply = new UrlRequestDialogReply(UrlRequestDialog.this.owner_, UrlRequestDialog.this.getTitle() + " - Result");
                urlRequestDialogReply.send(cefRequest);
                urlRequestDialogReply.setVisible(true);
                UrlRequestDialog.this.setVisible(false);
                UrlRequestDialog.this.dispose();
            }
        });
        JPanel jPanel9 = new JPanel(new GridLayout(0, 2));
        jPanel9.add(jButton);
        jPanel9.add(jButton2);
        this.add((Component)jPanel7, "First");
        this.add((Component)jPanel4, "Before");
        this.add((Component)jPanel8, "Center");
        this.add((Component)jPanel9, "Last");
    }

    private void addRequestMode(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string, bl);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        this.requestMethods.addElement(jRadioButton);
    }

    private void addRequestFlag(JPanel jPanel, String string, int n, String string2, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setToolTipText(string2);
        jPanel.add(jCheckBox);
        this.requestFlags.put(jCheckBox, n);
    }

    private JPanel createPanelWithTitle(String string, int n, int n2) {
        JPanel jPanel = new JPanel(new GridLayout(n, n2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jPanel;
    }

    private JPanel createPanelWithTable(String string, TableModel tableModel) {
        final TableModel tableModel2 = tableModel;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JTable jTable = new JTable(tableModel);
        jTable.setFillsViewportHeight(true);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        JButton jButton = new JButton("Add entry");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tableModel2.newDefaultEntry();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Remove entry");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tableModel2.removeSelected();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "Last");
        return jPanel;
    }

    private class TableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private Vector<Object[]> rowData = new Vector();
        private final boolean hasKeyColumn_;

        public TableModel(boolean bl) {
            this.hasKeyColumn_ = bl;
            this.columnNames = bl ? new String[]{"Key", "Value", ""} : new String[]{"Value", ""};
        }

        public void newDefaultEntry() {
            int n = this.rowData.size();
            if (this.hasKeyColumn_) {
                Object[] objectArray = new Object[]{"key", "value", new Boolean(false)};
                this.rowData.addElement(objectArray);
            } else {
                Object[] objectArray = new Object[]{"value", new Boolean(false)};
                this.rowData.addElement(objectArray);
            }
            this.fireTableRowsInserted(n, n);
        }

        public void removeSelected() {
            int n = this.hasKeyColumn_ ? 2 : 1;
            for (int i = 0; i < this.rowData.size(); ++i) {
                if (!((Boolean)this.rowData.get(i)[n]).booleanValue()) continue;
                this.rowData.remove(i);
                this.fireTableRowsDeleted(i, i);
                --i;
            }
        }

        public void addEntry(String string, String string2) {
            int n = this.rowData.size();
            if (this.hasKeyColumn_) {
                Object[] objectArray = new Object[]{string, string2, new Boolean(false)};
                this.rowData.addElement(objectArray);
            } else {
                Object[] objectArray = new Object[]{string2, new Boolean(false)};
                this.rowData.addElement(objectArray);
            }
            this.fireTableRowsInserted(n, n);
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.rowData.size() > 0) {
                return this.rowData.get(0)[n].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rowData.get(n)[n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.rowData.get((int)n)[n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

