/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefURLRequestClient;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;
import tests.detailed.dialog.PasswordDialog;

public class UrlRequestDialogReply
extends JDialog
implements CefURLRequestClient {
    private long nativeRef_ = 0L;
    private final JLabel statusLabel_ = new JLabel("HTTP-Request status: ");
    private final JTextArea sentRequest_ = new JTextArea();
    private final JTextArea repliedResult_ = new JTextArea();
    private final JButton cancelButton_ = new JButton("Cancel");
    private CefURLRequest urlRequest_ = null;
    private final Frame owner_;
    private ByteArrayOutputStream byteStream_ = new ByteArrayOutputStream();

    public UrlRequestDialogReply(Frame frame, String string) {
        super(frame, string, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.owner_ = frame;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Done");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UrlRequestDialogReply.this.urlRequest_.dispose();
                UrlRequestDialogReply.this.setVisible(false);
                UrlRequestDialogReply.this.dispose();
            }
        });
        jPanel.add(jButton);
        this.cancelButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UrlRequestDialogReply.this.urlRequest_ != null) {
                    UrlRequestDialogReply.this.urlRequest_.cancel();
                }
            }
        });
        this.cancelButton_.setEnabled(false);
        jPanel.add(this.cancelButton_);
        JPanel jPanel2 = this.createPanelWithTitle("Sent HTTP-Request", 1, 0);
        jPanel2.add(new JScrollPane(this.sentRequest_));
        JPanel jPanel3 = this.createPanelWithTitle("Reply from the server", 1, 0);
        jPanel3.add(new JScrollPane(this.repliedResult_));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.add((Component)this.statusLabel_, "First");
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel, "Last");
    }

    private JPanel createPanelWithTitle(String string, int n, int n2) {
        JPanel jPanel = new JPanel(new GridLayout(n, n2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jPanel;
    }

    public void send(CefRequest cefRequest) {
        if (cefRequest == null) {
            this.statusLabel_.setText("HTTP-Request status: FAILED");
            this.sentRequest_.append("Can't send CefRequest because it is NULL");
            this.cancelButton_.setEnabled(false);
            return;
        }
        this.urlRequest_ = CefURLRequest.create((CefRequest)cefRequest, (CefURLRequestClient)this);
        if (this.urlRequest_ == null) {
            this.statusLabel_.setText("HTTP-Request status: FAILED");
            this.sentRequest_.append("Can't send CefRequest because creation of CefURLRequest failed.");
            this.repliedResult_.append("The native code (CEF) returned a NULL-Pointer for CefURLRequest.");
            this.cancelButton_.setEnabled(false);
        } else {
            this.sentRequest_.append(cefRequest.toString());
            this.cancelButton_.setEnabled(true);
            this.updateStatus("", false);
        }
    }

    private void updateStatus(final String string, final boolean bl) {
        final CefURLRequest.Status status = this.urlRequest_.getRequestStatus();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UrlRequestDialogReply.this.statusLabel_.setText("HTTP-Request status: " + status);
                if (status != CefURLRequest.Status.UR_UNKNOWN && status != CefURLRequest.Status.UR_IO_PENDING) {
                    UrlRequestDialogReply.this.cancelButton_.setEnabled(false);
                }
                UrlRequestDialogReply.this.repliedResult_.append(string);
                if (bl) {
                    try {
                        UrlRequestDialogReply.this.repliedResult_.append("\n\n" + UrlRequestDialogReply.this.byteStream_.toString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        UrlRequestDialogReply.this.repliedResult_.append("\n\n" + UrlRequestDialogReply.this.byteStream_.toString());
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setNativeRef(String string, long l) {
        this.nativeRef_ = l;
    }

    public long getNativeRef(String string) {
        return this.nativeRef_;
    }

    public void onRequestComplete(CefURLRequest cefURLRequest) {
        String string = "onRequestCompleted\n\n";
        CefResponse cefResponse = cefURLRequest.getResponse();
        boolean bl = cefResponse.getHeader("Content-Type").startsWith("text");
        string = string + cefResponse.toString();
        this.updateStatus(string, bl);
    }

    public void onUploadProgress(CefURLRequest cefURLRequest, int n, int n2) {
        this.updateStatus("onUploadProgress: " + n + "/" + n2 + " bytes\n", false);
    }

    public void onDownloadProgress(CefURLRequest cefURLRequest, int n, int n2) {
        this.updateStatus("onDownloadProgress: " + n + "/" + n2 + " bytes\n", false);
    }

    public void onDownloadData(CefURLRequest cefURLRequest, byte[] byArray, int n) {
        this.byteStream_.write(byArray, 0, n);
        this.updateStatus("onDownloadData: " + n + " bytes\n", false);
    }

    public boolean getAuthCredentials(boolean bl, String string, int n, String string2, String string3, CefAuthCallback cefAuthCallback) {
        SwingUtilities.invokeLater(new PasswordDialog(this.owner_, cefAuthCallback));
        return true;
    }
}

