/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cef.callback.CefWebPluginInfoVisitor;
import org.cef.network.CefWebPluginInfo;
import org.cef.network.CefWebPluginManager;

public class WebPluginManagerDialog
extends JDialog {
    private final CefWebPluginManager manager = CefWebPluginManager.getGlobalManager();
    private final PluginTableModel tblModel = new PluginTableModel();

    public WebPluginManagerDialog(Frame frame, String string) {
        super(frame, string, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        JTable jTable = new JTable(this.tblModel);
        jTable.setFillsViewportHeight(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Remove selected plugins");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebPluginManagerDialog.this.tblModel.removeSelected();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Done");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebPluginManagerDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        this.add(new JScrollPane(jTable));
        this.add((Component)jPanel, "South");
        if (this.manager == null) {
            throw new NullPointerException("Plugin manager is null");
        }
        this.manager.visitPlugins((CefWebPluginInfoVisitor)this.tblModel);
    }

    private class PluginTableModel
    extends AbstractTableModel
    implements CefWebPluginInfoVisitor {
        private final String[] columnNames;
        private Vector<Object[]> rowData = new Vector();

        public PluginTableModel() {
            this.columnNames = new String[]{"Name", "Path", "Version", "Description", ""};
        }

        public boolean visit(CefWebPluginInfo cefWebPluginInfo, int n, int n2) {
            Object[] objectArray = new Object[]{cefWebPluginInfo.getName(), cefWebPluginInfo.getPath(), cefWebPluginInfo.getVersion(), cefWebPluginInfo.getDescription(), new Boolean(false)};
            int n3 = this.rowData.size();
            this.rowData.addElement(objectArray);
            this.fireTableRowsInserted(n3, n3);
            return true;
        }

        public void removeSelected() {
            for (int i = 0; i < this.rowData.size(); ++i) {
                if (!((Boolean)this.rowData.get(i)[4]).booleanValue()) continue;
                String string = (String)this.rowData.get(i)[1];
                this.rowData.remove(i);
                this.fireTableRowsDeleted(i, i);
                --i;
            }
            WebPluginManagerDialog.this.manager.refreshPlugins();
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.rowData.size() > 0) {
                return this.rowData.get(0)[n].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rowData.get(n)[n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.rowData.get((int)n)[n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

