/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.handler;

import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefContextMenuHandler;
import tests.detailed.dialog.SearchDialog;
import tests.detailed.dialog.ShowTextDialog;

public class ContextMenuHandler
implements CefContextMenuHandler {
    private final Frame owner_;
    private Map<Integer, String> suggestions_ = new HashMap<Integer, String>();

    public ContextMenuHandler(Frame frame) {
        this.owner_ = frame;
    }

    public void onBeforeContextMenu(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, CefMenuModel cefMenuModel) {
        cefMenuModel.clear();
        cefMenuModel.addItem(100, "Back");
        cefMenuModel.setEnabled(100, cefBrowser.canGoBack());
        cefMenuModel.addItem(101, "Forward");
        cefMenuModel.setEnabled(101, cefBrowser.canGoForward());
        cefMenuModel.addSeparator();
        cefMenuModel.addItem(130, "Find...");
        if (cefContextMenuParams.hasImageContents() && cefContextMenuParams.getSourceUrl() != null) {
            cefMenuModel.addItem(26500, "Download Image...");
        }
        cefMenuModel.addItem(132, "View Source...");
        Vector vector = new Vector();
        cefContextMenuParams.getDictionarySuggestions(vector);
        cefMenuModel.addSeparator();
        if (vector.size() == 0) {
            cefMenuModel.addItem(205, "No suggestions");
            cefMenuModel.setEnabled(205, false);
            return;
        }
        int n = 200;
        for (String string : vector) {
            cefMenuModel.addItem(n, string);
            this.suggestions_.put(n, string);
            if (++n <= 204) continue;
            break;
        }
    }

    public boolean onContextMenuCommand(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, int n, int n2) {
        String string;
        switch (n) {
            case 132: {
                ShowTextDialog showTextDialog = new ShowTextDialog(this.owner_, "Source of \"" + cefBrowser.getURL() + "\"");
                cefBrowser.getSource((CefStringVisitor)showTextDialog);
                return true;
            }
            case 130: {
                SearchDialog searchDialog = new SearchDialog(this.owner_, cefBrowser);
                searchDialog.setVisible(true);
                return true;
            }
            case 26500: {
                cefBrowser.startDownload(cefContextMenuParams.getSourceUrl());
                return true;
            }
        }
        if (n >= 200 && (string = this.suggestions_.get(n)) != null) {
            System.err.println("replacing " + cefContextMenuParams.getMisspelledWord() + " with " + string);
            cefBrowser.replaceMisspelling(string);
            return true;
        }
        return false;
    }

    public void onContextMenuDismissed(CefBrowser cefBrowser, CefFrame cefFrame) {
        this.suggestions_.clear();
    }
}

