/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.handler;

import java.nio.ByteBuffer;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class ResourceHandler
extends CefResourceHandlerAdapter {
    private int startPos = 0;
    private static final String html = new String("<html>\n  <head>\n    <title>ResourceHandler Test</title>\n  </head>\n  <body>\n    <h1>ResourceHandler Test</h1>\n    <p>You have entered the URL: http://www.foo.bar. This page is generated by the application itself and<br/>\n       no HTTP request was sent to the internet.\n    <p>See class <u>tests.handler.ResourceHandler</u> and the <u>RequestHandler</u> implementation for details.</p>\n  </body>\n</html>");

    public boolean processRequest(CefRequest cefRequest, CefCallback cefCallback) {
        System.out.println("processRequest: " + cefRequest);
        this.startPos = 0;
        cefCallback.Continue();
        return true;
    }

    public void getResponseHeaders(CefResponse cefResponse, IntRef intRef, StringRef stringRef) {
        System.out.println("getResponseHeaders: " + cefResponse);
        intRef.set(html.length());
        cefResponse.setMimeType("text/html");
        cefResponse.setStatus(200);
    }

    public boolean readResponse(byte[] byArray, int n, IntRef intRef, CefCallback cefCallback) {
        int n2 = html.length();
        if (this.startPos >= n2) {
            return false;
        }
        int n3 = this.startPos + n;
        String string = n3 > n2 ? html.substring(this.startPos) : html.substring(this.startPos, n3);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.put(string.getBytes());
        intRef.set(string.length());
        this.startPos = n3;
        return true;
    }

    public void cancel() {
        System.out.println("cancel");
        this.startPos = 0;
    }
}

