/*
 * Decompiled with CFR 0.152.
 */
package tests.detailed.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import tests.detailed.BrowserFrame;
import tests.detailed.MainFrame;
import tests.detailed.dialog.CookieManagerDialog;
import tests.detailed.dialog.DevToolsDialog;
import tests.detailed.dialog.DownloadDialog;
import tests.detailed.dialog.SearchDialog;
import tests.detailed.dialog.ShowTextDialog;
import tests.detailed.dialog.UrlRequestDialog;
import tests.detailed.dialog.WebPluginManagerDialog;
import tests.detailed.ui.ControlPanel;

public class MenuBar
extends JMenuBar {
    private final BrowserFrame owner_;
    private final CefBrowser browser_;
    private String last_selected_file_ = "";
    private final JMenu bookmarkMenu_;
    private final ControlPanel control_pane_;
    private final DownloadDialog downloadDialog_;
    private final CefCookieManager cookieManager_;
    private boolean reparentPending_ = false;

    public MenuBar(BrowserFrame browserFrame, final CefBrowser cefBrowser, ControlPanel controlPanel, DownloadDialog downloadDialog, CefCookieManager cefCookieManager) {
        this.owner_ = browserFrame;
        this.browser_ = cefBrowser;
        this.control_pane_ = controlPanel;
        this.downloadDialog_ = downloadDialog;
        this.cookieManager_ = cefCookieManager;
        this.setEnabled(this.browser_ != null);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open file...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(new File(MenuBar.this.last_selected_file_));
                jFileChooser.showOpenDialog(MenuBar.this.owner_);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    MenuBar.this.last_selected_file_ = file.getAbsolutePath();
                    MenuBar.this.browser_.loadURL("file:///" + file.getAbsolutePath());
                }
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save as...");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CefRunFileDialogCallback cefRunFileDialogCallback = new CefRunFileDialogCallback(){

                    public void onFileDialogDismissed(int n, Vector<String> vector) {
                        if (!vector.isEmpty()) {
                            try {
                                SaveAs saveAs = new SaveAs(vector.get(0));
                                MenuBar.this.browser_.getSource((CefStringVisitor)saveAs);
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                                MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", MenuBar.this.control_pane_.getAddress(), 0);
                            }
                        }
                    }
                };
                MenuBar.this.browser_.runFileDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, MenuBar.this.owner_.getTitle(), "index.html", null, 0, cefRunFileDialogCallback);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Print...");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.print();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Print to PDF");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.showSaveDialog(MenuBar.this.owner_);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    CefPdfPrintSettings cefPdfPrintSettings = new CefPdfPrintSettings();
                    cefPdfPrintSettings.header_footer_enabled = true;
                    cefPdfPrintSettings.page_width = 210000;
                    cefPdfPrintSettings.page_height = 297000;
                    cefBrowser.printToPDF(file.getAbsolutePath(), cefPdfPrintSettings, new CefPdfPrintCallback(){

                        public void onPdfPrintFinished(final String string, final boolean bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (bl) {
                                        JOptionPane.showMessageDialog(MenuBar.this.owner_, "PDF saved to " + string, "Success", 1);
                                    } else {
                                        JOptionPane.showMessageDialog(MenuBar.this.owner_, "PDF failed", "Failed", 0);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Search...");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SearchDialog((Frame)MenuBar.this.owner_, MenuBar.this.browser_).setVisible(true);
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("View source");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.viewSource();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Get source...");
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowTextDialog showTextDialog = new ShowTextDialog((Frame)MenuBar.this.owner_, "Source of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getSource((CefStringVisitor)showTextDialog);
            }
        });
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Get text...");
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowTextDialog showTextDialog = new ShowTextDialog((Frame)MenuBar.this.owner_, "Content of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getText((CefStringVisitor)showTextDialog);
            }
        });
        jMenu.add(jMenuItem8);
        jMenu.addSeparator();
        JMenuItem jMenuItem9 = new JMenuItem("Show Downloads");
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.downloadDialog_.setVisible(true);
            }
        });
        jMenu.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Show Cookies");
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CookieManagerDialog cookieManagerDialog = new CookieManagerDialog((Frame)MenuBar.this.owner_, "Cookie Manager", MenuBar.this.cookieManager_);
                cookieManagerDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("Show Plugins");
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebPluginManagerDialog webPluginManagerDialog = new WebPluginManagerDialog((Frame)MenuBar.this.owner_, "Plugin Manager");
                webPluginManagerDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem11);
        jMenu.addSeparator();
        JMenuItem jMenuItem12 = new JMenuItem("Exit");
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.owner_.dispatchEvent(new WindowEvent(MenuBar.this.owner_, 201));
            }
        });
        jMenu.add(jMenuItem12);
        this.bookmarkMenu_ = new JMenu("Bookmarks");
        JMenuItem jMenuItem13 = new JMenuItem("Add bookmark");
        jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.addBookmark(MenuBar.this.owner_.getTitle(), MenuBar.this.control_pane_.getAddress());
            }
        });
        this.bookmarkMenu_.add(jMenuItem13);
        this.bookmarkMenu_.addSeparator();
        JMenu jMenu2 = new JMenu("Tests");
        JMenuItem jMenuItem14 = new JMenuItem("JavaScript alert");
        jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.executeJavaScript("alert('Hello World');", MenuBar.this.control_pane_.getAddress(), 1);
            }
        });
        jMenu2.add(jMenuItem14);
        JMenuItem jMenuItem15 = new JMenuItem("JavaScript alert (will be suppressed)");
        jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.executeJavaScript("alert('Never displayed');", "http://dontshow.me", 1);
            }
        });
        jMenu2.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("Show Text");
        jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.loadString("<html><body><h1>Hello World</h1></body></html>", MenuBar.this.control_pane_.getAddress());
            }
        });
        jMenu2.add(jMenuItem16);
        JMenuItem jMenuItem17 = new JMenuItem("RequestHandler Test");
        jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "<html><head><title>RequestHandler test</title></head>";
                string = string + "<body><h1>RequestHandler test</h1>";
                string = string + "<form action=\"http://www.google.com/\" method=\"post\">";
                string = string + "<input type=\"text\" name=\"searchFor\"/>";
                string = string + "<input type=\"submit\"/><br/>";
                string = string + "<input type=\"checkbox\" name=\"sendAsGet\"> Use GET instead of POST";
                string = string + "<p>This form tries to send the content of the text field as HTTP-POST request to http://www.google.com.</p>";
                string = string + "<h2>Testcase 1</h2>";
                string = string + "Try to enter the word <b>\"ignore\"</b> into the text field and press \"submit\".<br />";
                string = string + "The request will be rejected by the application.";
                string = string + "<p>See implementation of <u>tests.RequestHandler.onBeforeBrowse(CefBrowser, CefRequest, boolean)</u> for details</p>";
                string = string + "<h2>Testcase 2</h2>";
                string = string + "Due Google doesn't allow the POST method, the server replies with a 405 error.</br>";
                string = string + "If you activate the checkbox \"Use GET instead of POST\", the application will change the POST request into a GET request.";
                string = string + "<p>See implementation of <u>tests.RequestHandler.onBeforeResourceLoad(CefBrowser, CefRequest)</u> for details</p>";
                string = string + "</form>";
                string = string + "</body></html>";
                MenuBar.this.browser_.loadString(string, MenuBar.this.control_pane_.getAddress());
            }
        });
        jMenu2.add(jMenuItem17);
        JMenuItem jMenuItem18 = new JMenuItem("Manual HTTP request");
        jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(MenuBar.this.owner_, (Object)"Search on google:");
                if (string != null && !string.isEmpty()) {
                    CefRequest cefRequest = CefRequest.create();
                    cefRequest.setMethod("GET");
                    cefRequest.setURL("http://www.google.com/#q=" + string);
                    cefRequest.setFirstPartyForCookies("http://www.google.com/#q=" + string);
                    MenuBar.this.browser_.loadRequest(cefRequest);
                }
            }
        });
        jMenu2.add(jMenuItem18);
        JMenuItem jMenuItem19 = new JMenuItem("Show Info");
        jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "<html><head><title>Browser status</title></head>";
                string = string + "<body><h1>Browser status</h1><table border=\"0\">";
                string = string + "<tr><td>CanGoBack</td><td>" + MenuBar.this.browser_.canGoBack() + "</td></tr>";
                string = string + "<tr><td>CanGoForward</td><td>" + MenuBar.this.browser_.canGoForward() + "</td></tr>";
                string = string + "<tr><td>IsLoading</td><td>" + MenuBar.this.browser_.isLoading() + "</td></tr>";
                string = string + "<tr><td>isPopup</td><td>" + MenuBar.this.browser_.isPopup() + "</td></tr>";
                string = string + "<tr><td>hasDocument</td><td>" + MenuBar.this.browser_.hasDocument() + "</td></tr>";
                string = string + "<tr><td>Url</td><td>" + MenuBar.this.browser_.getURL() + "</td></tr>";
                string = string + "<tr><td>Zoom-Level</td><td>" + MenuBar.this.browser_.getZoomLevel() + "</td></tr>";
                string = string + "</table></body></html>";
                String string2 = "var x=window.open(); x.document.open(); x.document.write('" + string + "'); x.document.close();";
                MenuBar.this.browser_.executeJavaScript(string2, "", 0);
            }
        });
        jMenu2.add(jMenuItem19);
        final JMenuItem jMenuItem20 = new JMenuItem("Show DevTools");
        jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevToolsDialog devToolsDialog = new DevToolsDialog((Frame)MenuBar.this.owner_, "DEV Tools", MenuBar.this.browser_);
                devToolsDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent componentEvent) {
                        jMenuItem20.setEnabled(true);
                    }
                });
                devToolsDialog.setVisible(true);
                jMenuItem20.setEnabled(false);
            }
        });
        jMenu2.add(jMenuItem20);
        JMenuItem jMenuItem21 = new JMenuItem("URL Request");
        jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UrlRequestDialog urlRequestDialog = new UrlRequestDialog((Frame)MenuBar.this.owner_, "URL Request Test");
                urlRequestDialog.setVisible(true);
            }
        });
        jMenu2.add(jMenuItem21);
        JMenuItem jMenuItem22 = new JMenuItem("Reparent");
        jMenuItem22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final BrowserFrame browserFrame = new BrowserFrame("New Window");
                browserFrame.setLayout(new BorderLayout());
                final JButton jButton = new JButton("Reparent <");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (MenuBar.this.reparentPending_) {
                            return;
                        }
                        MenuBar.this.reparentPending_ = true;
                        if (jButton.getText().equals("Reparent <")) {
                            MenuBar.this.owner_.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    browserFrame.add(MenuBar.this.browser_.getUIComponent(), "Center");
                                    browserFrame.setBrowser(MenuBar.this.browser_);
                                    jButton.setText("Reparent >");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        } else {
                            browserFrame.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    JRootPane jRootPane = (JRootPane)MenuBar.this.owner_.getComponent(0);
                                    Container container = jRootPane.getContentPane();
                                    JPanel jPanel = (JPanel)container.getComponent(0);
                                    jPanel.add(MenuBar.this.browser_.getUIComponent());
                                    MenuBar.this.owner_.setBrowser(MenuBar.this.browser_);
                                    MenuBar.this.owner_.revalidate();
                                    jButton.setText("Reparent <");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        }
                    }
                });
                browserFrame.add((Component)jButton, "North");
                browserFrame.setSize(400, 400);
                browserFrame.setVisible(true);
            }
        });
        jMenu2.add(jMenuItem22);
        JMenuItem jMenuItem23 = new JMenuItem("New window");
        jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame mainFrame = new MainFrame(OS.isLinux(), false, false, null);
                mainFrame.setSize(800, 600);
                mainFrame.setVisible(true);
            }
        });
        jMenu2.add(jMenuItem23);
        this.add(jMenu);
        this.add(this.bookmarkMenu_);
        this.add(jMenu2);
    }

    public void addBookmark(String string, String string2) {
        if (this.bookmarkMenu_ == null) {
            return;
        }
        Component[] componentArray = this.bookmarkMenu_.getMenuComponents();
        for (Component component : componentArray) {
            JMenuItem jMenuItem;
            if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).getText().equals(string)) continue;
            jMenuItem.setActionCommand(string2);
            return;
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuBar.this.browser_.loadURL(actionEvent.getActionCommand());
            }
        });
        this.bookmarkMenu_.add(jMenuItem);
        this.validate();
    }

    public void addBookmarkSeparator() {
        this.bookmarkMenu_.addSeparator();
    }

    class SaveAs
    implements CefStringVisitor {
        private PrintWriter fileWriter_;

        public SaveAs(String string) throws FileNotFoundException, UnsupportedEncodingException {
            this.fileWriter_ = new PrintWriter(string, "UTF-8");
        }

        public void visit(String string) {
            this.fileWriter_.write(string);
            this.fileWriter_.close();
        }
    }
}

