/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.handler.CefWindowHandler;
import org.cef.handler.CefWindowHandlerAdapter;

class CefBrowserWr
extends CefBrowser_N {
    private Canvas canvas_ = null;
    private Component component_ = null;
    private Rectangle content_rect_ = new Rectangle(0, 0, 0, 0);
    private long window_handle_ = 0L;
    private boolean justCreated_ = false;
    private Timer delayedUpdate_ = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CefBrowserWr.this.isClosed()) {
                        return;
                    }
                    boolean bl = CefBrowserWr.this.createBrowserIfRequired(true);
                    if (bl) {
                        CefBrowserWr.this.delayedUpdate_.restart();
                    } else if (OS.isMacintosh() || OS.isLinux()) {
                        CefBrowserWr.this.doUpdate();
                    }
                }
            });
        }
    });
    private CefWindowHandlerAdapter win_handler_ = new CefWindowHandlerAdapter(){
        private Point lastPos = new Point(-1, -1);
        private long[] nextClick = new long[MouseInfo.getNumberOfButtons()];
        private int[] clickCnt = new int[MouseInfo.getNumberOfButtons()];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Rectangle getRect(CefBrowser cefBrowser) {
            Rectangle rectangle = CefBrowserWr.this.content_rect_;
            synchronized (rectangle) {
                return CefBrowserWr.this.content_rect_;
            }
        }

        @Override
        public void onMouseEvent(CefBrowser cefBrowser, int n, final int n2, final int n3, final int n4, final int n5) {
            final Point point = new Point(n2, n3);
            if (n == 503) {
                if (point.equals(this.lastPos)) {
                    return;
                }
                this.lastPos = point;
                if ((n4 & 0x400) != 0) {
                    n = 506;
                }
            }
            final int n6 = n;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component component = SwingUtilities.getRoot(CefBrowserWr.this.component_);
                    if (component == null) {
                        return;
                    }
                    SwingUtilities.convertPointFromScreen(point, component);
                    int n = 0;
                    long l = new Date().getTime();
                    if (n6 == 507) {
                        int n22 = 0;
                        int n32 = n5 > 0 ? 1 : -1;
                        CefBrowserWr.this.component_.dispatchEvent(new MouseWheelEvent(component, n6, l, n4, point.x, point.y, 0, false, n22, 3, n32));
                    } else {
                        n = this.getClickCount(n6, n5);
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(component, n6, l, n4, point.x, point.y, n2, n3, n, false, n5));
                    }
                    if (n6 == 502) {
                        CefBrowserWr.this.component_.dispatchEvent(new MouseEvent(component, 500, l, n4, point.x, point.y, n2, n3, n, false, n5));
                    }
                }
            });
        }

        public int getClickCount(int n, int n2) {
            int n3 = n2 % this.nextClick.length;
            switch (n) {
                case 501: {
                    long l = new Date().getTime();
                    if (l > this.nextClick[n3]) {
                        this.nextClick[n3] = l + (long)((Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval")).intValue();
                        this.clickCnt[n3] = 1;
                    } else {
                        int n4 = n3;
                        this.clickCnt[n4] = this.clickCnt[n4] + 1;
                    }
                }
                case 502: {
                    return this.clickCnt[n3];
                }
            }
            return 0;
        }
    };

    CefBrowserWr(CefClient cefClient, String string, CefRequestContext cefRequestContext) {
        this(cefClient, string, cefRequestContext, null, null);
    }

    private CefBrowserWr(CefClient cefClient, String string, CefRequestContext cefRequestContext, CefBrowserWr cefBrowserWr, Point point) {
        super(cefClient, string, cefRequestContext, cefBrowserWr, point);
        this.delayedUpdate_.setRepeats(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.component_ = new JPanel(new BorderLayout()){
            private boolean removed_;
            {
                this.removed_ = true;
            }

            @Override
            public void setBounds(int n, int n2, int n3, int n4) {
                super.setBounds(n, n2, n3, n4);
                CefBrowserWr.this.wasResized(n3, n4);
            }

            @Override
            public void setBounds(Rectangle rectangle) {
                this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }

            @Override
            public void setSize(int n, int n2) {
                super.setSize(n, n2);
                CefBrowserWr.this.wasResized(n, n2);
            }

            @Override
            public void setSize(Dimension dimension) {
                this.setSize(dimension.width, dimension.height);
            }

            @Override
            public void paint(Graphics graphics) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.delayedUpdate_.restart();
            }

            @Override
            public void addNotify() {
                super.addNotify();
                if (this.removed_) {
                    CefBrowserWr.this.setParent(CefBrowserWr.getWindowHandle(this), CefBrowserWr.this.canvas_);
                    this.removed_ = false;
                }
            }

            @Override
            public void removeNotify() {
                if (!this.removed_) {
                    if (!CefBrowserWr.this.isClosed()) {
                        CefBrowserWr.this.setParent(0L, null);
                    }
                    this.removed_ = true;
                }
                super.removeNotify();
            }
        };
        if (OS.isWindows() || OS.isLinux()) {
            this.canvas_ = new Canvas();
            ((JPanel)this.component_).add((Component)this.canvas_, "Center");
        }
        this.component_.setMinimumSize(new Dimension(0, 0));
        this.component_.setFocusable(true);
        this.component_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CefBrowserWr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserWr.this.setFocus(true);
            }
        });
        this.component_.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                CefBrowserWr.this.doUpdate();
            }

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                CefBrowserWr.this.doUpdate();
                CefBrowserWr.this.notifyMoveOrResizeStarted();
            }
        });
        this.component_.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    CefBrowserWr.this.setWindowVisibility(hierarchyEvent.getChanged().isVisible());
                }
            }
        });
    }

    @Override
    public void createImmediately() {
        this.justCreated_ = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserWr.this.createBrowserIfRequired(false);
            }
        });
    }

    @Override
    public Component getUIComponent() {
        return this.component_;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this.win_handler_;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient cefClient, String string, CefRequestContext cefRequestContext, CefBrowser_N cefBrowser_N, Point point) {
        return new CefBrowserWr(cefClient, string, cefRequestContext, this, point);
    }

    private synchronized long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            this.window_handle_ = CefBrowserWr.getWindowHandle(this.component_);
        }
        return this.window_handle_;
    }

    private static long getWindowHandle(Component component) {
        if (OS.isMacintosh()) {
            try {
                Class<?> clazz = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                CefBrowserWindow cefBrowserWindow = (CefBrowserWindow)clazz.newInstance();
                if (cefBrowserWindow != null) {
                    return cefBrowserWindow.getWindowHandle(component);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        if (this.isClosed()) {
            return;
        }
        Rectangle rectangle = ((JPanel)this.component_).getVisibleRect();
        if (OS.isMacintosh()) {
            Cloneable cloneable;
            Serializable serializable;
            Container container = this.component_.getParent();
            Point point = this.component_.getLocation();
            while (!(container == null || (serializable = container.getParent()) != null && serializable instanceof Window)) {
                cloneable = container.getLocation();
                point.translate(cloneable.x, cloneable.y);
                container = serializable;
            }
            point.translate(rectangle.x, rectangle.y);
            serializable = rectangle.getLocation();
            ((Point)serializable).x *= -1;
            ((Point)serializable).y *= -1;
            cloneable = this.content_rect_;
            synchronized (cloneable) {
                this.content_rect_ = new Rectangle(point, rectangle.getSize());
                Rectangle rectangle2 = new Rectangle((Point)serializable, this.component_.getSize());
                this.updateUI(this.content_rect_, rectangle2);
            }
        }
        Rectangle rectangle3 = this.content_rect_;
        synchronized (rectangle3) {
            this.content_rect_ = this.component_.getBounds();
            this.updateUI(rectangle, this.content_rect_);
        }
    }

    private boolean createBrowserIfRequired(boolean bl) {
        if (this.isClosed()) {
            return false;
        }
        long l = 0L;
        Component component = null;
        if (bl) {
            l = this.getWindowHandle();
            Component component2 = component = OS.isWindows() || OS.isLinux() ? this.canvas_ : this.component_;
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), l, false, false, component, this.getInspectAt());
                return true;
            }
            this.createBrowser(this.getClient(), l, this.getUrl(), false, false, component, this.getRequestContext());
            return true;
        }
        if (bl && this.justCreated_) {
            this.setParent(l, component);
            this.setFocus(true);
            this.justCreated_ = false;
        }
        return false;
    }
}

