/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AggregatedRange
implements Range<Double> {
    private Double positiveSum;
    private int positiveCount;
    private Double negativeSum;
    private int negativeCount;
    private List<Positionable> positions;

    public AggregatedRange() {
        this(null);
    }

    public AggregatedRange(Collection<Positionable> positions) {
        this.positions = positions == null ? new ArrayList<Positionable>() : new ArrayList<Positionable>(positions);
        Collections.sort(this.positions);
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    public int getCount() {
        return this.positions.size();
    }

    public double getPositiveSum() {
        if (this.positiveSum == null) {
            this.updatePositives();
        }
        return this.positiveSum;
    }

    public int getPositiveCount() {
        if (this.positiveSum == null) {
            this.updatePositives();
        }
        return this.positiveCount;
    }

    private void updatePositives() {
        double sum = 0.0;
        this.positiveCount = 0;
        if (this.positions != null) {
            for (Positionable pos : this.positions) {
                if (!(pos.position() >= 0.0)) continue;
                sum += pos.position();
                ++this.positiveCount;
            }
        }
        this.positiveSum = sum;
    }

    public double getNegativeSum() {
        if (this.negativeSum == null) {
            this.updateNegatives();
        }
        return this.negativeSum;
    }

    public int getNegativeCount() {
        if (this.negativeSum == null) {
            this.updateNegatives();
        }
        return this.negativeCount;
    }

    private void updateNegatives() {
        double sum = 0.0;
        this.negativeCount = 0;
        if (this.positions != null) {
            for (Positionable pos : this.positions) {
                if (!(pos.position() < 0.0)) continue;
                sum += pos.position();
                ++this.negativeCount;
            }
        }
        this.negativeSum = sum;
    }

    @Override
    public double minimum() {
        if (this.positions == null || this.positions.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Positionable first = this.positions.get(0);
        return first.position();
    }

    @Override
    public double maximum() {
        if (this.positions == null || this.positions.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Positionable last = this.positions.get(this.positions.size() - 1);
        return last.position();
    }

    @Override
    public double size() {
        return this.maximum() - this.minimum();
    }

    @Override
    public boolean contains(Double item) {
        return item != null && item >= this.minimum() && item <= this.maximum();
    }

    @Override
    public void adjust(Double lower, Double upper) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("An aggregated range is immutable");
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return new PropertyChangeListener[0];
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return new PropertyChangeListener[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedRange)) {
            return false;
        }
        AggregatedRange that = (AggregatedRange)o;
        if (this.negativeCount != that.negativeCount) {
            return false;
        }
        if (this.positiveCount != that.positiveCount) {
            return false;
        }
        if (this.negativeSum != null ? !this.negativeSum.equals(that.negativeSum) : that.negativeSum != null) {
            return false;
        }
        if (!JideSwingUtilities.equals(this.positions, that.positions, true)) {
            return false;
        }
        return !(this.positiveSum != null ? !this.positiveSum.equals(that.positiveSum) : that.positiveSum != null);
    }

    public int hashCode() {
        int result = this.positiveSum != null ? this.positiveSum.hashCode() : 0;
        result = 31 * result + this.positiveCount;
        result = 31 * result + (this.negativeSum != null ? this.negativeSum.hashCode() : 0);
        result = 31 * result + this.negativeCount;
        result = 31 * result + (this.positions != null ? ((Object)this.positions).hashCode() : 0);
        return result;
    }
}

