/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.async;

import com.caucho.config.j2ee.EJBExceptionWrapper;
import com.caucho.util.CurrentTime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncItem<X>
implements Runnable,
Future<X> {
    private static final Logger log = Logger.getLogger(AsyncItem.class.getName());
    private static final ThreadLocal<AsyncItem<?>> _localItem = new ThreadLocal();
    private boolean _isCancelled;
    private volatile boolean _isDone;
    private volatile Future<X> _result;
    private ExecutionException _executionException;

    public static boolean isThreadCancelled() {
        AsyncItem<?> item = _localItem.get();
        if (item != null) {
            return item.isCancelled();
        }
        return false;
    }

    public abstract Future<X> runTask() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        try {
            block12: {
                try {
                    _localItem.set(this);
                    this._result = this.runTask();
                    if (this._result == null) break block12;
                    this._result.get();
                }
                catch (RuntimeException e) {
                    log.log(Level.FINER, e.toString(), e);
                    this._executionException = new ExecutionException((Throwable)new EJBException((Exception)e));
                    Object var3_2 = null;
                    this._isDone = true;
                    _localItem.set(null);
                    AsyncItem asyncItem3 = this;
                    synchronized (asyncItem3) {
                        this.notifyAll();
                        return;
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    this._executionException = new ExecutionException(e);
                    Object var3_3 = null;
                    this._isDone = true;
                    _localItem.set(null);
                    AsyncItem asyncItem4 = this;
                    synchronized (asyncItem4) {
                        this.notifyAll();
                        return;
                    }
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                    this._executionException = new ExecutionException((Throwable)((Object)new EJBExceptionWrapper(e)));
                    Object var3_4 = null;
                    this._isDone = true;
                    _localItem.set(null);
                    AsyncItem asyncItem5 = this;
                    synchronized (asyncItem5) {
                        this.notifyAll();
                        return;
                    }
                }
            }
            Object var3_1 = null;
            this._isDone = true;
            _localItem.set(null);
            AsyncItem asyncItem = this;
            synchronized (asyncItem) {
                this.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this._isDone = true;
            _localItem.set(null);
            AsyncItem asyncItem2 = this;
            synchronized (asyncItem2) {
                this.notifyAll();
                throw throwable;
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            this._isCancelled = true;
        }
        return false;
    }

    @Override
    public X get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long expires = CurrentTime.getCurrentTimeActual() + timeoutMillis;
        AsyncItem asyncItem = this;
        synchronized (asyncItem) {
            while (!this._isDone) {
                long delta = expires - CurrentTime.getCurrentTimeActual();
                if (delta < 0L) {
                    throw new TimeoutException(this.toString());
                }
                Thread.interrupted();
                this.wait(delta);
            }
        }
        if (this._executionException != null) {
            throw this._executionException;
        }
        if (this._result != null) {
            return this._result.get(0L, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this._isCancelled;
    }

    @Override
    public boolean isDone() {
        return this._isDone;
    }

    public String toString() {
        if (this.getClass().getEnclosingMethod() != null) {
            return this.getClass().getEnclosingClass().getSimpleName() + "[" + this.getClass().getEnclosingMethod().getName() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }
}

