/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AsynchronousFactory;
import com.caucho.config.gen.NullGenerator;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AsynchronousGenerator<X>
extends NullGenerator<X> {
    private boolean _isAsynchronous;
    private String _varName;
    private AspectGenerator<X> _head;
    private AnnotatedMethod<? super X> _method;

    public AsynchronousGenerator(AsynchronousFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> head) {
        this._method = method;
        this._head = head;
    }

    public boolean isEnhanced() {
        return this._isAsynchronous;
    }

    public boolean isAsync() {
        return this._isAsynchronous;
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._head.generate(out, map);
        this._varName = "_caucho_async_" + out.generateId();
        out.print("private com.caucho.config.async.AsyncQueue " + this._varName);
        out.println(" = new com.caucho.config.async.AsyncQueue();");
    }

    @Override
    public void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        this._head.generate(out, prologueMap);
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        int i;
        Method javaApiMethod = this.getJavaMethod();
        Class<?>[] paramType = javaApiMethod.getParameterTypes();
        for (i = 0; i < paramType.length; ++i) {
            out.print("final ");
            out.printClass(paramType[i]);
            out.println(" ac_" + i + " = a" + i + ";");
        }
        out.println("com.caucho.config.async.AsyncItem task;");
        out.println("task = new com.caucho.config.async.AsyncItem() {");
        out.pushDepth();
        out.print("private ");
        out.print("com.caucho.network.listen.ProtocolConnection");
        out.println(" _requestContext");
        out.print("  = ");
        out.print("com.caucho.ejb.util.EjbUtil");
        out.println(".createRequestContext();");
        out.println();
        out.println("public java.util.concurrent.Future runTask() throws Exception");
        out.println("{");
        out.pushDepth();
        out.println();
        out.print("com.caucho.network.listen.ProtocolConnection");
        out.print(" oldContext = ");
        out.print("com.caucho.network.listen.TcpSocketLink");
        out.println(".getCurrentRequest();");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.print("com.caucho.network.listen.TcpSocketLink");
        out.println(".setCurrentRequest(_requestContext);");
        out.println();
        if (!Void.TYPE.equals(javaApiMethod.getReturnType())) {
            out.print("return ");
        }
        out.print(javaApiMethod.getName() + "_async(");
        for (i = 0; i < paramType.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("ac_" + i);
        }
        out.println(");");
        if (Void.TYPE.equals(javaApiMethod.getReturnType())) {
            out.println();
            out.println("return null;");
        }
        out.popDepth();
        out.println("} finally {");
        out.pushDepth();
        out.print("com.caucho.network.listen.TcpSocketLink");
        out.println(".setCurrentRequest(oldContext);");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("};");
        out.println(this._varName + ".offer(task);");
        if (!Void.TYPE.equals(javaApiMethod.getReturnType())) {
            out.println("result = task;");
        }
    }

    protected Method getJavaMethod() {
        return this._method.getJavaMember();
    }
}

