/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.InterceptorException;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandiInvocationContext
implements InvocationContext {
    private static final L10N L = new L10N(CandiInvocationContext.class);
    private static final EnvironmentLocal<Map<String, Object>> _contextDataLocal = new EnvironmentLocal();
    private static final HashMap<Class<?>, Class<?>> _boxMap = new HashMap();
    private final Object _target;
    private final Method _apiMethod;
    private final Method _implMethod;
    private final Interceptor[] _chainMethods;
    private final Object[] _chainObjects;
    private final int[] _chainIndex;
    private final InterceptionType _type;
    private Object[] _param;
    private int _index;

    public CandiInvocationContext(InterceptionType type, Object target, Method apiMethod, Method implMethod, Interceptor<?>[] chainMethods, Object[] chainObjects, int[] chainIndex, Object[] param) {
        this._target = target;
        this._type = type;
        this._apiMethod = apiMethod;
        this._implMethod = implMethod;
        this._chainMethods = chainMethods;
        this._chainObjects = chainObjects;
        this._chainIndex = chainIndex;
        this._param = param;
    }

    public Object getTarget() {
        return this._target;
    }

    public Method getMethod() {
        return this._apiMethod;
    }

    public Object getTimer() {
        return null;
    }

    public Object[] getParameters() throws IllegalStateException {
        if (this._param != null) {
            return this._param;
        }
        throw new IllegalStateException(L.l("No parameters are allowed in this context"));
    }

    public void setParameters(Object[] parameters) throws IllegalStateException {
        Class<?>[] paramType = this._apiMethod.getParameterTypes();
        if (parameters == null) {
            throw new IllegalArgumentException(L.l("{0}.{1}: interception parameters cannot be null", (Object)this._apiMethod.getDeclaringClass().getName(), (Object)this._apiMethod.getName()));
        }
        if (paramType.length != parameters.length) {
            throw new IllegalArgumentException(L.l("{0}.{1}: interception parameters '{2}' do not match the expected '{3}'", (Object)this._apiMethod.getDeclaringClass().getName(), (Object)this._apiMethod.getName(), (Object)parameters.length, (Object)paramType.length));
        }
        for (int i = paramType.length - 1; i >= 0; --i) {
            Object value = parameters[i];
            Class<?> argType = this.getArgType(paramType[i]);
            if (value == null || argType.isAssignableFrom(value.getClass())) continue;
            throw new IllegalArgumentException(L.l("{0}.{1}: interception parameters '{2}' do not match the expected '{3}'", (Object)this._apiMethod.getDeclaringClass().getName(), (Object)this._apiMethod.getName(), value, (Object)paramType[i].getName()));
        }
        this._param = parameters;
    }

    public static Map<String, Object> getCurrentContextData() {
        Map<String, Object> contextData = _contextDataLocal.get();
        if (contextData == null) {
            contextData = new HashMap<String, Object>();
            _contextDataLocal.set(contextData);
        }
        return contextData;
    }

    public Map<String, Object> getContextData() {
        return CandiInvocationContext.getCurrentContextData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object proceed() throws Exception {
        boolean isTop = this._index == 0;
        try {
            Object i2;
            try {
                Object result;
                if (this._chainObjects != null && this._index < this._chainIndex.length) {
                    int i2;
                    if (this._chainObjects[this._chainIndex[i2 = this._index++]] == null) {
                        throw new NullPointerException(i2 + " index[i]=" + this._chainIndex[i2] + " " + this._type + " " + this._chainMethods[i2]);
                    }
                    result = this._chainMethods[i2].intercept(this._type, this._chainObjects[this._chainIndex[i2]], (InvocationContext)this);
                } else {
                    result = this._implMethod.invoke(this._target, this._param);
                }
                i2 = result;
                Object var5_12 = null;
                if (!isTop) return i2;
            }
            catch (InterceptorException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof Exception)) throw e;
                throw (Exception)cause;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof Exception)) throw e;
                throw (Exception)cause;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e + "\n  " + this._implMethod + "\n  " + this._target, e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            _contextDataLocal.set(null);
            return i2;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            if (!isTop) throw throwable;
            _contextDataLocal.set(null);
            throw throwable;
        }
    }

    private Class<?> getArgType(Class<?> type) {
        Class<?> boxType = _boxMap.get(type);
        if (boxType != null) {
            return boxType;
        }
        return type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._implMethod.getName() + "]";
    }

    static {
        _boxMap.put(Boolean.TYPE, Boolean.class);
        _boxMap.put(Character.TYPE, Character.class);
        _boxMap.put(Byte.TYPE, Byte.class);
        _boxMap.put(Short.TYPE, Short.class);
        _boxMap.put(Integer.TYPE, Integer.class);
        _boxMap.put(Long.TYPE, Long.class);
        _boxMap.put(Float.TYPE, Float.class);
        _boxMap.put(Double.TYPE, Double.class);
    }
}

