/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.AnnotatedBean;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.DisplayableInjectionTarget;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.xml.XmlCookie;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.NullOutputStream;
import com.caucho.util.Sha256OutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.Nonbinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T>
implements Bean<T>,
ObjectProxy,
AnnotatedBean {
    private static final L10N L = new L10N(AbstractBean.class);
    private static final Logger log = Logger.getLogger(AbstractBean.class.getName());
    private static final Set<Annotation> _currentBindings;
    private static final Set<InjectionPoint> _nullInjectionPoints;
    private InjectManager _beanManager;
    private String _passivationId;

    public AbstractBean(InjectManager beanManager) {
        this._beanManager = beanManager;
    }

    public InjectManager getBeanManager() {
        return this._beanManager;
    }

    public String getId() {
        if (this._passivationId == null) {
            this._passivationId = this.calculatePassivationId();
        }
        return this._passivationId;
    }

    @Override
    public Annotated getAnnotated() {
        return null;
    }

    public AnnotatedType<T> getAnnotatedType() {
        Annotated annotated = this.getAnnotated();
        if (annotated instanceof AnnotatedType) {
            return (AnnotatedType)annotated;
        }
        return null;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return null;
    }

    public void introspect() {
    }

    public abstract T create(CreationalContext<T> var1);

    public void destroy(T instance, CreationalContext<T> env) {
    }

    public abstract Set<Type> getTypes();

    public Class<?> getBeanClass() {
        return null;
    }

    public Class<?> getJavaClass() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return _currentBindings;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return null;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return _nullInjectionPoints;
    }

    public String getName() {
        return null;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isPassivationCapable() {
        return false;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    protected String calculatePassivationId() {
        try {
            XmlCookie xmlCookie;
            Sha256OutputStream os = new Sha256OutputStream(new NullOutputStream());
            WriteStream out = Vfs.openWrite(os);
            out.print(this.getJavaClass());
            ArrayList<String> typeList = new ArrayList<String>();
            for (Type type : this.getTypes()) {
                typeList.add(type.toString());
            }
            Collections.sort(typeList);
            for (String typeString : typeList) {
                out.print(";");
                out.print(typeString);
            }
            if (this.getName() != null) {
                out.print(";name=");
                out.print(this.getName());
            }
            ArrayList<String> annList = new ArrayList<String>();
            for (Annotation ann : this.getQualifiers()) {
                annList.add(this.bindingToString(ann));
            }
            Collections.sort(annList);
            for (String annString : annList) {
                out.print(";");
                out.print(annString);
            }
            if (this.getAnnotatedType() != null && (xmlCookie = (XmlCookie)this.getAnnotatedType().getAnnotation(XmlCookie.class)) != null) {
                out.print(";xmlcookie=" + xmlCookie.value());
            }
            out.close();
            return Base64.encodeFromByteArray(os.getDigest());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String bindingToString(Annotation ann) {
        StringBuilder sb = new StringBuilder(ann.annotationType().getName());
        ArrayList<String> propList = new ArrayList<String>();
        for (Method method : ann.annotationType().getDeclaredMethods()) {
            if (method.getName().equals("annotationType") || method.isAnnotationPresent(Nonbinding.class) || method.getParameterTypes().length != 0) continue;
            try {
                String prop = method.getName() + "," + method.invoke((Object)ann, new Object[0]);
                propList.add(prop);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString());
            }
        }
        Collections.sort(propList);
        for (String prop : propList) {
            sb.append(",").append(prop);
        }
        return sb.toString();
    }

    public Object createObject(Hashtable env) {
        return this._beanManager.getReference(this);
    }

    public String toDisplayString() {
        URL url;
        if (this.getInjectionTarget() instanceof DisplayableInjectionTarget) {
            return ((DisplayableInjectionTarget)this.getInjectionTarget()).toDisplayString();
        }
        if (this.getBeanClass() == null) {
            return this.toString();
        }
        String display = this.toDisplayStringImpl();
        Class<?> beanClass = this.getBeanClass();
        if (beanClass.getClassLoader() != null && (url = beanClass.getResource("")) != null) {
            return display + "\n  in " + url;
        }
        return display;
    }

    protected String toDisplayStringImpl() {
        StringBuilder sb = new StringBuilder();
        Class<?> beanClass = this.getBeanClass();
        sb.append(beanClass.getName());
        sb.append("[");
        ArrayList<Annotation> bindings = new ArrayList<Annotation>(this.getQualifiers());
        for (int i = 0; i < bindings.size(); ++i) {
            Annotation ann = bindings.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(ann);
        }
        if (this.getName() != null) {
            sb.append(", ");
            sb.append("@Named=");
            sb.append(this.getName());
        }
        if (this.getScope() != null && this.getScope() != Dependent.class) {
            sb.append(", @");
            sb.append(this.getScope().getSimpleName());
        }
        sb.append(", " + this.getClass().getSimpleName());
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.getBeanClass() != null) {
            sb.append(this.getBeanClass().getSimpleName());
        }
        sb.append(", {");
        ArrayList<Annotation> bindings = new ArrayList<Annotation>(this.getQualifiers());
        for (int i = 0; i < bindings.size(); ++i) {
            Annotation ann = bindings.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(ann);
        }
        sb.append("}");
        if (this.getName() != null) {
            sb.append(", ");
            sb.append("name=");
            sb.append(this.getName());
        }
        if (this.getScope() != null && this.getScope() != Dependent.class) {
            sb.append(", @");
            sb.append(this.getScope().getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        _nullInjectionPoints = new HashSet<InjectionPoint>();
        _currentBindings = new HashSet<Annotation>();
        _currentBindings.add((Annotation)DefaultLiteral.DEFAULT);
    }
}

