/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.BoxType;
import com.caucho.config.reflect.ObjectType;
import com.caucho.inject.Module;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ClassType
extends BaseType {
    public static final ObjectType OBJECT_TYPE;
    private static final HashMap<Class<?>, ClassType> _classTypeMap;
    private static final HashSet<Class<?>> _classTypeIgnoreSet;
    private Class<?> _type;

    protected ClassType(Class<?> type) {
        this._type = type;
    }

    public static ClassType create(Class<?> type) {
        ClassType classType = _classTypeMap.get(type);
        if (classType != null) {
            return classType;
        }
        return new ClassType(type);
    }

    @Override
    public Class<?> getRawClass() {
        return this._type;
    }

    @Override
    public Type toType() {
        return this._type;
    }

    @Override
    public boolean isAssignableFrom(BaseType type) {
        if (type.isWildcard() || type.isVariable()) {
            for (BaseType bound : type.getWildcardBounds()) {
                if (this.isAssignableFrom(bound)) continue;
                return false;
            }
            return true;
        }
        if (!this._type.isAssignableFrom(type.getRawClass())) {
            return false;
        }
        if (type.getParameters().length > 0) {
            for (BaseType param : type.getParameters()) {
                if (OBJECT_TYPE.isParamAssignableFrom(param)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isParamAssignableFrom(BaseType type) {
        if (type.isWildcard() || type.isVariable()) {
            boolean isMatchBound = true;
            for (BaseType bound : type.getWildcardBounds()) {
                if (bound.isObject()) continue;
                if (!bound.isAssignableFrom(this)) {
                    return false;
                }
                isMatchBound = true;
            }
            return isMatchBound;
        }
        return this._type.equals(type.getRawClass());
    }

    @Override
    public BaseType fill(BaseType ... baseType) {
        return this;
    }

    @Override
    public void fillTypeClosure(InjectManager manager, Set<Type> typeSet) {
        Type ownType = this.toType();
        if (_classTypeIgnoreSet.contains(ownType)) {
            return;
        }
        typeSet.add(ownType);
        for (Type type : this._type.getGenericInterfaces()) {
            BaseType ifaceType = manager.createSourceBaseType(type);
            ifaceType.fillTypeClosure(manager, typeSet);
        }
        Type superclass = this._type.getGenericSuperclass();
        if (superclass != null) {
            BaseType superType = manager.createSourceBaseType(superclass);
            superType.fillTypeClosure(manager, typeSet);
        } else if (this._type.isInterface()) {
            typeSet.add((Type)((Object)Object.class));
        }
    }

    public int hashCode() {
        return this._type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassType)) {
            return false;
        }
        ClassType type = (ClassType)o;
        return this._type.equals(type._type);
    }

    @Override
    public String toString() {
        return this.getRawClass().toString();
    }

    static {
        _classTypeMap = new HashMap();
        _classTypeIgnoreSet = new HashSet();
        _classTypeMap.put(Boolean.TYPE, new BoxType(Boolean.TYPE, Boolean.class));
        _classTypeMap.put(Boolean.class, new ClassType(Boolean.class));
        _classTypeMap.put(Character.TYPE, new BoxType(Character.TYPE, Character.class));
        _classTypeMap.put(Character.class, new ClassType(Character.class));
        _classTypeMap.put(Byte.TYPE, new BoxType(Byte.TYPE, Byte.class));
        _classTypeMap.put(Byte.class, new ClassType(Byte.class));
        _classTypeMap.put(Short.TYPE, new BoxType(Short.TYPE, Short.class));
        _classTypeMap.put(Short.class, new ClassType(Short.class));
        _classTypeMap.put(Integer.TYPE, new BoxType(Integer.TYPE, Integer.class));
        _classTypeMap.put(Integer.class, new ClassType(Integer.class));
        _classTypeMap.put(Long.TYPE, new BoxType(Long.TYPE, Long.class));
        _classTypeMap.put(Long.class, new ClassType(Long.class));
        _classTypeMap.put(Float.TYPE, new BoxType(Float.TYPE, Float.class));
        _classTypeMap.put(Float.class, new ClassType(Float.class));
        _classTypeMap.put(Double.TYPE, new BoxType(Double.TYPE, Double.class));
        _classTypeMap.put(Double.class, new ClassType(Double.class));
        _classTypeMap.put(String.class, new ClassType(String.class));
        OBJECT_TYPE = ObjectType.OBJECT_TYPE;
        _classTypeMap.put(Object.class, OBJECT_TYPE);
        _classTypeIgnoreSet.add(Serializable.class);
        _classTypeIgnoreSet.add(Cloneable.class);
    }
}

