/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.IntegerType;
import com.caucho.util.L10N;

public final class ByteType
extends ConfigType {
    private static final L10N L = new L10N(IntegerType.class);
    public static final ByteType TYPE = new ByteType();
    private static final Byte ZERO = new Byte(0);

    private ByteType() {
    }

    public Class getType() {
        return Byte.class;
    }

    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Byte.valueOf(text);
    }

    public Object valueOf(Object value) {
        if (value instanceof Byte) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to a Byte", value));
    }
}

