/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.Marshall;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExpr
extends Expr {
    private transient ConcurrentHashMap<Class<?>, MethodCall> _methodMap = new ConcurrentHashMap();
    private Expr _expr;
    private String _methodName;
    private Expr[] _args;

    public MethodExpr(Expr expr, String methodName, Expr[] args) {
        this._expr = expr;
        this._methodName = methodName;
        this._args = args;
    }

    @Override
    public Object getValue(ELContext env) throws ELException {
        Object aObj = this._expr.getValue(env);
        if (aObj == null) {
            return null;
        }
        Object[] objs = new Object[this._args.length];
        try {
            MethodCall methodCall = this.findMethod(aObj.getClass());
            if (methodCall != null) {
                Marshall[] marshall = methodCall.getMarshall();
                for (int j = 0; j < marshall.length; ++j) {
                    objs[j] = marshall[j].marshall(this._args[j], env);
                }
                return methodCall.getMethod().invoke(aObj, objs);
            }
            return null;
        }
        catch (Exception e) {
            return MethodExpr.invocationError(e);
        }
    }

    @Override
    public Object invoke(ELContext env, Class<?>[] argTypes, Object[] args) throws ELException {
        if (args != null && args.length != 0) {
            throw new ELException(L.l("'{0}' is an illegal method invocation on {1}", (Object)this.toString(), (Object)((Object)((Object)this)).getClass().getName()));
        }
        return this.getValue(env);
    }

    private MethodCall findMethod(Class<?> type) {
        if (type == null) {
            return null;
        }
        MethodCall method = this.getMethodMap().get(type);
        if (method == null && (method = this.findMethodImpl(type)) != null) {
            this.getMethodMap().put(type, method);
        }
        return method;
    }

    private MethodCall findMethodImpl(Class<?> type) {
        Object method;
        int i;
        if (type == null) {
            return null;
        }
        if (Modifier.isPublic(type.getModifiers())) {
            Method[] methods = type.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (!Modifier.isPublic(((Method)method).getModifiers())) continue;
                Class<?>[] params = ((Method)method).getParameterTypes();
                if (!((Method)method).getName().equals(this._methodName) || params.length != this._args.length) continue;
                return new MethodCall((Method)method);
            }
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            method = this.findMethod(interfaces[i]);
            if (method == null) continue;
            return method;
        }
        return this.findMethod(type.getSuperclass());
    }

    private Map<Class<?>, MethodCall> getMethodMap() {
        if (this._methodMap == null) {
            this._methodMap = new ConcurrentHashMap();
        }
        return this._methodMap;
    }

    static Object evalArg(Class<?> cl, Expr expr, ELContext env) throws ELException {
        Marshall marshall = Marshall.create(cl);
        return marshall.marshall(expr, env);
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.MethodExpr(");
        this._expr.printCreate(os);
        os.print(", \"");
        os.print(this._methodName);
        os.print("\", new com.caucho.el.Expr[] {");
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this._args[i].printCreate(os);
        }
        os.println("})");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MethodExpr)) {
            return false;
        }
        MethodExpr expr = (MethodExpr)((Object)o);
        if (!this._expr.equals((Object)expr._expr)) {
            return false;
        }
        if (!this._methodName.equals(expr._methodName)) {
            return false;
        }
        if (this._args.length != expr._args.length) {
            return false;
        }
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i].equals((Object)expr._args[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "MethodExpr[" + (Object)((Object)this._expr) + "," + this._methodName + "]";
    }

    private static class MethodCall {
        private final Method _method;
        private final Marshall[] _marshall;

        MethodCall(Method method) {
            this._method = method;
            try {
                method.setAccessible(true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            this._marshall = new Marshall[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this._marshall[i] = Marshall.create(paramTypes[i]);
            }
        }

        public Method getMethod() {
            return this._method;
        }

        public Marshall[] getMarshall() {
            return this._marshall;
        }
    }
}

