/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLiteralValueExpression
extends ValueExpression {
    private Object _object;
    private Class<?> _expectedType;

    public ObjectLiteralValueExpression(Object object, Class<?> expectedType) {
        this._object = object;
        this._expectedType = expectedType;
    }

    public Class<?> getExpectedType() {
        return this._expectedType;
    }

    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        if (this._object == null) {
            return null;
        }
        return this._object.getClass();
    }

    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        return Expr.coerceToType(this._object, this._expectedType);
    }

    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        return true;
    }

    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        throw new PropertyNotWritableException("can't change underlying object");
    }

    public String getExpressionString() {
        if (this._object == null) {
            return null;
        }
        return this._object.toString();
    }

    public boolean isLiteralText() {
        return true;
    }

    public int hashCode() {
        if (this._object == null) {
            return 0;
        }
        return this._object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectLiteralValueExpression)) {
            return false;
        }
        ObjectLiteralValueExpression valExpr = (ObjectLiteralValueExpression)((Object)obj);
        if (!this._expectedType.equals(valExpr._expectedType)) {
            return false;
        }
        if (this._object == valExpr._object) {
            return true;
        }
        return this._object != null && this._object.equals(valExpr._object);
    }
}

