/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class AverageTimeMeter
extends AbstractMeter {
    private final AtomicLong _sum = new AtomicLong();
    private final AtomicInteger _count = new AtomicInteger();
    private double _value;

    public AverageTimeMeter(String name) {
        super(name);
    }

    public final void addData(long time) {
        long oldValue;
        while (!this._sum.compareAndSet(oldValue = this._sum.get(), oldValue + time)) {
        }
        this._count.incrementAndGet();
    }

    public final void sample() {
        long sum = this._sum.getAndSet(0L);
        int count = this._count.getAndSet(0);
        this._value = count != 0 ? (double)sum / (double)count : 0.0;
    }

    public final double calculate() {
        return this._value;
    }
}

