/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.LineMap;
import com.caucho.util.CurrentTime;
import com.caucho.util.DisplayableException;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractJavaCompiler
implements Runnable {
    protected static final L10N L = new L10N(AbstractJavaCompiler.class);
    protected static final Logger log = Logger.getLogger(AbstractJavaCompiler.class.getName());
    private ClassLoader _loader;
    protected JavaCompilerUtil _compiler;
    private final AtomicBoolean _isDone = new AtomicBoolean();
    private String[] _path;
    private LineMap _lineMap;
    private Throwable _exception;

    public AbstractJavaCompiler(JavaCompilerUtil compiler) {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._compiler = compiler;
    }

    public void setPath(String[] path) {
        this._path = path;
    }

    public void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public Throwable getException() {
        return this._exception;
    }

    public boolean isDone() {
        return this._isDone.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            try {
                thread.setContextClassLoader(this._loader);
                this.compileInt(this._path, this._lineMap);
            }
            catch (Throwable e) {
                if (e instanceof DisplayableException) {
                    log.fine(e.getMessage());
                } else {
                    log.fine(e.toString());
                }
                log.log(Level.FINEST, e.toString(), e);
                this._exception = e;
                Object var4_3 = null;
                thread.setContextClassLoader(null);
                this.notifyComplete();
            }
            Object var4_2 = null;
            thread.setContextClassLoader(null);
            this.notifyComplete();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(null);
            this.notifyComplete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForComplete(long timeout) {
        long endTime = CurrentTime.getCurrentTimeActual() + timeout;
        AtomicBoolean atomicBoolean = this._isDone;
        synchronized (atomicBoolean) {
            while (!this.isDone() && CurrentTime.getCurrentTimeActual() <= endTime) {
                Thread.interrupted();
                try {
                    this._isDone.wait(endTime - CurrentTime.getCurrentTimeActual());
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyComplete() {
        AtomicBoolean atomicBoolean = this._isDone;
        synchronized (atomicBoolean) {
            this._isDone.set(true);
            this._isDone.notifyAll();
        }
    }

    public void abort() {
    }

    protected abstract void compileInt(String[] var1, LineMap var2) throws IOException;
}

