/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.Description;
import com.caucho.jmx.Name;
import com.caucho.jmx.OpenModelMethod;
import com.caucho.jmx.Unmarshall;
import com.caucho.jmx.UnmarshallArray;
import com.caucho.jmx.UnmarshallMBean;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class IntrospectionMBean
implements DynamicMBean {
    private static final L10N L = new L10N(IntrospectionMBean.class);
    private static final Logger log = Logger.getLogger(IntrospectionMBean.class.getName());
    private static final Class[] NULL_ARG = new Class[0];
    private static final Class _descriptionAnn;
    private static final Class _nameAnn;
    private static final WeakHashMap<Class, SoftReference<MBeanInfo>> _cachedInfo;
    private final Object _impl;
    private final Class _mbeanInterface;
    private final boolean _isLowercaseAttributeNames;
    private final MBeanInfo _mbeanInfo;
    private final HashMap<String, OpenModelMethod> _attrGetMap = new HashMap();
    private static final Comparator<MBeanFeatureInfo> MBEAN_FEATURE_INFO_COMPARATOR;

    public IntrospectionMBean(Object impl, Class mbeanInterface) throws NotCompliantMBeanException {
        this(impl, mbeanInterface, false);
    }

    public IntrospectionMBean(Object impl, Class mbeanInterface, boolean isLowercaseAttributeNames) throws NotCompliantMBeanException {
        if (impl == null) {
            throw new NullPointerException();
        }
        this._mbeanInterface = mbeanInterface;
        this._isLowercaseAttributeNames = isLowercaseAttributeNames;
        this._mbeanInfo = IntrospectionMBean.introspect(impl, mbeanInterface, isLowercaseAttributeNames);
        this._impl = impl;
    }

    public Object getImplementation() {
        return this._impl;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            OpenModelMethod method = this.getGetMethod(attribute);
            if (method != null) {
                return method.invoke(this._impl, null);
            }
            throw new AttributeNotFoundException(L.l("'{0}' is an unknown attribute in '{1}'", (Object)attribute, (Object)this._mbeanInterface.getName()));
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw new ReflectionException((Exception)e.getCause());
            }
            throw (Error)e.getCause();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Method method = this.getSetMethod(attribute.getName(), attribute.getValue());
            if (method == null) {
                throw new AttributeNotFoundException(attribute.getName());
            }
            method.invoke(this._impl, attribute.getValue());
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.toString());
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                OpenModelMethod method = this.getGetMethod(attributes[i]);
                if (method == null) continue;
                Object value = method.invoke(this._impl, null);
                list.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            try {
                Attribute attr = (Attribute)attributes.get(i);
                Method method = this.getSetMethod(attr.getName(), attr.getValue());
                if (method == null) continue;
                method.invoke(this._impl, attr.getValue());
                list.add(new Attribute(attr.getName(), attr.getValue()));
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenModelMethod getGetMethod(String name) {
        OpenModelMethod method;
        HashMap<String, OpenModelMethod> hashMap = this._attrGetMap;
        synchronized (hashMap) {
            method = this._attrGetMap.get(name);
        }
        if (method != null) {
            return method;
        }
        method = this.createGetMethod(name);
        if (method != null) {
            hashMap = this._attrGetMap;
            synchronized (hashMap) {
                this._attrGetMap.put(name, method);
            }
        }
        return method;
    }

    private OpenModelMethod createGetMethod(String name) {
        String methodName;
        if (this._isLowercaseAttributeNames) {
            StringBuilder builder = new StringBuilder(name);
            builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
            methodName = builder.toString();
        } else {
            methodName = name;
        }
        String getName = "get" + methodName;
        String isName = "is" + methodName;
        Method[] methods = this._mbeanInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(getName) && !methods[i].getName().equals(isName) || (args = methods[i].getParameterTypes()).length != 0 || methods[i].getReturnType().equals(Void.TYPE)) continue;
            Class<?> retType = methods[i].getReturnType();
            return new OpenModelMethod(methods[i], this.createUnmarshall(retType));
        }
        return null;
    }

    private Unmarshall createUnmarshall(Class cl) {
        Class<?> componentType;
        Unmarshall mbean = this.getMBeanObjectName(cl);
        if (mbean != null) {
            return mbean;
        }
        if (cl.isArray() && (mbean = this.getMBeanObjectName(componentType = cl.getComponentType())) != null) {
            return new UnmarshallArray(ObjectName.class, mbean);
        }
        return Unmarshall.IDENTITY;
    }

    private Unmarshall getMBeanObjectName(Class cl) {
        try {
            Method method = cl.getMethod("getObjectName", new Class[0]);
            if (method != null && ObjectName.class.equals(method.getReturnType())) {
                return new UnmarshallMBean(method);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return null;
    }

    private Method getSetMethod(String name, Object value) {
        String methodName;
        if (this._isLowercaseAttributeNames) {
            StringBuilder builder = new StringBuilder(name);
            builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
            methodName = builder.toString();
        } else {
            methodName = name;
        }
        String setName = "set" + methodName;
        Method[] methods = this._mbeanInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(setName) || (args = methods[i].getParameterTypes()).length != 1) continue;
            return methods[i];
        }
        return null;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Method[] methods = this._mbeanInterface.getMethods();
            int length = 0;
            if (signature != null) {
                length = signature.length;
            }
            if (params != null) {
                length = params.length;
            }
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] args;
                if (!methods[i].getName().equals(actionName) || (args = methods[i].getParameterTypes()).length != length) continue;
                boolean isMatch = true;
                for (int j = length - 1; j >= 0; --j) {
                    if (signature == null || args[j].getName().equals(signature[j])) continue;
                    isMatch = false;
                }
                if (!isMatch) continue;
                return methods[i].invoke(this._impl, params);
            }
            if (actionName.equals("hashCode") && (signature == null || signature.length == 0)) {
                return this._impl.hashCode();
            }
            if (actionName.equals("toString") && (signature == null || signature.length == 0)) {
                return this._impl.toString();
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw new ReflectionException((Exception)e.getCause());
            }
            throw (Error)e.getCause();
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }

    static MBeanInfo introspect(Object obj, Class cl, boolean isLowercaseAttributeNames) throws NotCompliantMBeanException {
        try {
            MBeanInfo modelInfo;
            NotificationBroadcaster broadcaster;
            MBeanNotificationInfo[] notifs;
            SoftReference<MBeanInfo> infoRef = _cachedInfo.get(cl);
            MBeanInfo info = null;
            if (infoRef != null && (info = infoRef.get()) != null) {
                return info;
            }
            String className = cl.getName();
            HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
            ArrayList constructors = new ArrayList();
            ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
            Method[] methods = cl.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String attributeName;
                StringBuilder builder;
                Method setter;
                String name;
                Method getter;
                Method method = methods[i];
                if (method.getDeclaringClass() == Object.class || Modifier.isStatic(method.getModifiers())) continue;
                String methodName = method.getName();
                Class<?>[] args = method.getParameterTypes();
                Class<?> retType = method.getReturnType();
                if (methodName.startsWith("get") && args.length == 0 && !retType.equals(Void.TYPE)) {
                    getter = method;
                    name = methodName.substring(3);
                    setter = IntrospectionMBean.getSetter(methods, name, retType);
                    if (isLowercaseAttributeNames) {
                        builder = new StringBuilder(name);
                        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                        attributeName = builder.toString();
                    } else {
                        attributeName = name;
                    }
                    Class<?> type = method.getReturnType();
                    MBeanAttributeInfo attr = new MBeanAttributeInfo(attributeName, IntrospectionMBean.getDescription(method), getter, setter);
                    if (attributes.get(attributeName) != null) continue;
                    attributes.put(attributeName, attr);
                    continue;
                }
                if (methodName.startsWith("is") && args.length == 0 && (retType.equals(Boolean.TYPE) || retType.equals(Boolean.class))) {
                    getter = method;
                    name = methodName.substring(2);
                    setter = IntrospectionMBean.getSetter(methods, name, retType);
                    if (isLowercaseAttributeNames) {
                        builder = new StringBuilder(name);
                        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                        attributeName = builder.toString();
                    } else {
                        attributeName = name;
                    }
                    if (attributes.get(attributeName) != null) continue;
                    attributes.put(attributeName, new MBeanAttributeInfo(attributeName, IntrospectionMBean.getDescription(method), getter, setter));
                    continue;
                }
                if (methodName.startsWith("set") && args.length == 1) {
                    Method setter2 = method;
                    name = methodName.substring(3);
                    Method getter2 = IntrospectionMBean.getGetter(methods, name, args[0]);
                    if (getter2 != null) continue;
                    if (isLowercaseAttributeNames) {
                        builder = new StringBuilder(name);
                        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
                        attributeName = builder.toString();
                    } else {
                        attributeName = name;
                    }
                    if (attributes.get(attributeName) != null) continue;
                    attributes.put(attributeName, new MBeanAttributeInfo(attributeName, IntrospectionMBean.getDescription(method), null, setter2));
                    continue;
                }
                operations.add(new MBeanOperationInfo(IntrospectionMBean.getName(method), IntrospectionMBean.getDescription(method), IntrospectionMBean.getSignature(method), method.getReturnType().getName(), 3));
            }
            ArrayList<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
            if (obj instanceof NotificationBroadcaster && (notifs = (broadcaster = (NotificationBroadcaster)obj).getNotificationInfo()) != null) {
                for (int i = 0; i < notifs.length; ++i) {
                    MBeanNotificationInfo notif = notifs[i];
                    notifications.add((MBeanNotificationInfo)notifs[i].clone());
                }
            }
            Collections.sort(notifications, MBEAN_FEATURE_INFO_COMPARATOR);
            MBeanAttributeInfo[] attrArray = new MBeanAttributeInfo[attributes.size()];
            attributes.values().toArray(attrArray);
            Arrays.sort(attrArray, MBEAN_FEATURE_INFO_COMPARATOR);
            MBeanConstructorInfo[] conArray = new MBeanConstructorInfo[constructors.size()];
            constructors.toArray(conArray);
            MBeanOperationInfo[] opArray = new MBeanOperationInfo[operations.size()];
            operations.toArray(opArray);
            Arrays.sort(opArray, MBEAN_FEATURE_INFO_COMPARATOR);
            MBeanNotificationInfo[] notifArray = new MBeanNotificationInfo[notifications.size()];
            notifications.toArray(notifArray);
            Arrays.sort(notifArray, MBEAN_FEATURE_INFO_COMPARATOR);
            info = modelInfo = new MBeanInfo(cl.getName(), IntrospectionMBean.getDescription(cl), attrArray, conArray, opArray, notifArray);
            _cachedInfo.put(cl, new SoftReference<MBeanInfo>(info));
            return info;
        }
        catch (Exception e) {
            NotCompliantMBeanException exn = new NotCompliantMBeanException(String.valueOf(e));
            exn.initCause(e);
            throw exn;
        }
    }

    static Method getSetter(Method[] methods, String property, Class type) {
        String name = "set" + property;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] args;
            if (!methods[i].getName().equals(name) || (args = methods[i].getParameterTypes()).length != 1 || !args[0].equals(type)) continue;
            return methods[i];
        }
        return null;
    }

    static Method getGetter(Method[] methods, String property, Class type) {
        String getName = "get" + property;
        String isName = "is" + property;
        for (int i = 0; i < methods.length; ++i) {
            Class<?> retType;
            Class<?>[] args;
            if (!methods[i].getName().equals(getName) && !methods[i].getName().equals(isName) || (args = methods[i].getParameterTypes()).length != 0 || !(retType = methods[i].getReturnType()).equals(type)) continue;
            return methods[i];
        }
        return null;
    }

    static String getDescription(Class cl) {
        try {
            Description desc = (Description)cl.getAnnotation(_descriptionAnn);
            if (desc != null) {
                return desc.value();
            }
            return "";
        }
        catch (Throwable e) {
            return "";
        }
    }

    static String getDescription(Method method) {
        try {
            Description desc = (Description)method.getAnnotation(_descriptionAnn);
            if (desc != null) {
                return desc.value();
            }
            return "";
        }
        catch (Throwable e) {
            return "";
        }
    }

    static String getName(Method method) {
        try {
            Name name = (Name)method.getAnnotation(_nameAnn);
            if (name != null) {
                return name.value();
            }
            return method.getName();
        }
        catch (Throwable e) {
            return method.getName();
        }
    }

    private static MBeanParameterInfo[] getSignature(Method method) {
        Class<?>[] params = method.getParameterTypes();
        MBeanParameterInfo[] paramInfos = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> cl = params[i];
            String name = IntrospectionMBean.getName(method, i);
            String description = IntrospectionMBean.getDescription(method, i);
            paramInfos[i] = new MBeanParameterInfo(name, cl.getName(), description);
        }
        return paramInfos;
    }

    private static String getName(Method method, int i) {
        try {
            for (Annotation ann : method.getParameterAnnotations()[i]) {
                if (!(ann instanceof Name)) continue;
                return ((Name)ann).value();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return "p" + i;
    }

    private static String getDescription(Method method, int i) {
        try {
            for (Annotation ann : method.getParameterAnnotations()[i]) {
                if (!(ann instanceof Description)) continue;
                return ((Description)ann).value();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return "";
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            return IntrospectionMBean.getTypeName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    private static OpenType getOpenType(Class type) {
        try {
            if (type.isArray()) {
                OpenType component = IntrospectionMBean.getOpenType(type.getComponentType());
                if (component != null) {
                    return new ArrayType(1, component);
                }
                return null;
            }
            if (type.getName().endsWith("MXBean") || type.getName().endsWith("MBean")) {
                return SimpleType.OBJECTNAME;
            }
            if (Void.TYPE.equals(type)) {
                return SimpleType.VOID;
            }
            if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
                return SimpleType.BOOLEAN;
            }
            if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
                return SimpleType.BYTE;
            }
            if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
                return SimpleType.SHORT;
            }
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return SimpleType.INTEGER;
            }
            if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
                return SimpleType.LONG;
            }
            if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
                return SimpleType.FLOAT;
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return SimpleType.DOUBLE;
            }
            if (String.class.equals((Object)type)) {
                return SimpleType.STRING;
            }
            if (Character.TYPE.equals(type) || Character.class.equals((Object)type)) {
                return SimpleType.CHARACTER;
            }
            if (Date.class.equals((Object)type)) {
                return SimpleType.DATE;
            }
            if (Calendar.class.equals((Object)type)) {
                return SimpleType.DATE;
            }
            return null;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    private static Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        _cachedInfo = new WeakHashMap();
        MBEAN_FEATURE_INFO_COMPARATOR = new Comparator<MBeanFeatureInfo>(){

            @Override
            public int compare(MBeanFeatureInfo o1, MBeanFeatureInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        _descriptionAnn = IntrospectionMBean.findClass("com.caucho.jmx.Description");
        _nameAnn = IntrospectionMBean.findClass("com.caucho.jmx.Name");
    }
}

