/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ConnectionEntry
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(ConnectionEntry.class.getName());
    private Env _env;
    private DataSource _ds;
    private String _user;
    private String _password;
    private Connection _conn;
    private boolean _isReuse;

    public ConnectionEntry(Env env) {
        this._env = env;
    }

    public void init(DataSource ds, String user, String password) {
        this._ds = ds;
        this._user = user;
        this._password = password;
    }

    public void connect(boolean isReuse) throws SQLException {
        if (this._conn != null) {
            throw new IllegalStateException();
        }
        this._isReuse = isReuse;
        this._conn = this._user != null && !"".equals(this._user) ? this._ds.getConnection(this._user, this._password) : this._ds.getConnection();
        this._env.addCleanup(this);
    }

    public boolean isReusable() {
        return this._isReuse && this._conn != null;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void setCatalog(String catalog) throws SQLException {
        this._isReuse = false;
        this._conn.setCatalog(catalog);
    }

    public int hashCode() {
        int hash = this._ds.hashCode();
        if (this._user == null) {
            return hash;
        }
        return 65521 * hash + this._user.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionEntry)) {
            return false;
        }
        ConnectionEntry entry = (ConnectionEntry)o;
        if (this._ds != entry._ds) {
            return false;
        }
        if (this._user == null) {
            return entry._user == null;
        }
        return this._user.equals(entry._user);
    }

    public void markForPoolRemoval() {
        this._isReuse = false;
        if (this._conn != null) {
            this._env.getQuercus().markForPoolRemoval(this._conn);
        }
    }

    public void phpClose() {
        try {
            if (!this._isReuse) {
                this.cleanup();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void cleanup() throws SQLException {
        Connection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ds=" + this._ds + ", user=" + this._user + "]";
    }
}

