/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.curl.CurlHttpConnection;
import com.caucho.quercus.lib.curl.CurlHttpRequest;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.PostBody;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public class HttpPostRequest
extends CurlHttpRequest {
    private PostBody _body;

    public HttpPostRequest(CurlResource curlResource) {
        super(curlResource);
    }

    protected boolean init(Env env) throws ProtocolException {
        if (!super.init(env)) {
            return false;
        }
        CurlResource curl = this.getCurlResource();
        this._body = PostBody.create(env, curl.getPostBody());
        if (this._body == null) {
            return false;
        }
        CurlHttpConnection conn = this.getHttpConnection();
        if (conn.getRequestProperty("Content-Type") == null) {
            conn.setRequestProperty("Content-Type", this._body.getContentType());
        }
        if (conn.getRequestProperty("Content-Length") == null) {
            conn.setRequestProperty("Content-Length", String.valueOf(this._body.getContentLength()));
        }
        conn.setDoOutput(true);
        return true;
    }

    protected void transfer(Env env) throws IOException {
        super.transfer(env);
        CurlHttpConnection conn = this.getHttpConnection();
        OutputStream out = conn.getOutputStream();
        this._body.writeTo(env, out);
    }
}

