/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlHttpRequest;
import com.caucho.quercus.lib.curl.PostBody;
import com.caucho.quercus.servlet.api.QuercusServletContext;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartBody
extends PostBody {
    private static final L10N L = new L10N(CurlHttpRequest.class);
    private ArrayList<MultipartEntry> _postItems = new ArrayList();
    private String _boundary;
    private byte[] _boundaryBytes;
    private long _length;

    @Override
    protected boolean init(Env env, Value body) {
        this._boundary = MultipartBody.createBoundary();
        this._boundaryBytes = this._boundary.getBytes();
        Iterator<Map.Entry<Value, Value>> iter = body.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            StringValue key = entry.getKey().toString(env);
            StringValue value = entry.getValue().toString(env);
            if (value.length() > 0 && value.charAt(0) == '@') {
                StringValue fileName = value.substring(1);
                Path path = env.lookup(fileName);
                if (path == null || !path.canRead()) {
                    env.warning(L.l("cannot read file '{0}'", (Object)fileName));
                    return false;
                }
                this._postItems.add(new PathEntry(env, key.toString(), path));
                continue;
            }
            this._postItems.add(new UrlEncodedEntry(env, key.toString(), value));
        }
        this._length = MultipartBody.getContentLength(this._postItems, this._boundary);
        return true;
    }

    private static String createBoundary() {
        return "boundary" + RandomUtil.getRandomLong();
    }

    private static long getContentLength(ArrayList<MultipartEntry> list, String boundary) {
        long size = boundary.length() + 2 + 4;
        for (MultipartEntry entry : list) {
            size += entry.getLength() + (long)(boundary.length() + 4) + 2L;
        }
        return size;
    }

    @Override
    public String getContentType() {
        return "multipart/form-data; boundary=\"" + this._boundary + "\"";
    }

    @Override
    public long getContentLength() {
        return this._length;
    }

    @Override
    public void writeTo(Env env, OutputStream os) throws IOException {
        for (MultipartEntry entry : this._postItems) {
            os.write(45);
            os.write(45);
            os.write(this._boundaryBytes);
            os.write(13);
            os.write(10);
            entry.write(env, os);
            os.write(13);
            os.write(10);
        }
        os.write(45);
        os.write(45);
        os.write(this._boundaryBytes);
        os.write(45);
        os.write(45);
        os.write(13);
        os.write(10);
    }

    static class PathEntry
    extends MultipartEntry {
        Path _path;

        PathEntry(Env env, String name, Path path) {
            super(env, name, PathEntry.getHeader(name, PathEntry.getContentType(env, path.getTail()), path.getTail()));
            this._path = path;
        }

        long getLengthImpl() {
            return this._path.getLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(Env env, OutputStream os) throws IOException {
            TempBuffer tempBuf = null;
            try {
                int len;
                tempBuf = TempBuffer.allocate();
                byte[] buf = tempBuf.getBuffer();
                ReadStream is = this._path.openRead();
                while ((len = is.read(buf, 0, buf.length)) > 0) {
                    os.write(buf, 0, len);
                }
            }
            finally {
                if (tempBuf != null) {
                    TempBuffer.free(tempBuf);
                }
            }
        }

        private static String getContentType(Env env, String name) {
            QuercusContext quercus = env.getQuercus();
            QuercusServletContext context = quercus.getServletContext();
            if (context != null) {
                String mimeType = context.getMimeType(name);
                if (mimeType != null) {
                    return mimeType;
                }
                return "application/octet-stream";
            }
            int i = name.lastIndexOf(46);
            if (i < 0) {
                return "application/octet-stream";
            }
            if (name.endsWith(".txt")) {
                return "text/plain";
            }
            if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            if (name.endsWith(".gif")) {
                return "image/gif";
            }
            if (name.endsWith(".tif") || name.endsWith(".tiff")) {
                return "image/tiff";
            }
            if (name.endsWith(".png")) {
                return "image/png";
            }
            if (name.endsWith(".htm") || name.endsWith(".html")) {
                return "text/html";
            }
            if (name.endsWith(".xml")) {
                return "text/xml";
            }
            return "application/octet-stream";
        }
    }

    static class UrlEncodedEntry
    extends MultipartEntry {
        StringValue _value;

        UrlEncodedEntry(Env env, String name, StringValue value) {
            super(env, name, UrlEncodedEntry.getHeader(name, "application/x-www-form-urlencoded", null));
            this._value = value;
        }

        long getLengthImpl() {
            return this._value.length();
        }

        void writeData(Env env, OutputStream os) throws IOException {
            os.write(this._value.toString().getBytes());
        }
    }

    static abstract class MultipartEntry {
        final String _name;
        final String _header;

        MultipartEntry(Env env, String name, String header) {
            this._name = name;
            this._header = header;
        }

        final String getName() {
            return this._name;
        }

        static String getHeader(String name, String contentType, String fileName) {
            StringBuilder sb = new StringBuilder();
            sb.append("Content-Disposition: form-data;");
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
            if (fileName != null) {
                sb.append("; filename=\"");
                sb.append(fileName);
                sb.append("\"");
                sb.append('\r');
                sb.append('\n');
                sb.append("Content-Type: ");
                sb.append(contentType);
            }
            return sb.toString();
        }

        final void write(Env env, OutputStream os) throws IOException {
            int len = this._header.length();
            for (int i = 0; i < len; ++i) {
                os.write(this._header.charAt(i));
            }
            os.write(13);
            os.write(10);
            os.write(13);
            os.write(10);
            this.writeData(env, os);
        }

        final long getLength() {
            return (long)(this._header.length() + 4) + this.getLengthImpl();
        }

        abstract long getLengthImpl();

        abstract void writeData(Env var1, OutputStream var2) throws IOException;
    }
}

