/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.db.JdbcColumnMetaData;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcTableMetaData {
    private static final Logger log = Logger.getLogger(JdbcTableMetaData.class.getName());
    private final String _catalog;
    private final String _schema;
    private final String _name;
    private final long _lastModified;
    private long _maxIdleTime = 10000L;
    private final HashMap<String, JdbcColumnMetaData> _columnMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTableMetaData(Env env, String catalog, String schema, String name, DatabaseMetaData md) throws SQLException {
        this._catalog = catalog;
        this._schema = schema;
        this._name = name;
        this._lastModified = env.getCurrentTime();
        ResultSet rs = md.getColumns(this._catalog, this._schema, this._name, null);
        try {
            JdbcColumnMetaData column;
            String columnName;
            while (rs.next()) {
                columnName = rs.getString(4);
                column = new JdbcColumnMetaData(this, rs);
                this._columnMap.put(columnName, column);
            }
            rs.close();
            try {
                rs = md.getPrimaryKeys(this._catalog, this._schema, this._name);
                while (rs.next()) {
                    columnName = rs.getString(4);
                    column = this._columnMap.get(columnName);
                    column.setPrimaryKey(true);
                }
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                rs.close();
            }
            rs = md.getIndexInfo(this._catalog, this._schema, this._name, false, true);
            while (rs.next()) {
                columnName = rs.getString(9);
                column = this._columnMap.get(columnName);
                column.setIndex(true);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            rs.close();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public JdbcColumnMetaData getColumn(String name) {
        return this._columnMap.get(name);
    }

    public boolean isValid(Env env) {
        return env.getCurrentTime() - this._lastModified <= this._maxIdleTime;
    }

    public String toString() {
        return "JdbcTableMetaData[" + this.getName() + "]";
    }
}

