/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Oracle;
import com.caucho.quercus.lib.db.OracleOciLob;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class OracleResult
extends JdbcResultResource {
    private final Oracle _conn;

    public OracleResult(ResultSet rs, Oracle conn) {
        super(rs);
        this._conn = conn;
    }

    public OracleResult(ResultSetMetaData metaData, Oracle conn) {
        super(metaData);
        this._conn = conn;
    }

    protected Value getBlobValue(Env env, ResultSet rs, ResultSetMetaData metaData, int column) throws SQLException {
        Blob object = rs.getBlob(column);
        OracleOciLob ociLob = new OracleOciLob(this._conn, 13);
        ociLob.setLob(object);
        return env.wrapJava(ociLob);
    }

    protected Value getClobValue(Env env, ResultSet rs, ResultSetMetaData metaData, int column) throws SQLException {
        Clob clob = rs.getClob(column);
        OracleOciLob ociLob = new OracleOciLob(this._conn, 13);
        ociLob.setLob(clob);
        return env.wrapJava(ociLob);
    }
}

