/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BufferedBinaryInputOutput
extends AbstractBinaryInputOutput {
    private static final Logger log = Logger.getLogger(BufferedBinaryInputOutput.class.getName());
    private ReadStream _is;
    private WriteStream _os;

    protected BufferedBinaryInputOutput(Env env) {
        super(env);
    }

    public void init(ReadStream is, WriteStream os) {
        super.init(is, os);
        this._is = is;
        this._os = os;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._is != null) {
            this._is.setEncoding(encoding);
        }
    }

    public void unread() throws IOException {
        if (this._is != null) {
            this._is.unread();
            this._isEOF = false;
        }
    }

    public int getAvailable() throws IOException {
        if (this._is != null) {
            return this._is.available();
        }
        return -1;
    }

    public int read() throws IOException {
        try {
            if (this._is != null) {
                int c = this._is.read();
                if (c < 0) {
                    this._isEOF = true;
                }
                return c;
            }
            return -1;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return -1;
        }
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        try {
            if (this._is != null) {
                int c = this._is.read(buffer, offset, length);
                this._isEOF = c == -1;
                return c;
            }
            return -1;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return -1;
        }
    }

    public void writeToStream(OutputStream os, int length) throws IOException {
        try {
            if (this._is != null) {
                this._is.writeToStream(os, length);
            }
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public StringValue readLine(long length) throws IOException {
        try {
            StringValue line = this._lineReader.readLine(this._env, this, length);
            return line;
        }
        catch (IOException e) {
            this._isTimeout = true;
            this._isEOF = true;
            log.log(Level.FINER, e.toString(), e);
            return this._env.getEmptyString();
        }
    }

    public long getPosition() {
        if (this._is != null) {
            return this._is.getPosition();
        }
        return -1L;
    }

    public boolean setPosition(long offset) {
        if (this._is == null) {
            return false;
        }
        this._isEOF = false;
        try {
            return this._is.setPosition(offset);
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public Value stat() {
        return BooleanValue.FALSE;
    }

    public String toString() {
        if (this._is != null) {
            return "BufferedBinaryInputOutput[" + this._is.getPath() + "]";
        }
        return "BufferedBinaryInputOutput[closed]";
    }
}

