/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.reflection;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.ParamRequiredExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.reflection.ReflectionClass;
import com.caucho.quercus.lib.reflection.ReflectionException;
import com.caucho.quercus.lib.reflection.Reflector;
import com.caucho.quercus.program.Arg;
import com.caucho.util.L10N;

public class ReflectionParameter
implements Reflector {
    private static final L10N L = new L10N(ReflectionParameter.class);
    private String _clsName;
    private Callable _fun;
    private Arg _arg;

    protected ReflectionParameter(Callable fun, Arg arg) {
        this._fun = fun;
        this._arg = arg;
    }

    protected ReflectionParameter(String clsName, AbstractFunction fun, Arg arg) {
        this(fun, arg);
        this._clsName = clsName;
    }

    private final void __clone() {
    }

    public static ReflectionParameter __construct(Env env, StringValue funName, StringValue paramName) {
        AbstractFunction fun = env.findFunction(funName);
        Arg[] args = fun.getArgs(env);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getName().equals(paramName)) continue;
            return new ReflectionParameter(fun, args[i]);
        }
        throw new ReflectionException(env, L.l("cannot find parameter '{0}'", (Object)paramName));
    }

    public static String export(Env env, Value function, Value parameter, boolean isReturn) {
        return null;
    }

    public StringValue getName() {
        return this._arg.getName();
    }

    public boolean isPassedByReference() {
        return this._arg.isReference();
    }

    public ReflectionClass getDeclaringClass(Env env) {
        if (this._clsName != null) {
            QuercusClass cls = env.findClass(this._clsName);
            QuercusClass parent = cls.getParent();
            if (parent == null || parent.findFunction(this._fun.getCallbackName()) != this._fun) {
                return new ReflectionClass(cls);
            }
            return this.getDeclaringClass(env, parent);
        }
        return null;
    }

    private ReflectionClass getDeclaringClass(Env env, QuercusClass cls) {
        if (cls == null) {
            return null;
        }
        ReflectionClass refClass = this.getDeclaringClass(env, cls.getParent());
        if (refClass != null) {
            return refClass;
        }
        if (cls.findFunction(this._fun.getCallbackName()) != null) {
            return new ReflectionClass(cls);
        }
        return null;
    }

    public ReflectionClass getClass(Env env) {
        String name = this._arg.getExpectedClass();
        ReflectionClass cls = new ReflectionClass(env, name);
        return cls;
    }

    public boolean isArray() {
        return false;
    }

    public boolean allowsNull() {
        return false;
    }

    public boolean isCallable() {
        return "Callable".equalsIgnoreCase(this._arg.getExpectedClass());
    }

    public boolean isOptional() {
        return !(this._arg.getDefault() instanceof ParamRequiredExpr);
    }

    public boolean isDefaultValueAvailable() {
        return this.isOptional();
    }

    public Value getDefaultValue(Env env) {
        if (!this.isOptional()) {
            throw new ReflectionException(env, L.l("parameter '{0}' is not optional", (Object)this._arg.getName()));
        }
        return this._arg.getDefault().eval(env);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._fun.getCallbackName() + "(" + this._arg.getName() + ")]";
    }
}

