/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.PeekStream;
import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class Regcomp {
    private static final Logger log = Logger.getLogger(Regcomp.class.getName());
    private static final L10N L = new L10N(RegexpNode.class);
    private static final int INTEGER_MAX = 0x7FFFFFFE;
    static final int MULTILINE = 1;
    static final int SINGLE_LINE = 2;
    static final int IGNORE_CASE = 4;
    static final int IGNORE_WS = 8;
    static final int GLOBAL = 16;
    static final int ANCHORED = 32;
    static final int END_ONLY = 64;
    static final int UNGREEDY = 128;
    static final int STRICT = 256;
    static final int UTF8 = 512;
    static final HashMap<String, Integer> _characterClassMap = new HashMap();
    static final ConcurrentHashMap<String, RegexpSet> _unicodeBlockMap = new ConcurrentHashMap();
    private PeekStream _pattern;
    int _nGroup;
    int _nLoop;
    int _maxGroup;
    int _flags;
    HashMap<Integer, RegexpNode> _groupMap = new HashMap();
    HashMap<Integer, StringValue> _groupNameMap = new HashMap();
    HashMap<StringValue, Integer> _groupNameReverseMap = new HashMap();
    ArrayList<RegexpNode.Recursive> _recursiveList = new ArrayList();
    ArrayList<RegexpNode.GroupNumberRecursive> _groupNumberRecursiveList = new ArrayList();
    ArrayList<RegexpNode.GroupNameRecursive> _groupNameRecursiveList = new ArrayList();
    RegexpNode _groupTail;
    boolean _isLookbehind;
    boolean _isOr;

    Regcomp(int flags) {
        this._flags = flags;
    }

    boolean isGreedy() {
        return (this._flags & 0x80) != 128;
    }

    boolean isIgnoreCase() {
        return (this._flags & 4) == 4;
    }

    boolean isIgnoreWs() {
        return (this._flags & 8) == 8;
    }

    boolean isMultiline() {
        return (this._flags & 1) == 1;
    }

    boolean isDollarEndOnly() {
        return (this._flags & 0x40) == 64;
    }

    int nextLoopIndex() {
        return this._nLoop++;
    }

    RegexpNode parse(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        this._pattern = pattern;
        this._nGroup = 1;
        RegexpNode.AnchorBeginRelative begin = null;
        if ((this._flags & 0x20) != 0) {
            begin = RegexpNode.ANCHOR_BEGIN_RELATIVE;
        }
        RegexpNode value = this.parseRec(pattern, begin);
        while ((ch = pattern.read()) == 124) {
            value = RegexpNode.Or.create(value, this.parseRec(pattern, begin));
        }
        RegexpNode regexpNode = value = value != null ? value.getHead() : RegexpNode.N_END;
        if (this._maxGroup < this._nGroup) {
            this._maxGroup = this._nGroup;
        }
        for (RegexpNode.Recursive recursive : this._recursiveList) {
            RegexpNode.Concat topConcat;
            RegexpNode top = value;
            if (top instanceof RegexpNode.Concat && ((topConcat = (RegexpNode.Concat)top).getConcatHead() instanceof RegexpNode.AnchorBegin || topConcat.getConcatHead() instanceof RegexpNode.AnchorBeginRelative)) {
                top = topConcat.getConcatNext();
            }
            recursive.setTop(top);
        }
        value = value != null ? value.getHead() : RegexpNode.N_END;
        for (RegexpNode.GroupNumberRecursive groupNumberRecursive : this._groupNumberRecursiveList) {
            int group = groupNumberRecursive.getGroup();
            RegexpNode node = this._groupMap.get(group);
            if (node == null) {
                throw this.error(L.l("numeric recursive refers to invalid group number: {0}", group));
            }
            RegexpNode.GroupHead groupHead = (RegexpNode.GroupHead)node;
            groupNumberRecursive.setTop(groupHead.getNode());
        }
        for (RegexpNode.GroupNameRecursive groupNameRecursive : this._groupNameRecursiveList) {
            StringValue name = groupNameRecursive.getGroup();
            Integer group = this._groupNameReverseMap.get(name);
            if (group == null) {
                throw this.error(L.l("named recursive refers to invalid group: {0}", (Object)name));
            }
            RegexpNode node = this._groupMap.get(group);
            RegexpNode.GroupHead groupHead = (RegexpNode.GroupHead)node;
            groupNameRecursive.setTop(groupHead.getNode());
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("regexp[] " + value);
        }
        return value;
    }

    private RegexpNode parseRec(PeekStream pattern, RegexpNode tail) throws IllegalRegexpException {
        int ch = pattern.read();
        switch (ch) {
            case -1: {
                return tail != null ? tail.getHead() : null;
            }
            case 63: {
                if (tail == null) {
                    throw this.error(L.l("'?' requires a preceeding regexp"));
                }
                tail = this.createLoop(pattern, tail, 0, 1);
                return this.parseRec(pattern, tail.getTail());
            }
            case 42: {
                if (tail == null) {
                    throw this.error(L.l("'*' requires a preceeding regexp"));
                }
                tail = this.createLoop(pattern, tail, 0, 0x7FFFFFFE);
                return this.parseRec(pattern, tail.getTail());
            }
            case 43: {
                if (tail == null) {
                    throw this.error(L.l("'+' requires a preceeding regexp"));
                }
                tail = this.createLoop(pattern, tail, 1, 0x7FFFFFFE);
                return this.parseRec(pattern, tail.getTail());
            }
            case 123: {
                if (tail == null || 48 > pattern.peek() || pattern.peek() > 57) {
                    RegexpNode next = this.parseString(123, pattern);
                    return Regcomp.concat(tail, this.parseRec(pattern, next));
                }
                return this.parseRec(pattern, this.parseBrace(pattern, tail).getTail());
            }
            case 46: {
                RegexpNode next = (this._flags & 2) == 0 ? RegexpNode.DOT : RegexpNode.ANY_CHAR;
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 124: {
                pattern.ungetc(ch);
                if (this._groupTail != null) {
                    return Regcomp.concat(tail, this._groupTail);
                }
                return tail.getHead();
            }
            case 40: {
                switch (pattern.peek()) {
                    case 63: {
                        pattern.read();
                        switch (pattern.peek()) {
                            case 58: {
                                pattern.read();
                                return this.parseGroup(pattern, tail, 0, this._flags);
                            }
                            case 35: {
                                this.parseCommentGroup(pattern);
                                return this.parseRec(pattern, tail);
                            }
                            case 40: {
                                return this.parseConditional(pattern, tail);
                            }
                            case 33: 
                            case 61: {
                                RegexpNode next = this.parseLookahead(pattern);
                                return Regcomp.concat(tail, this.parseRec(pattern, next));
                            }
                            case 60: {
                                pattern.read();
                                ch = pattern.peek();
                                if (ch != 61 && ch != 33) {
                                    pattern.ungetc(60);
                                    return this.parseNamedGroup(pattern, tail);
                                }
                                RegexpNode next = this.parseLookbehind(pattern);
                                return Regcomp.concat(tail, this.parseRec(pattern, next));
                            }
                            case 62: {
                                pattern.read();
                                return this.parseGroup(pattern, tail, 0, this._flags);
                            }
                            case 80: {
                                pattern.read();
                                return this.parseNamedGroup(pattern, tail);
                            }
                            case 39: {
                                return this.parseNamedGroup(pattern, tail);
                            }
                            case 82: {
                                pattern.read();
                                int group = this._nGroup - 1;
                                if (group < 0) {
                                    group = 0;
                                }
                                RegexpNode.Recursive rec = new RegexpNode.Recursive(group);
                                this._recursiveList.add(rec);
                                ch = pattern.read();
                                if (ch != 41) {
                                    throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
                                }
                                return Regcomp.concat(tail, this.parseRec(pattern, rec));
                            }
                            case 45: 
                            case 85: 
                            case 88: 
                            case 103: 
                            case 105: 
                            case 109: 
                            case 115: 
                            case 120: {
                                int flags = this._flags;
                                boolean isUnset = false;
                                block43: while ((ch = pattern.read()) > 0 && ch != 41) {
                                    switch (ch) {
                                        case 45: {
                                            if (isUnset) {
                                                throw this.error(L.l("saw a duplicate '-' in a (? code"));
                                            }
                                            isUnset = true;
                                            continue block43;
                                        }
                                        case 109: {
                                            this._flags = Regcomp.setFlag(this._flags, 1, isUnset);
                                            continue block43;
                                        }
                                        case 115: {
                                            this._flags = Regcomp.setFlag(this._flags, 2, isUnset);
                                            continue block43;
                                        }
                                        case 105: {
                                            this._flags = Regcomp.setFlag(this._flags, 4, isUnset);
                                            continue block43;
                                        }
                                        case 120: {
                                            this._flags = Regcomp.setFlag(this._flags, 8, isUnset);
                                            continue block43;
                                        }
                                        case 103: {
                                            this._flags = Regcomp.setFlag(this._flags, 16, isUnset);
                                            continue block43;
                                        }
                                        case 85: {
                                            this._flags = Regcomp.setFlag(this._flags, 128, isUnset);
                                            continue block43;
                                        }
                                        case 88: {
                                            this._flags = Regcomp.setFlag(this._flags, 256, isUnset);
                                            continue block43;
                                        }
                                        case 58: {
                                            return this.parseGroup(pattern, tail, 0, flags);
                                        }
                                    }
                                    throw this.error(L.l("'{0}' is an unknown (? code", (Object)String.valueOf((char)ch)));
                                }
                                if (ch != 41) {
                                    throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
                                }
                                RegexpNode node = this.parseRec(pattern, tail);
                                this._flags = flags;
                                return node;
                            }
                        }
                        ch = pattern.peek();
                        if (48 <= ch && ch <= 57) {
                            RegexpNode node;
                            pattern.read();
                            int group = 0;
                            while (48 <= ch && ch <= 57) {
                                group = group * 10 + ch - 48;
                                ch = pattern.read();
                            }
                            if (ch != 41) {
                                throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
                            }
                            RegexpNode.GroupHead groupHead = (RegexpNode.GroupHead)this._groupMap.get(group);
                            if (groupHead != null) {
                                node = new RegexpNode.Subroutine(group, groupHead.getNode());
                            } else {
                                RegexpNode.GroupNumberRecursive rec = new RegexpNode.GroupNumberRecursive(group);
                                this._groupNumberRecursiveList.add(rec);
                                node = rec;
                            }
                            return Regcomp.concat(tail, this.parseRec(pattern, node));
                        }
                        throw this.error(L.l("'{0}' is an unknown (? code", (Object)String.valueOf((char)pattern.peek())));
                    }
                }
                return this.parseGroup(pattern, tail, this._nGroup++, this._flags);
            }
            case 41: {
                pattern.ungetc(ch);
                if (this._groupTail != null) {
                    return Regcomp.concat(tail, this._groupTail);
                }
                return tail;
            }
            case 91: {
                RegexpNode next = this.parseSet(pattern);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 92: {
                RegexpNode next = this.parseSlash(pattern);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 94: {
                RegexpNode.NullableNode next = this.isMultiline() ? RegexpNode.ANCHOR_BEGIN_OR_NEWLINE : RegexpNode.ANCHOR_BEGIN;
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 36: {
                RegexpNode.NullableNode next = this.isMultiline() ? RegexpNode.ANCHOR_END_OR_NEWLINE : (this.isDollarEndOnly() ? RegexpNode.ANCHOR_END_ONLY : RegexpNode.ANCHOR_END);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                if (this.isIgnoreWs()) {
                    while (Character.isSpace((char)pattern.peek())) {
                        pattern.read();
                    }
                    return this.parseRec(pattern, tail);
                }
                RegexpNode next = this.parseString(ch, pattern);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            case 35: {
                if (this.isIgnoreWs()) {
                    while ((ch = pattern.read()) > 0 && ch != 10) {
                    }
                    return this.parseRec(pattern, tail);
                }
                RegexpNode next = this.parseString(ch, pattern);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
        }
        RegexpNode next = this.parseString(ch, pattern);
        return Regcomp.concat(tail, this.parseRec(pattern, next));
    }

    private static int setFlag(int flag, int modifier, boolean isUnset) {
        if (isUnset) {
            return flag - (flag & modifier);
        }
        return flag | modifier;
    }

    private RegexpNode parseLookahead(PeekStream pattern) throws IllegalRegexpException {
        int ch = pattern.read();
        boolean isPositive = ch == 61;
        RegexpNode groupTail = this._groupTail;
        this._groupTail = null;
        RegexpNode next = this.parseRec(pattern, null);
        while ((ch = pattern.read()) == 124) {
            RegexpNode nextHead = this.parseRec(pattern, null);
            next = next.createOr(nextHead);
        }
        next = isPositive ? new RegexpNode.Lookahead(next) : new RegexpNode.NotLookahead(next);
        if (ch != 41) {
            throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
        }
        this._groupTail = groupTail;
        return next;
    }

    private RegexpNode parseLookbehind(PeekStream pattern) throws IllegalRegexpException {
        int ch = pattern.read();
        boolean isPositive = ch == 61;
        RegexpNode groupTail = this._groupTail;
        this._groupTail = null;
        RegexpNode next = this.parseRec(pattern, null);
        if (next != null) {
            next = isPositive ? new RegexpNode.Lookbehind(next) : new RegexpNode.NotLookbehind(next);
        }
        while ((ch = pattern.read()) == 124) {
            RegexpNode second = this.parseRec(pattern, null);
            if (second != null) {
                second = isPositive ? new RegexpNode.Lookbehind(second) : new RegexpNode.NotLookbehind(second);
            }
            if (second == null) continue;
            next = next.createOr(second);
        }
        if (ch != 41) {
            throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
        }
        this._groupTail = groupTail;
        return next;
    }

    private void parseCommentGroup(PeekStream pattern) {
        int ch;
        while ((ch = pattern.read()) >= 0 && ch != 41) {
        }
    }

    private RegexpNode parseNamedGroup(PeekStream pattern, RegexpNode tail) throws IllegalRegexpException {
        int ch = pattern.read();
        if (ch == 61) {
            StringBuilder sb = new StringBuilder();
            while ((ch = pattern.read()) != 41 && ch >= 0) {
                sb.append((char)ch);
            }
            if (ch != 41) {
                throw this.error(L.l("expected ')'"));
            }
            String name = sb.toString();
            Integer v = this._groupNameReverseMap.get(new ConstStringValue(name));
            if (v != null) {
                RegexpNode.GroupRef next = new RegexpNode.GroupRef(v);
                return Regcomp.concat(tail, this.parseRec(pattern, next));
            }
            throw this.error(L.l("'{0}' is an unknown regexp group", (Object)name));
        }
        if (ch == 60 || ch == 39) {
            int closeChar = 62;
            if (ch == 39) {
                closeChar = 39;
            }
            StringBuilder sb = new StringBuilder();
            while ((ch = pattern.read()) != closeChar && ch >= 0) {
                sb.append((char)ch);
            }
            if (ch != closeChar) {
                throw this.error(L.l("expected '{0}'", (Object)String.valueOf((char)closeChar)));
            }
            String name = sb.toString();
            int group = this._nGroup++;
            ConstStringValue nameV = new ConstStringValue(name);
            this._groupNameMap.put(group, nameV);
            this._groupNameReverseMap.put(nameV, group);
            RegexpNode node = this.parseGroup(pattern, tail, group, this._flags);
            return node;
        }
        if (ch == 62) {
            RegexpNode node;
            StringBuilder sb = new StringBuilder();
            while ((ch = pattern.read()) != 41 && ch >= 0) {
                sb.append((char)ch);
            }
            if (ch != 41) {
                throw this.error(L.l("expected ')'"));
            }
            String name = sb.toString();
            ConstStringValue nameV = new ConstStringValue(name);
            Integer group = this._groupNameReverseMap.get(nameV);
            RegexpNode.GroupHead groupHead = null;
            if (group != null) {
                groupHead = (RegexpNode.GroupHead)this._groupMap.get(group);
            }
            if (groupHead != null) {
                node = new RegexpNode.Subroutine(group, groupHead.getNode());
            } else {
                RegexpNode.GroupNameRecursive rec = new RegexpNode.GroupNameRecursive(nameV);
                this._groupNameRecursiveList.add(rec);
                node = rec;
            }
            return Regcomp.concat(tail, this.parseRec(pattern, node));
        }
        throw this.error(L.l("Expected '(?:P=name' or '(?:P<name' for named group"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RegexpNode parseConditional(PeekStream pattern, RegexpNode tail) throws IllegalRegexpException {
        int ch = pattern.read();
        if (ch != 40) {
            throw this.error(L.l("expected '('"));
        }
        RegexpNode.ConditionalHead groupHead = null;
        RegexpNode groupTail = null;
        ch = pattern.peek();
        if (49 <= ch && ch <= 57) {
            int value = 0;
            while (48 <= (ch = pattern.read()) && ch <= 57) {
                value = 10 * value + ch - 48;
            }
            if (ch != 41) {
                throw this.error(L.l("expected ')'"));
            }
            if (this._nGroup <= value) {
                throw this.error(L.l("conditional value less than number of groups"));
            }
            groupHead = new RegexpNode.GroupConditionalHead(value);
            groupTail = groupHead.getTail();
        } else {
            if (ch != 63) throw this.error(L.l("conditional requires a number or a lookahead/lookbehind assertion"));
            pattern.read();
            ch = pattern.peek();
            if (ch == 61 || ch == 33) {
                RegexpNode conditional = this.parseLookahead(pattern);
                groupHead = new RegexpNode.GenericConditionalHead(conditional);
                groupTail = groupHead.getTail();
            } else {
                if (ch != 60) throw this.error(L.l("conditional requires a number or a lookahead/lookbehind assertion"));
                pattern.read();
                ch = pattern.peek();
                if (ch != 61 && ch != 33) {
                    throw this.error(L.l("expected lookbehind assertion '=' or '!' at '{0}'", (Object)String.valueOf((char)ch)));
                }
                RegexpNode conditional = this.parseLookbehind(pattern);
                groupHead = new RegexpNode.GenericConditionalHead(conditional);
                groupTail = groupHead.getTail();
            }
        }
        RegexpNode oldTail = this._groupTail;
        this._groupTail = groupTail;
        RegexpNode first = this.parseRec(pattern, null);
        RegexpNode second = null;
        ch = pattern.read();
        if (ch == 124) {
            second = this.parseRec(pattern, null);
            ch = pattern.read();
        }
        if (ch != 41) {
            throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
        }
        this._groupTail = oldTail;
        groupHead.setFirst(first);
        groupHead.setSecond(second);
        return Regcomp.concat(tail, this.parseRec(pattern, groupHead));
    }

    private RegexpNode parseGroup(PeekStream pattern, RegexpNode tail, int group, int oldFlags) throws IllegalRegexpException {
        int ch;
        RegexpNode.GroupHead groupHead = new RegexpNode.GroupHead(group);
        RegexpNode groupTail = groupHead.getTail();
        RegexpNode oldTail = this._groupTail;
        this._groupTail = groupTail;
        RegexpNode body = this.parseRec(pattern, null);
        while ((ch = pattern.read()) == 124) {
            RegexpNode nextBody = this.parseRec(pattern, null);
            body = body.createOr(nextBody);
        }
        if (ch != 41) {
            throw this.error(L.l("expected ')'"));
        }
        this._flags = oldFlags;
        this._groupTail = oldTail;
        groupHead.setNode(body.getHead());
        RegexpNode copy = groupHead.copy();
        this._groupMap.put(group, copy);
        RegexpNode node = Regcomp.concat(tail, this.parseRec(pattern, groupTail).getHead());
        return node;
    }

    private void expect(char expected, int value) throws IllegalRegexpException {
        if (expected != value) {
            throw this.error(L.l("expected '{0}'", (Object)String.valueOf(expected)));
        }
    }

    private IllegalRegexpException error(String msg) {
        return new IllegalRegexpException(msg + "\n  in " + this._pattern.getPattern());
    }

    private RegexpNode parseBrace(PeekStream pattern, RegexpNode node) throws IllegalRegexpException {
        int ch;
        int min = 0;
        int max = 0x7FFFFFFE;
        while ((ch = pattern.read()) >= 48 && ch <= 57) {
            min = 10 * min + ch - 48;
        }
        if (ch == 44) {
            while (48 <= (ch = pattern.read()) && ch <= 57) {
                if (max == 0x7FFFFFFE) {
                    max = 0;
                }
                max = 10 * max + ch - 48;
            }
        } else {
            max = min;
        }
        if (ch != 125) {
            throw this.error(L.l("Expected '}'"));
        }
        return this.createLoop(pattern, node, min, max);
    }

    private RegexpNode createLoop(PeekStream pattern, RegexpNode node, int min, int max) {
        if (pattern.peek() == 43) {
            pattern.read();
            return node.createPossessiveLoop(min, max);
        }
        if (pattern.peek() == 63) {
            pattern.read();
            if (this.isGreedy()) {
                return node.createLoopUngreedy(this, min, max);
            }
            return node.createLoop(this, min, max);
        }
        if (this.isGreedy()) {
            return node.createLoop(this, min, max);
        }
        return node.createLoopUngreedy(this, min, max);
    }

    static RegexpNode concat(RegexpNode prev, RegexpNode next) {
        if (prev != null) {
            return prev.concat(next).getHead();
        }
        return next;
    }

    private String hex(int value) {
        CharBuffer cb = new CharBuffer();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.toString();
    }

    private String badChar(int ch) {
        if (32 <= ch && ch <= 127) {
            return "'" + (char)ch + "'";
        }
        if ((ch & 0xFFFF) == 65535) {
            return "end of expression";
        }
        return "'" + (char)ch + "' (\\u" + this.hex(ch) + ")";
    }

    private RegexpNode parseSet(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        int first = pattern.peek();
        boolean isNot = false;
        if (first == 94) {
            pattern.read();
            isNot = true;
        }
        RegexpSet set = new RegexpSet();
        int last = -1;
        int lastdash = -1;
        int charRead = 0;
        ArrayList<RegexpNode> nodeList = null;
        while ((ch = pattern.read()) >= 0) {
            int ch2;
            boolean isDash;
            ++charRead;
            if (ch == 93) {
                if (charRead != 1) break;
                pattern.ungetc(ch);
                ch = 92;
            }
            boolean isChar = true;
            boolean bl = isDash = ch == 45;
            if (ch == 92) {
                isChar = false;
                ch = pattern.read();
                switch (ch) {
                    case 115: {
                        set.mergeOr(RegexpSet.SPACE);
                        break;
                    }
                    case 83: {
                        set.mergeOrInv(RegexpSet.SPACE);
                        break;
                    }
                    case 100: {
                        set.mergeOr(RegexpSet.DIGIT);
                        break;
                    }
                    case 68: {
                        set.mergeOrInv(RegexpSet.DIGIT);
                        break;
                    }
                    case 119: {
                        set.mergeOr(RegexpSet.WORD);
                        break;
                    }
                    case 87: {
                        set.mergeOrInv(RegexpSet.WORD);
                        break;
                    }
                    case 112: {
                        int ch3;
                        ch2 = pattern.read();
                        if (ch2 != 123) {
                            if (nodeList == null) {
                                nodeList = new ArrayList<RegexpNode>();
                            }
                            nodeList.add(this.parseUnicodeProperty(ch2, false));
                            break;
                        }
                        StringBuilder sb = new StringBuilder();
                        while ((ch3 = pattern.read()) >= 0 && ch3 != 125) {
                            sb.append((char)ch3);
                        }
                        String name = sb.toString();
                        if (ch3 != 125) {
                            throw new IllegalRegexpException(L.l("expected '}' at " + this.badChar(ch3)));
                        }
                        int len = name.length();
                        if (len == 1) {
                            if (nodeList == null) {
                                nodeList = new ArrayList();
                            }
                            nodeList.add(this.parseUnicodeProperty(name.charAt(0), false));
                            break;
                        }
                        if (len == 2) {
                            if (nodeList == null) {
                                nodeList = new ArrayList();
                            }
                            nodeList.add(this.parseUnicodeProperty(name.charAt(0), name.charAt(1), false));
                            break;
                        }
                        set.mergeOr(this.getUnicodeSet(name));
                        break;
                    }
                    case 98: {
                        ch = 8;
                        isChar = true;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        isChar = true;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        isChar = true;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        isChar = true;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        isChar = true;
                        break;
                    }
                    case 120: {
                        ch = this.parseHex(pattern);
                        isChar = true;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        ch = this.parseOctal(ch, pattern);
                        isChar = true;
                        break;
                    }
                    default: {
                        isChar = true;
                    }
                }
            } else if (ch == 91) {
                if (pattern.peek() == 58) {
                    isChar = false;
                    pattern.read();
                    if (pattern.peek() == 94) {
                        pattern.read();
                        set.mergeOrInv(this.parseCharacterClass(pattern));
                    } else {
                        set.mergeOr(this.parseCharacterClass(pattern));
                    }
                }
            } else if (Character.isHighSurrogate((char)ch) && Character.isLowSurrogate((char)(ch2 = pattern.peek()))) {
                pattern.read();
                ch = Character.toCodePoint((char)ch, (char)ch2);
            }
            if (isDash && last != -1 && lastdash == -1) {
                lastdash = last;
                continue;
            }
            if (isChar && lastdash != -1) {
                if (lastdash > ch) {
                    throw new IllegalRegexpException(L.l("expected increasing range at {0}", (Object)this.badChar(ch)));
                }
                this.setRange(set, lastdash, ch);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (lastdash != -1) {
                this.setRange(set, lastdash, lastdash);
                this.setRange(set, 45, 45);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (last != -1) {
                this.setRange(set, last, last);
                if (!isChar) continue;
                last = ch;
                continue;
            }
            if (!isChar) continue;
            last = ch;
        }
        if (lastdash != -1) {
            this.setRange(set, lastdash, lastdash);
            this.setRange(set, 45, 45);
        } else if (last != -1) {
            this.setRange(set, last, last);
        }
        if (ch != 93) {
            throw this.error(L.l("Expected ']'"));
        }
        if (nodeList == null) {
            if (isNot) {
                return set.createNotNode();
            }
            return set.createNode();
        }
        RegexpNode setNode = set.createNode();
        for (RegexpNode node : nodeList) {
            setNode = setNode.createOr(node);
        }
        if (isNot) {
            return setNode.createNot();
        }
        return setNode;
    }

    private void setRange(RegexpSet set, int a, int b) {
        set.setRange(a, b);
        if (!this.isIgnoreCase()) {
            return;
        }
        if (Character.isLowerCase(a)) {
            if (Character.isLowerCase(b)) {
                set.setRange(Character.toUpperCase(a), Character.toUpperCase(b));
            } else {
                int min = -1;
                int max = -1;
                for (int i = a; i < b; ++i) {
                    if (Character.isLowerCase(i)) {
                        int uc = Character.toUpperCase(i);
                        if (min < 0) {
                            min = uc;
                            max = uc;
                            continue;
                        }
                        if (uc < min) {
                            set.setRange(min, max);
                            min = uc;
                            max = uc;
                            continue;
                        }
                        max = uc;
                        continue;
                    }
                    if (min <= 0) continue;
                    set.setRange(min, max);
                    min = -1;
                }
                if (min > 0) {
                    set.setRange(min, max);
                }
            }
        }
        if (Character.isUpperCase(a) && Character.isUpperCase(b)) {
            set.setRange(Character.toLowerCase(a), Character.toLowerCase(b));
        }
    }

    private RegexpSet getUnicodeSet(String name) throws IllegalRegexpException {
        this._flags |= 0x200;
        RegexpSet set = _unicodeBlockMap.get(name);
        if (set == null) {
            Character.UnicodeBlock block = Character.UnicodeBlock.forName(name);
            if (block == null) {
                throw new IllegalRegexpException(L.l("'{0}' is an unknown unicode block", (Object)name));
            }
            set = new RegexpSet();
            for (int ch = 0; ch < 65536; ++ch) {
                if (Character.UnicodeBlock.of(ch) != block) continue;
                set.setRange(ch, ch);
            }
            _unicodeBlockMap.put(name, set);
        }
        return set;
    }

    private RegexpNode parseSlash(PeekStream pattern) throws IllegalRegexpException {
        int ch = pattern.read();
        switch (ch) {
            case 115: {
                return RegexpNode.SPACE;
            }
            case 83: {
                return RegexpNode.NOT_SPACE;
            }
            case 100: {
                return RegexpNode.DIGIT;
            }
            case 68: {
                return RegexpNode.NOT_DIGIT;
            }
            case 119: {
                return RegexpNode.S_WORD;
            }
            case 87: {
                return RegexpNode.NOT_S_WORD;
            }
            case 98: {
                return RegexpNode.WORD;
            }
            case 66: {
                return RegexpNode.NOT_WORD;
            }
            case 65: {
                return RegexpNode.STRING_BEGIN;
            }
            case 122: {
                return RegexpNode.STRING_END;
            }
            case 90: {
                return RegexpNode.STRING_NEWLINE;
            }
            case 71: {
                return RegexpNode.STRING_FIRST;
            }
            case 97: {
                return this.parseString(7, pattern);
            }
            case 99: {
                ch = pattern.read();
                ch = Character.toUpperCase(ch);
                return this.parseString(ch ^= 0x40, pattern);
            }
            case 101: {
                return this.parseString(27, pattern, true);
            }
            case 110: {
                return this.parseString(10, pattern, true);
            }
            case 114: {
                return this.parseString(13, pattern, true);
            }
            case 102: {
                return this.parseString(12, pattern, true);
            }
            case 116: {
                return this.parseString(9, pattern, true);
            }
            case 120: {
                int hex = this.parseHex(pattern);
                return this.parseString(hex, pattern, true);
            }
            case 48: {
                int oct = this.parseOctal(ch, pattern);
                return this.parseString(oct, pattern, true);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.parseBackReference(ch, pattern);
            }
            case 112: {
                return this.parseUnicodeProperty(pattern, false);
            }
            case 80: {
                return this.parseUnicodeProperty(pattern, true);
            }
            case 81: {
                return this.parseQuotedString(pattern);
            }
            case 35: {
                return this.parseString(35, pattern, true);
            }
        }
        if ((this._flags & 0x100) != 0) {
            throw new IllegalRegexpException("unrecognized escape at " + this.badChar(ch));
        }
        return this.parseString(ch, pattern);
    }

    private RegexpSet parseCharacterClass(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = pattern.read()) != 58 && ch >= 0) {
            sb.append((char)ch);
        }
        if (ch != 58) {
            throw new IllegalRegexpException("expected character class closing colon ':' at " + this.badChar(ch));
        }
        ch = pattern.read();
        if (ch != 93) {
            throw new IllegalRegexpException("expected character class closing bracket ']' at " + this.badChar(ch));
        }
        String name = sb.toString();
        RegexpSet set = RegexpSet.CLASS_MAP.get(name);
        if (set == null) {
            throw new IllegalRegexpException("unrecognized POSIX character class " + name);
        }
        return set;
    }

    private int parseHex(PeekStream pattern) throws IllegalRegexpException {
        int ch = pattern.read();
        int hex = 0;
        StringBuilder sb = new StringBuilder();
        if (ch == 123) {
            while ((ch = pattern.read()) != 125) {
                if (ch < 0) {
                    throw new IllegalRegexpException("no more input; expected '}'");
                }
                sb.append((char)ch);
            }
        } else {
            if (ch < 0) {
                throw new IllegalRegexpException("expected hex digit at " + this.badChar(ch));
            }
            sb.append((char)ch);
            ch = pattern.read();
            if (ch < 0) {
                throw new IllegalRegexpException("expected hex digit at " + this.badChar(ch));
            }
            sb.append((char)ch);
        }
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            ch = sb.charAt(i);
            if (48 <= ch && ch <= 57) {
                hex = hex * 16 + ch - 48;
                continue;
            }
            if (97 <= ch && ch <= 102) {
                hex = hex * 16 + ch - 97 + 10;
                continue;
            }
            if (65 <= ch && ch <= 70) {
                hex = hex * 16 + ch - 65 + 10;
                continue;
            }
            this.error(L.l("expected hex digit at {0}", (Object)this.badChar(ch)));
        }
        return hex;
    }

    private RegexpNode parseBackReference(int ch, PeekStream pattern) throws IllegalRegexpException {
        int value = ch - 48;
        int ch2 = pattern.peek();
        if (48 <= ch2 && ch2 <= 57) {
            pattern.read();
            value = value * 10 + ch2 - 48;
        }
        int ch3 = pattern.peek();
        if (value < 10 || value <= this._nGroup && (48 > ch3 || ch3 > 55)) {
            return new RegexpNode.GroupRef(value);
        }
        if (!(48 <= ch2 && ch2 <= 55 || 48 <= ch3 && ch3 <= 55)) {
            throw new IllegalRegexpException("back referencing to a non-existent group: " + value);
        }
        if (value > 10) {
            pattern.ungetc(ch2);
        }
        if (ch == 56 || ch == 57 || 48 <= ch3 && ch3 <= 57 && value * 10 + ch3 - 48 > 255) {
            pattern.ungetc(ch);
            return this.parseString(0, pattern);
        }
        int oct = this.parseOctal(ch, pattern);
        return this.parseString(oct, pattern, true);
    }

    private RegexpNode parseString(int ch, PeekStream pattern) throws IllegalRegexpException {
        return this.parseString(ch, pattern, false);
    }

    private RegexpNode parseString(int ch, PeekStream pattern, boolean isEscaped) throws IllegalRegexpException {
        CharBuffer cb = new CharBuffer();
        cb.append((char)ch);
        ch = pattern.read();
        while (ch >= 0) {
            block0 : switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (this.isIgnoreWs() && !isEscaped) break;
                    cb.append((char)ch);
                    break;
                }
                case 35: {
                    if (!this.isIgnoreWs() || isEscaped) {
                        cb.append((char)ch);
                        break;
                    }
                    while ((ch = pattern.read()) != 10 && ch >= 0) {
                    }
                    break;
                }
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 63: 
                case 91: 
                case 94: 
                case 124: {
                    pattern.ungetc(ch);
                    return this.createString(cb);
                }
                case 123: {
                    if (48 <= pattern.peek() && pattern.peek() <= 57) {
                        pattern.ungetc(ch);
                        return this.createString(cb);
                    }
                    cb.append('{');
                    break;
                }
                case 92: {
                    ch = pattern.read();
                    block7 : switch (ch) {
                        case -1: {
                            cb.append('\\');
                            return this.createString(cb);
                        }
                        case 65: 
                        case 66: 
                        case 68: 
                        case 71: 
                        case 80: 
                        case 83: 
                        case 87: 
                        case 90: 
                        case 98: 
                        case 100: 
                        case 112: 
                        case 115: 
                        case 119: 
                        case 122: {
                            pattern.ungetc(ch);
                            pattern.ungetc(92);
                            return this.createString(cb);
                        }
                        case 97: {
                            cb.append('\u0007');
                            break;
                        }
                        case 99: {
                            ch = pattern.read();
                            ch = Character.toUpperCase(ch);
                            cb.append((char)(ch ^= 0x40));
                            break;
                        }
                        case 101: {
                            cb.append('\u001b');
                            break;
                        }
                        case 116: {
                            cb.append('\t');
                            break;
                        }
                        case 102: {
                            cb.append('\f');
                            break;
                        }
                        case 110: {
                            cb.append('\n');
                            break;
                        }
                        case 114: {
                            cb.append('\r');
                            break;
                        }
                        case 120: {
                            int hex = this.parseHex(pattern);
                            cb.append((char)hex);
                            break;
                        }
                        case 81: {
                            while ((ch = pattern.read()) >= 0) {
                                if (ch == 92 && pattern.peek() == 69) {
                                    pattern.read();
                                    break block7;
                                }
                                cb.append((char)ch);
                            }
                            break block0;
                        }
                        case 48: {
                            int oct = this.parseOctal(ch, pattern);
                            cb.append((char)oct);
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (ch - 48 <= this._nGroup) {
                                pattern.ungetc(ch);
                                pattern.ungetc(92);
                                return this.createString(cb);
                            }
                            int oct = this.parseOctal(ch, pattern);
                            cb.append((char)oct);
                            break;
                        }
                        case 35: {
                            cb.append('#');
                            break;
                        }
                        default: {
                            if ((this._flags & 0x100) != 0) {
                                throw this.error(L.l("unrecognized escape at " + this.badChar(ch)));
                            }
                            cb.append((char)ch);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    cb.append((char)ch);
                }
            }
            ch = pattern.read();
        }
        return this.createString(cb);
    }

    private RegexpNode parseQuotedString(PeekStream pattern) {
        int ch;
        CharBuffer cb = new CharBuffer();
        while ((ch = pattern.read()) >= 0) {
            if (ch == 92 && pattern.peek() == 69) {
                pattern.read();
                break;
            }
            cb.append((char)ch);
        }
        return this.createString(cb);
    }

    private RegexpNode createString(CharBuffer cb) {
        if (this.isIgnoreCase()) {
            return new RegexpNode.StringIgnoreCase(cb);
        }
        return new RegexpNode.StringNode(cb);
    }

    private RegexpNode createString(char ch) {
        if (this.isIgnoreCase()) {
            return new RegexpNode.StringIgnoreCase(ch);
        }
        return new RegexpNode.StringNode(ch);
    }

    private int parseOctal(int ch, PeekStream pattern) throws IllegalRegexpException {
        if (48 > ch || ch > 55) {
            throw new IllegalRegexpException("expected octal digit at " + this.badChar(ch));
        }
        int oct = ch - 48;
        int ch2 = pattern.peek();
        if (48 <= ch2 && ch2 <= 55) {
            pattern.read();
            oct = oct * 8 + ch2 - 48;
            ch = pattern.peek();
            if (48 <= ch && ch <= 55) {
                pattern.read();
                oct = oct * 8 + ch - 48;
            }
        }
        return oct;
    }

    private RegexpNode parseUnicodeProperty(PeekStream pattern, boolean isNegated) throws IllegalRegexpException {
        RegexpNode node;
        int ch = pattern.read();
        boolean isBraced = false;
        if (ch == 123) {
            isBraced = true;
            ch = pattern.read();
            if (ch == 94) {
                isNegated = !isNegated;
                ch = pattern.read();
            }
        }
        if (isBraced) {
            int ch2 = pattern.read();
            if (ch2 == 125) {
                node = this.parseUnicodeProperty(ch, isNegated);
            } else {
                node = this.parseUnicodeProperty(ch, ch2, isNegated);
                this.expect('}', pattern.read());
            }
        } else {
            node = this.parseUnicodeProperty(ch, isNegated);
        }
        return node;
    }

    private RegexpNode parseUnicodeProperty(int ch, int ch2, boolean isNegated) throws IllegalRegexpException {
        boolean category = false;
        switch (ch) {
            case 67: {
                switch (ch2) {
                    case 99: {
                        return isNegated ? RegexpNode.PROP_NOT_Cc : RegexpNode.PROP_Cc;
                    }
                    case 102: {
                        return isNegated ? RegexpNode.PROP_NOT_Cf : RegexpNode.PROP_Cf;
                    }
                    case 110: {
                        return isNegated ? RegexpNode.PROP_NOT_Cn : RegexpNode.PROP_Cn;
                    }
                    case 111: {
                        return isNegated ? RegexpNode.PROP_NOT_Co : RegexpNode.PROP_Co;
                    }
                    case 115: {
                        return isNegated ? RegexpNode.PROP_NOT_Cs : RegexpNode.PROP_Cs;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 76: {
                switch (ch2) {
                    case 108: {
                        return isNegated ? RegexpNode.PROP_NOT_Ll : RegexpNode.PROP_Ll;
                    }
                    case 109: {
                        return isNegated ? RegexpNode.PROP_NOT_Lm : RegexpNode.PROP_Lm;
                    }
                    case 111: {
                        return isNegated ? RegexpNode.PROP_NOT_Lo : RegexpNode.PROP_Lo;
                    }
                    case 116: {
                        return isNegated ? RegexpNode.PROP_NOT_Lt : RegexpNode.PROP_Lt;
                    }
                    case 117: {
                        return isNegated ? RegexpNode.PROP_NOT_Lu : RegexpNode.PROP_Lu;
                    }
                    case 125: {
                        return isNegated ? RegexpNode.PROP_NOT_L : RegexpNode.PROP_L;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 77: {
                switch (ch2) {
                    case 99: {
                        return isNegated ? RegexpNode.PROP_NOT_Mc : RegexpNode.PROP_Mc;
                    }
                    case 101: {
                        return isNegated ? RegexpNode.PROP_NOT_Me : RegexpNode.PROP_Me;
                    }
                    case 110: {
                        return isNegated ? RegexpNode.PROP_NOT_Mn : RegexpNode.PROP_Mn;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 78: {
                switch (ch2) {
                    case 100: {
                        return isNegated ? RegexpNode.PROP_NOT_Nd : RegexpNode.PROP_Nd;
                    }
                    case 108: {
                        return isNegated ? RegexpNode.PROP_NOT_Nl : RegexpNode.PROP_Nl;
                    }
                    case 111: {
                        return isNegated ? RegexpNode.PROP_NOT_No : RegexpNode.PROP_No;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 80: {
                switch (ch2) {
                    case 99: {
                        return isNegated ? RegexpNode.PROP_NOT_Pc : RegexpNode.PROP_Pc;
                    }
                    case 100: {
                        return isNegated ? RegexpNode.PROP_NOT_Pd : RegexpNode.PROP_Pd;
                    }
                    case 101: {
                        return isNegated ? RegexpNode.PROP_NOT_Pe : RegexpNode.PROP_Pe;
                    }
                    case 102: {
                        return isNegated ? RegexpNode.PROP_NOT_Pf : RegexpNode.PROP_Pf;
                    }
                    case 105: {
                        return isNegated ? RegexpNode.PROP_NOT_Pi : RegexpNode.PROP_Pi;
                    }
                    case 111: {
                        return isNegated ? RegexpNode.PROP_NOT_Po : RegexpNode.PROP_Po;
                    }
                    case 115: {
                        return isNegated ? RegexpNode.PROP_NOT_Ps : RegexpNode.PROP_Ps;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 83: {
                switch (ch2) {
                    case 99: {
                        return isNegated ? RegexpNode.PROP_NOT_Sc : RegexpNode.PROP_Sc;
                    }
                    case 107: {
                        return isNegated ? RegexpNode.PROP_NOT_Sk : RegexpNode.PROP_Sk;
                    }
                    case 109: {
                        return isNegated ? RegexpNode.PROP_NOT_Sm : RegexpNode.PROP_Sm;
                    }
                    case 111: {
                        return isNegated ? RegexpNode.PROP_NOT_So : RegexpNode.PROP_So;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
            case 90: {
                switch (ch2) {
                    case 108: {
                        return isNegated ? RegexpNode.PROP_NOT_Zl : RegexpNode.PROP_Zl;
                    }
                    case 112: {
                        return isNegated ? RegexpNode.PROP_NOT_Zp : RegexpNode.PROP_Zp;
                    }
                    case 115: {
                        return isNegated ? RegexpNode.PROP_NOT_Zs : RegexpNode.PROP_Zs;
                    }
                }
                throw this.error(L.l("invalid Unicode category {0}{1}", (Object)this.badChar(ch), (Object)this.badChar(ch2)));
            }
        }
        throw new UnsupportedOperationException();
    }

    private RegexpNode parseUnicodeProperty(int ch, boolean isNegated) throws IllegalRegexpException {
        switch (ch) {
            case 67: {
                return isNegated ? RegexpNode.PROP_NOT_C : RegexpNode.PROP_C;
            }
            case 76: {
                return isNegated ? RegexpNode.PROP_NOT_L : RegexpNode.PROP_L;
            }
            case 77: {
                return isNegated ? RegexpNode.PROP_NOT_M : RegexpNode.PROP_M;
            }
            case 78: {
                return isNegated ? RegexpNode.PROP_NOT_N : RegexpNode.PROP_N;
            }
            case 80: {
                return isNegated ? RegexpNode.PROP_NOT_P : RegexpNode.PROP_P;
            }
            case 83: {
                return isNegated ? RegexpNode.PROP_NOT_S : RegexpNode.PROP_S;
            }
            case 90: {
                return isNegated ? RegexpNode.PROP_NOT_Z : RegexpNode.PROP_Z;
            }
        }
        throw new IllegalRegexpException("invalid Unicode property " + this.badChar(ch));
    }
}

