/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.SplFileObject;
import com.caucho.vfs.Path;

public class SplFileInfo {
    protected Path _path;
    private String _openFileClassName;
    private String _infoFileClassName;

    public SplFileInfo(Env env, StringValue fileName) {
        this._path = this.init(env, fileName, false);
    }

    protected SplFileInfo(Path path) {
        this._path = path;
    }

    protected SplFileInfo(Env env, StringValue fileName, boolean isUseIncludePath) {
        this._path = this.init(env, fileName, true);
    }

    protected Path init(Env env, StringValue fileName, boolean isUseIncludePath) {
        if (isUseIncludePath) {
            return env.lookupInclude(fileName);
        }
        return env.lookupPwd(fileName);
    }

    public long getATime(Env env) {
        return this._path.getLastAccessTime() / 1000L;
    }

    public String getBasename(Env env, @Optional String suffix) {
        String name = this._path.getTail();
        if (suffix != null && name.endsWith(suffix)) {
            name = name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    public long getCTime(Env env) {
        return this._path.getCreateTime() / 1000L;
    }

    public String getExtension(Env env) {
        String name = this._path.getTail();
        int pos = name.lastIndexOf(46);
        if (0 <= pos && pos + 1 < name.length()) {
            return name.substring(pos + 1);
        }
        return "";
    }

    public SplFileInfo getFileInfo(Env env, @Optional String className) {
        throw new UnimplementedException("SplFileInfo::getFileInfo()");
    }

    public String getFilename(Env env) {
        return this._path.getTail();
    }

    public int getGroup(Env env) {
        return this._path.getGroup();
    }

    public long getInode(Env env) {
        return this._path.getInode();
    }

    public String getLinkTarget(Env env) {
        return this._path.readLink();
    }

    public long getMTime(Env env) {
        return this._path.getLastModified() / 1000L;
    }

    public int getOwner(Env env) {
        return this._path.getOwner();
    }

    public String getPath(Env env) {
        Path parent = this._path.getParent();
        return parent.getNativePath();
    }

    public SplFileInfo getPathInfo(Env env, @Optional String className) {
        throw new UnimplementedException("SplFileInfo::getPathInfo()");
    }

    public String getPathname(Env env) {
        return this._path.getNativePath();
    }

    public int getPerms(Env env) {
        return this._path.getMode();
    }

    public String getRealPath(Env env) {
        return this._path.realPath();
    }

    public long getSize(Env env) {
        return this._path.getLength();
    }

    public String getType(Env env) {
        if (this._path.isLink()) {
            return "link";
        }
        if (this._path.isDirectory()) {
            return "dir";
        }
        if (this._path.isFile()) {
            return "file";
        }
        return null;
    }

    public boolean isDir(Env env) {
        return this._path.isDirectory();
    }

    public boolean isExecutable(Env env) {
        return this._path.isExecutable();
    }

    public boolean isFile(Env env) {
        return this._path.isFile();
    }

    public boolean isLink(Env env) {
        return this._path.isLink();
    }

    public boolean isReadable(Env env) {
        return this._path.canRead();
    }

    public boolean isWritable(Env env) {
        return this._path.canWrite();
    }

    public SplFileObject openFile(Env env, @Optional(value="r") String mode, @Optional boolean isUseIncludePath, @Optional Value context) {
        throw new UnimplementedException("SplFileInfo::openFile()");
    }

    public void setFileClass(Env env, @Optional String className) {
        this._openFileClassName = className;
    }

    public void setInfoClass(Env env, @Optional String className) {
        this._infoFileClassName = className;
    }

    public String __toString(Env env) {
        return this._path.getNativePath();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }
}

