/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class BinaryValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BinaryValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        StringValue arg = value.toBinaryValue(env);
        assert (arg instanceof BinaryValue) : "" + value.getClass() + ".toBinaryValue() returned a " + arg.getClass();
        return arg;
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof BinaryBuilderValue) {
            return (BinaryBuilderValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toBinaryValue(env);
        }
        StringValue ret = env.createBinaryBuilder();
        ret.append(value);
        return ret;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toBinaryValueMarshalCost();
    }

    public Class getExpectedClass() {
        return BinaryValue.class;
    }
}

