/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassMarshal
extends Marshal {
    private static final Logger log = Logger.getLogger(ClassMarshal.class.getName());
    public static final ClassMarshal MARSHAL = new ClassMarshal();

    public boolean isString() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        Object obj = value.toJavaObject();
        if (obj instanceof Class) {
            return (Class)obj;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String className = value.toJavaString();
            if (className == null) {
                return null;
            }
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            env.warning("class argument is an unknown class: " + e);
            return null;
        }
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.wrapJava(value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        Object javaValue = argValue.toJavaObject();
        if (Class.class.equals(javaValue)) {
            return 0;
        }
        return argValue.toStringMarshalCost() + 1;
    }

    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 0;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Class.class;
    }
}

