/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;

public class ClassField {
    private final StringValue _name;
    private final StringValue _canonicalName;
    private final String _declaringClassName;
    private Expr _initValue;
    private boolean _isTraitField;
    private final String _comment;

    public ClassField(StringValue name, StringValue canonicalName, String declaringClassName, Expr initValue, String comment, boolean isTraitField) {
        this._name = name;
        this._canonicalName = canonicalName;
        this._declaringClassName = declaringClassName;
        this._initValue = initValue;
        this._comment = comment;
        this._isTraitField = isTraitField;
    }

    public ClassField(StringValue name, String declaringClassName, Expr initValue, FieldVisibility visibility, String comment, boolean isTraitField) {
        this._name = name;
        this._declaringClassName = declaringClassName;
        this._initValue = initValue;
        this._comment = comment;
        this._isTraitField = isTraitField;
        if (visibility.isProtected()) {
            StringValue sb = name.createStringBuilder();
            this._canonicalName = ClassField.createProtectedCanonicalName(sb, name);
        } else if (visibility.isPrivate()) {
            StringValue sb = name.createStringBuilder();
            this._canonicalName = ClassField.createPrivateCanonicalName(sb, name, declaringClassName);
        } else {
            this._canonicalName = name;
        }
    }

    public static StringValue getOrdinaryName(StringValue canonicalName) {
        if (ClassField.isPrivate(canonicalName)) {
            int p = canonicalName.lastIndexOf('\u0000');
            return canonicalName.substring(p + 1);
        }
        if (ClassField.isProtected(canonicalName)) {
            return canonicalName.substring(1);
        }
        return canonicalName;
    }

    public static StringValue createProtectedCanonicalName(StringValue sb, StringValue name) {
        sb.append('*');
        sb.append(name);
        return sb;
    }

    public static StringValue createPrivateCanonicalName(StringValue name, String declaringClass) {
        return ClassField.createPrivateCanonicalName(name.createStringBuilder(), name, declaringClass);
    }

    public static StringValue createPrivateCanonicalName(StringValue sb, StringValue name, String declaringClass) {
        sb.append('\u0000');
        sb.append(declaringClass);
        sb.append('\u0000');
        sb.append(name);
        return sb;
    }

    public static boolean isPublic(StringValue canonicalName) {
        return !ClassField.isProtected(canonicalName) && !ClassField.isPrivate(canonicalName);
    }

    public static boolean isPrivate(StringValue canonicalName) {
        return canonicalName.startsWith("\u0000");
    }

    public static boolean isProtected(StringValue canonicalName) {
        return canonicalName.startsWith("*");
    }

    public static StringValue getDeclaringClass(StringValue sb, StringValue canonicalName) {
        char ch;
        if (canonicalName.charAt(0) != '\u0000') {
            return sb;
        }
        int len = canonicalName.length();
        for (int i = 1; i < len && (ch = canonicalName.charAt(i)) != '\u0000'; ++i) {
            sb.append(ch);
        }
        return sb;
    }

    public String getDeclaringClassName() {
        return this._declaringClassName;
    }

    public StringValue getName() {
        return this._name;
    }

    public StringValue getCanonicalName() {
        return this._canonicalName;
    }

    public Expr getInitExpr() {
        return this._initValue;
    }

    public void setInitExpr(Expr initValue) {
        this._initValue = initValue;
    }

    public Value evalInitExpr(Env env) {
        return this._initValue.eval(env).copy();
    }

    public boolean isPublic() {
        return !this.isProtected() && !this.isPrivate();
    }

    public boolean isProtected() {
        return ClassField.isProtected(this._canonicalName);
    }

    public boolean isPrivate() {
        return ClassField.isPrivate(this._canonicalName);
    }

    public boolean isTraitField() {
        return this._isTraitField;
    }

    public String getComment() {
        return this._comment;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._canonicalName + "]";
    }
}

