/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.RollbackExceptionWrapper;
import com.caucho.transaction.SystemExceptionWrapper;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.transaction.UserTransactionSuspendState;
import com.caucho.transaction.XidImpl;
import com.caucho.transaction.xalog.AbstractXALogStream;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.LocalTransaction;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImpl
implements Transaction,
AlarmListener {
    private static final Logger log = Logger.getLogger(TransactionImpl.class.getName());
    private static final L10N L = new L10N(TransactionImpl.class);
    private static final long EXTRA_TIMEOUT = 0L;
    private static final long MAX_TIMEOUT = 86400000L;
    private static final int RES_ACTIVE = 1;
    private static final int RES_SHARED_RM = 2;
    private static final int RES_SUSPENDED = 4;
    private static final int RES_COMMIT = 8;
    private TransactionManagerImpl _transactionManager;
    private UserTransactionImpl _userTransaction;
    private UserTransactionSuspendState _suspendState;
    private XidImpl _xid;
    private int _resourceCount;
    private XAResource[] _resources;
    private LocalTransaction _localTransaction;
    private XidImpl[] _resourceXids;
    private int[] _resourceStates;
    private Map<Object, Object> _mappedResources;
    private long _timeout = 0L;
    private ArrayList<Synchronization> _interposedSynchronizations;
    private ArrayList<Synchronization> _synchronizations;
    private int _status;
    private boolean _isSuspended;
    private boolean _isDead;
    private Throwable _rollbackException;
    private AbstractXALogStream _xaLog;
    private HashMap<String, Object> _attributes;
    private long _beginTime;
    private Alarm _alarm;

    TransactionImpl(TransactionManagerImpl manager) {
        this._transactionManager = manager;
        this._timeout = this._transactionManager.getTimeout();
        this._status = 6;
        this._alarm = new Alarm("xa-timeout", (AlarmListener)this, ClassLoader.getSystemClassLoader());
    }

    public static TransactionImpl getCurrent() {
        return TransactionManagerImpl.getLocal().getCurrent();
    }

    public void setUserTransaction(UserTransactionImpl ut) {
        this._userTransaction = ut;
    }

    public Xid getXid() {
        return this._xid;
    }

    boolean hasResources() {
        return this._resourceCount > 0;
    }

    public boolean isActive() {
        return this._status == 0;
    }

    boolean isSuspended() {
        return this._isSuspended;
    }

    boolean isDead() {
        return this._isDead;
    }

    public void putResource(Object key, XAResource resource) throws RollbackException, SystemException {
        this.enlistResource(resource);
        if (this._mappedResources == null) {
            this._mappedResources = new HashMap<Object, Object>();
        }
        this._mappedResources.put(key, resource);
    }

    public void putResource(Object key, Object resource) {
        if (this._mappedResources == null) {
            this._mappedResources = new HashMap<Object, Object>();
        }
        this._mappedResources.put(key, resource);
    }

    public Object getResource(Object key) {
        Map<Object, Object> mappedResources = this._mappedResources;
        if (mappedResources != null) {
            return mappedResources.get(key);
        }
        return null;
    }

    public boolean enlistResource(XAResource resource) throws RollbackException, SystemException {
        if (resource == null) {
            throw new IllegalArgumentException(L.l("Resource must not be null in enlistResource"));
        }
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("Can't enlist resource {0} because the transaction is suspended.", (Object)resource));
        }
        if (this._status != 0) {
            if (this._status == 1) {
                if (this._rollbackException != null) {
                    throw RollbackExceptionWrapper.create(this._rollbackException);
                }
                throw new RollbackException(L.l("Can't enlist resource {0} because the transaction is marked rollback-only.", (Object)resource));
            }
            if (this._status == 6) {
                throw new IllegalStateException(L.l("Can't enlist resource {0} because the transaction is not active", (Object)resource));
            }
            throw new IllegalStateException(L.l("Can't enlist resource {0} because the transaction is not in an active state.  state='{1}'", (Object)resource, (Object)TransactionImpl.xaState(this._status)));
        }
        if (this._resources == null) {
            this._resources = new XAResource[16];
            this._resourceXids = new XidImpl[16];
            this._resourceStates = new int[16];
        } else if (this._resources.length <= this._resourceCount) {
            int oldLength = this._resources.length;
            int newLength = 2 * oldLength;
            XAResource[] resources = new XAResource[newLength];
            XidImpl[] resourceXids = new XidImpl[newLength];
            int[] resourceStates = new int[newLength];
            System.arraycopy(this._resources, 0, resources, 0, oldLength);
            System.arraycopy(this._resourceStates, 0, resourceStates, 0, oldLength);
            System.arraycopy(this._resourceXids, 0, resourceXids, 0, oldLength);
            this._resources = resources;
            this._resourceStates = resourceStates;
            this._resourceXids = resourceXids;
        }
        int flags = 0;
        XidImpl xid = this._xid;
        boolean hasNewResource = true;
        for (int i = 0; i < this._resourceCount; ++i) {
            if (this._resources[i] == resource && (this._resourceStates[i] & 1) != 0) {
                IllegalStateException exn = new IllegalStateException(L.l("Can't enlist same resource {0} twice. Delist is required before calling enlist with an old resource.", (Object)resource));
                this.setRollbackOnly(exn);
                throw exn;
            }
            try {
                if (!this._resources[i].isSameRM(resource)) continue;
                flags = 0x200000;
                xid = this._resourceXids[i];
                if ((this._resourceStates[i] & 1) != 0) break;
                this._resources[i] = resource;
                int n = i;
                this._resourceStates[n] = this._resourceStates[n] | 1;
                hasNewResource = false;
                break;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._resourceCount > 0 && flags != 0x200000) {
            xid = new XidImpl(this._xid, this._resourceCount + 1);
        }
        try {
            if (this._timeout > 0L) {
                resource.setTransactionTimeout((int)(this._timeout / 1000L));
            }
            if (log.isLoggable(Level.FINER)) {
                if (flags == 0x200000) {
                    log.finer(this + " join-XA " + resource);
                } else {
                    log.finer(this + " start-XA " + resource);
                }
            }
            resource.start(xid, flags);
        }
        catch (XAException e) {
            this.setRollbackOnly(e);
            String message = L.l("Failed to enlist resource {0} in transaction because of exception:\n{1}", (Object)resource, (Object)e);
            log.log(Level.SEVERE, message, e);
            throw new SystemException(message);
        }
        if (hasNewResource) {
            this._resources[this._resourceCount] = resource;
            this._resourceStates[this._resourceCount] = 1;
            if (flags == 0x200000) {
                int n = this._resourceCount;
                this._resourceStates[n] = this._resourceStates[n] | 2;
            }
            this._resourceXids[this._resourceCount] = xid;
            ++this._resourceCount;
        }
        return true;
    }

    public boolean delistResource(XAResource resource, int flag) throws SystemException {
        int index;
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("transaction is suspended"));
        }
        if (this._resourceCount == 0) {
            return true;
        }
        for (index = this._resourceCount - 1; index >= 0 && !this._resources[index].equals(resource); --index) {
        }
        if (index < 0) {
            return false;
        }
        if (this._status == 6) {
            while (index + 1 < this._resourceCount) {
                this._resources[index] = this._resources[index + 1];
                this._resourceStates[index] = this._resourceStates[index + 1];
                this._resourceXids[index] = this._resourceXids[index + 1];
                ++index;
            }
            --this._resourceCount;
            return true;
        }
        if (this._status == 1) {
            flag = 0x20000000;
        }
        int n = index;
        this._resourceStates[n] = this._resourceStates[n] & 0xFFFFFFFE;
        try {
            resource.end(this._resourceXids[index], flag);
        }
        catch (XAException e) {
            this.setRollbackOnly(e);
            String message = L.l("Failed to delist resource due to: {0}", (Object)e);
            log.log(Level.SEVERE, message, e);
            throw new SystemException(message);
        }
        return true;
    }

    public int getEnlistedResourceCount() {
        return this._resourceCount;
    }

    public boolean isEmpty() {
        if (this._isDead) {
            return true;
        }
        if (this._resourceCount > 0) {
            return false;
        }
        return this._synchronizations == null || this._synchronizations.size() <= 1;
    }

    public boolean allowLocalTransactionOptimization() {
        return this._resourceCount == 0;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this._timeout = seconds == 0 ? this._transactionManager.getTimeout() : (seconds < 0 ? 86400000L : 1000L * (long)seconds);
        if (this._status == 0 && this._timeout > 0L) {
            this._alarm.queue(this._timeout + 0L);
        } else {
            this._alarm.dequeue();
        }
    }

    public int getTransactionTimeout() throws SystemException {
        if (this._timeout < 0L) {
            return -1;
        }
        return (int)(this._timeout / 1000L);
    }

    public void setAttribute(String var, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(var, value);
    }

    public Object getAttribute(String var) {
        if (this._attributes != null) {
            return this._attributes.get(var);
        }
        return null;
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        if (this._interposedSynchronizations == null) {
            this._interposedSynchronizations = new ArrayList();
        }
        this._interposedSynchronizations.add(synchronization);
    }

    public void registerSynchronization(Synchronization synchronization) {
        if (this._synchronizations == null) {
            this._synchronizations = new ArrayList();
        }
        this._synchronizations.add(synchronization);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " registerSync " + synchronization);
        }
    }

    public int getStatus() {
        return this._status;
    }

    void begin() throws SystemException, NotSupportedException {
        if (this._status != 6) {
            int status = this._status;
            throw new NotSupportedException(L.l("{0} nested transactions are not supported. The previous transaction for this thread did not commit() or rollback(). Check that every UserTransaction.begin() has its commit() or rollback() in a finally block.\nStatus was {1}.", (Object)this, (Object)TransactionImpl.xaState(status)));
        }
        if (this._isDead) {
            throw new IllegalStateException(L.l("{0} error trying to use dead transaction."));
        }
        this._status = 0;
        this._beginTime = CurrentTime.getCurrentTime();
        this._rollbackException = null;
        if (this._xid == null) {
            this._xid = this._transactionManager.createXID();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " begin");
        }
        if (this._timeout > 0L) {
            this._alarm.queue(this._timeout + 0L);
        }
    }

    void suspend() throws SystemException {
        if (this._isSuspended) {
            throw new IllegalStateException(L.l("can't suspend already-suspended transaction"));
        }
        this._isSuspended = true;
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            if ((this._resourceStates[i] & 5) != 1) continue;
            try {
                XAResource resource = this._resources[i];
                resource.end(this._resourceXids[i], 0x2000000);
                continue;
            }
            catch (Exception e) {
                this.setRollbackOnly(e);
            }
        }
        if (this._userTransaction != null) {
            this._suspendState = this._userTransaction.userSuspend();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " suspended");
        }
    }

    void resume() throws SystemException {
        if (!this._isSuspended) {
            throw new IllegalStateException(L.l("can't resume non-suspended transaction"));
        }
        if (this._timeout > 0L) {
            this._alarm.queue(this._timeout + 0L);
        }
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            if ((this._resourceStates[i] & 5) != 1) continue;
            try {
                XAResource resource = this._resources[i];
                resource.start(this._resourceXids[i], 0x8000000);
                continue;
            }
            catch (Exception e) {
                this.setRollbackOnly(e);
            }
        }
        if (this._userTransaction != null) {
            this._userTransaction.userResume(this._suspendState);
        }
        this._isSuspended = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " resume");
        }
    }

    public void setRollbackOnly() throws SystemException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(L.l("Can't set rollback-only because the transaction is not active, state={0}.", (Object)TransactionImpl.xaState(this._status)));
        }
        this._status = 1;
        this._alarm.dequeue();
        this._timeout = 0L;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback-only");
        }
        if (this._rollbackException == null) {
            this._rollbackException = new RollbackException(L.l("Transaction marked rollback-only"));
            this._rollbackException.fillInStackTrace();
        }
    }

    public void setRollbackOnly(Throwable exn) {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(L.l("Can't set rollback-only because the transaction is not active, state={0}.", (Object)TransactionImpl.xaState(this._status)));
        }
        this._status = 1;
        if (this._rollbackException == null) {
            this._rollbackException = exn;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this + " rollback-only: " + exn.toString(), exn);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback-only: " + exn.toString());
        }
    }

    public boolean isRollbackOnly() {
        return this._status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this._alarm.dequeue();
        Exception heuristicExn = null;
        try {
            switch (this._status) {
                case 0: {
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine(this + " commit (active)");
                    break;
                }
                case 1: {
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine(this + " commit (marked rollback)");
                    break;
                }
                case 6: {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " commit (no transaction)");
                    }
                    throw new IllegalStateException(L.l("Can't commit outside of a transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back."));
                }
                default: {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " commit (unknown: " + this._status + ")");
                    }
                    this.rollbackInt();
                    throw new IllegalStateException(L.l("Can't commit because the transaction state is {0}", (Object)String.valueOf(this._status)));
                }
            }
            try {
                this.callBeforeCompletion();
            }
            catch (RollbackException e) {
                this.rollbackInt();
                throw e;
            }
            catch (Throwable e) {
                this.setRollbackOnly(e);
                this.rollbackInt();
                RollbackException newException = new RollbackException(e.toString());
                newException.initCause(e);
                throw newException;
            }
            if (this._status == 1) {
                this.rollbackInt();
                if (this._rollbackException != null) {
                    throw new RollbackExceptionWrapper(L.l("Transaction can't commit because it has been marked rolled back\n  {0}", (Object)this._rollbackException), this._rollbackException);
                }
                throw new RollbackException(L.l("Transaction can't commit because it has been marked rolled back."));
            }
            if (this._resourceCount > 0) {
                this._status = 7;
                AbstractXALogStream xaLog = this._transactionManager.getXALogStream();
                boolean hasPrepare = false;
                boolean allowSinglePhase = false;
                for (int i = this._resourceCount - 1; i >= 0; --i) {
                    XAResource resource = this._resources[i];
                    if (!(i != 0 || xaLog != null && hasPrepare)) {
                        this._resourceStates[0] = this._resourceStates[0] | 8;
                        allowSinglePhase = true;
                        break;
                    }
                    if ((this._resourceStates[i] & 2) != 0) continue;
                    try {
                        int prepare = resource.prepare(this._resourceXids[i]);
                        if (prepare == 3) continue;
                        if (prepare == 0) {
                            hasPrepare = true;
                            int n = i;
                            this._resourceStates[n] = this._resourceStates[n] | 8;
                            continue;
                        }
                        log.finer(this + " unexpected prepare result " + prepare);
                        this.rollbackInt();
                        continue;
                    }
                    catch (XAException e) {
                        this._transactionManager.addCommitResourceFail();
                        heuristicExn = this.heuristicException(heuristicExn, e);
                        this.rollbackInt();
                        throw new RollbackExceptionWrapper(L.l("all commits rolled back"), heuristicExn);
                    }
                }
                if (hasPrepare && xaLog != null) {
                    this._xaLog = xaLog;
                    xaLog.writeTMCommit(this._xid);
                }
                this._status = 8;
                Exception exn = this.commitResources(allowSinglePhase);
                if (heuristicExn == null) {
                    heuristicExn = exn;
                }
            }
            if (heuristicExn != null && log.isLoggable(Level.FINE)) {
                log.fine(this + " " + heuristicExn);
            }
            this._status = 4;
            if (heuristicExn != null) {
                if (heuristicExn instanceof RollbackException) {
                    throw (RollbackException)((Object)heuristicExn);
                }
                if (heuristicExn instanceof HeuristicMixedException) {
                    throw (HeuristicMixedException)heuristicExn;
                }
                if (heuristicExn instanceof HeuristicRollbackException) {
                    throw (HeuristicRollbackException)heuristicExn;
                }
                if (heuristicExn instanceof SystemException) {
                    throw (SystemException)heuristicExn;
                }
                throw RollbackExceptionWrapper.create(heuristicExn);
            }
            this._status = 3;
            Object var9_13 = null;
            this.callAfterCompletion();
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.callAfterCompletion();
            throw throwable;
        }
    }

    private Exception commitResources(boolean allowSinglePhase) {
        Exception heuristicExn = null;
        if (allowSinglePhase) {
            try {
                XAResource resource = this._resources[0];
                if ((this._resourceStates[0] & 8) != 0) {
                    resource.commit(this._xid, true);
                }
                if (this._timeout > 0L) {
                    resource.setTransactionTimeout(0);
                }
            }
            catch (XAException e) {
                log.log(Level.FINE, e.toString(), e);
                heuristicExn = this.heuristicException(heuristicExn, e);
                this._transactionManager.addCommitResourceFail();
            }
        }
        for (int i = 0; i < this._resourceCount; ++i) {
            XAResource resource = this._resources[i];
            if (i == 0 && allowSinglePhase || (this._resourceStates[i] & 2) != 0 || (this._resourceStates[i] & 8) == 0) continue;
            if (heuristicExn == null) {
                try {
                    resource.commit(this._resourceXids[i], false);
                    if (this._timeout <= 0L) continue;
                    resource.setTransactionTimeout(0);
                }
                catch (XAException e) {
                    this._transactionManager.addCommitResourceFail();
                    heuristicExn = e;
                    log.log(Level.FINE, e.toString(), e);
                }
                continue;
            }
            try {
                resource.rollback(this._resourceXids[i]);
                if (this._timeout <= 0L) continue;
                resource.setTransactionTimeout(0);
                continue;
            }
            catch (XAException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return heuristicExn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        this._alarm.dequeue();
        try {
            this.callBeforeCompletion();
        }
        catch (Throwable e) {
            this.setRollbackOnly(e);
        }
        try {
            switch (this._status) {
                case 0: 
                case 1: {
                    break;
                }
                case 6: {
                    throw new IllegalStateException(L.l("Can't rollback outside of a transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back."));
                }
                default: {
                    this.rollbackInt();
                    throw new IllegalStateException(L.l("Can't rollback in state: {0}", (Object)String.valueOf(this._status)));
                }
            }
            this._status = 1;
            this.rollbackInt();
            Object var3_2 = null;
            this.callAfterCompletion();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.callAfterCompletion();
            throw throwable;
        }
    }

    private Exception heuristicException(Exception oldException, XAException xaException) {
        switch (xaException.errorCode) {
            case 7: 
            case 8: {
                return oldException;
            }
            case 6: {
                if (oldException instanceof HeuristicMixedException) {
                    return oldException;
                }
                if (oldException instanceof HeuristicRollbackException) {
                    return oldException;
                }
                if (oldException instanceof RollbackException) {
                    return oldException;
                }
                return new HeuristicRollbackException(TransactionImpl.getXAMessage(xaException));
            }
        }
        if (oldException instanceof SystemException) {
            return oldException;
        }
        return new SystemExceptionWrapper(TransactionImpl.getXAMessage(xaException), xaException);
    }

    private void rollbackInt() {
        this._status = 9;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback");
        }
        for (int i = 0; i < this._resourceCount; ++i) {
            XAResource resource = this._resources[i];
            if ((this._resourceStates[i] & 2) != 0) continue;
            try {
                resource.rollback(this._resourceXids[i]);
                if (this._timeout <= 0L) continue;
                resource.setTransactionTimeout(0);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        this._status = 4;
    }

    private void callBeforeCompletion() throws RollbackException {
        Synchronization sync;
        int i;
        this._alarm.dequeue();
        if (this._interposedSynchronizations != null) {
            for (i = 0; i < this._interposedSynchronizations.size(); ++i) {
                sync = this._interposedSynchronizations.get(i);
                try {
                    sync.beforeCompletion();
                    continue;
                }
                catch (RuntimeException e) {
                    this.setRollbackOnly(e);
                    RollbackException newException = new RollbackException(e.toString());
                    newException.initCause((Throwable)e);
                    throw newException;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        if (this._synchronizations != null) {
            for (i = 0; i < this._synchronizations.size(); ++i) {
                sync = this._synchronizations.get(i);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " beforeCompletion " + sync);
                }
                try {
                    sync.beforeCompletion();
                    continue;
                }
                catch (RuntimeException e) {
                    this.setRollbackOnly(e);
                    RollbackException newException = new RollbackException(e.toString());
                    newException.initCause((Throwable)e);
                    throw newException;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        for (i = this._resourceCount - 1; i >= 0; --i) {
            XAResource resource = this._resources[i];
            int flag = this._status == 1 ? 0x20000000 : 0x4000000;
            try {
                if ((this._resourceStates[i] & 1) == 0) continue;
                resource.end(this._resourceXids[i], flag);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                this.setRollbackOnly(e);
            }
        }
    }

    private void callAfterCompletion() {
        Synchronization sync;
        int i;
        ArrayList<Synchronization> interposedSynchronizations = this._interposedSynchronizations;
        this._interposedSynchronizations = null;
        ArrayList<Synchronization> synchronizations = this._synchronizations;
        this._synchronizations = null;
        this._userTransaction = null;
        this._timeout = this._transactionManager.getTimeout();
        XidImpl xid = this._xid;
        this._xid = null;
        int status = this._status;
        this._status = 6;
        this._rollbackException = null;
        for (int i2 = this._resourceCount - 1; i2 >= 0; --i2) {
            this._resources[i2] = null;
        }
        this._resourceCount = 0;
        this._mappedResources = null;
        AbstractXALogStream xaLog = this._xaLog;
        this._xaLog = null;
        if (xaLog != null) {
            try {
                xaLog.writeTMFinish(xid);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        int length = interposedSynchronizations == null ? 0 : interposedSynchronizations.size();
        for (i = length - 1; i >= 0; --i) {
            sync = interposedSynchronizations.get(i);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " afterCompletion " + sync);
                }
                sync.afterCompletion(status);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        length = synchronizations == null ? 0 : synchronizations.size();
        for (i = 0; i < length; ++i) {
            sync = synchronizations.get(i);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " afterCompletion " + sync);
                }
                sync.afterCompletion(status);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
        if (status == 3) {
            this._transactionManager.endCommitTime(this._beginTime);
        } else {
            this._transactionManager.endRollbackTime(this._beginTime);
        }
    }

    public void handleAlarm(Alarm alarm) {
        try {
            String msg = L.l("{0}: timed out after {1} seconds.", (Object)this, (Object)String.valueOf((long)this.getTransactionTimeout() + 0L));
            log.warning(msg);
            RollbackException exn = new RollbackException(msg);
            this.setRollbackOnly(exn);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this._isDead = true;
        this._alarm.dequeue();
        try {
            if (this._status != 6) {
                this.rollback();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this._synchronizations != null) {
            this._synchronizations.clear();
        }
        if (this._interposedSynchronizations != null) {
            this._interposedSynchronizations.clear();
        }
        for (int i = this._resourceCount - 1; i >= 0; --i) {
            this._resources[i] = null;
        }
        this._resourceCount = 0;
        Map<Object, Object> mappedResources = this._mappedResources;
        this._mappedResources = null;
        if (mappedResources != null) {
            mappedResources.clear();
        }
        this._xid = null;
        this._timeout = this._transactionManager.getTimeout();
    }

    public String toString() {
        if (this._xid == null) {
            return "Transaction[]";
        }
        CharBuffer cb = new CharBuffer();
        cb.append("Transaction[");
        byte[] branch = this._xid.getBranchQualifier();
        this.addByte(cb, branch[0]);
        cb.append(":");
        byte[] global = this._xid.getGlobalTransactionId();
        for (int i = 24; i < 28; ++i) {
            this.addByte(cb, global[i]);
        }
        cb.append("]");
        return cb.toString();
    }

    private void addByte(CharBuffer cb, int b) {
        int h = b / 16 & 0xF;
        int l = b & 0xF;
        if (h >= 10) {
            cb.append((char)(97 + h - 10));
        } else {
            cb.append((char)(48 + h));
        }
        if (l >= 10) {
            cb.append((char)(97 + l - 10));
        } else {
            cb.append((char)(48 + l));
        }
    }

    private static String getXAMessage(XAException xaException) {
        if (xaException.getMessage() != null && !xaException.getMessage().equals("")) {
            return xaException.getMessage();
        }
        return TransactionImpl.xaName(xaException.errorCode) + ": " + TransactionImpl.xaMessage(xaException.errorCode);
    }

    private static String xaState(int xaState) {
        switch (xaState) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "MARKED-ROLLBACK";
            }
            case 2: {
                return "PREPARED";
            }
            case 3: {
                return "COMITTED";
            }
            case 4: {
                return "ROLLEDBACK";
            }
            case 7: {
                return "PREPARING";
            }
            case 8: {
                return "COMMITTING";
            }
            case 9: {
                return "ROLLING_BACK";
            }
            case 6: {
                return "NO_TRANSACTION";
            }
        }
        return "XA-STATE(" + xaState + ")";
    }

    private static String xaName(int xaCode) {
        switch (xaCode) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case -3: {
                return "XA_RMERR";
            }
            case -4: {
                return "XA_NOTA";
            }
            case -5: {
                return "XA_INVAL";
            }
            case -6: {
                return "XA_PROTO";
            }
            case -7: {
                return "XA_RMFAIL";
            }
            case -8: {
                return "XA_DUPID";
            }
            case -9: {
                return "XA_OUTSIDE";
            }
        }
        return "XA(" + xaCode + ")";
    }

    private static String xaMessage(int xaCode) {
        switch (xaCode) {
            case 100: 
            case 104: {
                return L.l("Resource rolled back for an unspecified reason.");
            }
            case 101: {
                return L.l("Resource rolled back because of a communication failure.");
            }
            case 102: {
                return L.l("Resource rolled back because of a deadlock.");
            }
            case 103: {
                return L.l("Resource rolled back because of an integrity check failure.");
            }
            case 105: {
                return L.l("Resource rolled back because of a protocol error in the resource manager.");
            }
            case 106: {
                return L.l("Resource rolled back because of a timeout.");
            }
            case 107: {
                return L.l("Resource rolled back because of transient error.");
            }
            case 9: {
                return L.l("Resumption must occur where the suspension occurred.");
            }
            case 8: {
                return L.l("Resource may have been heuristically completed.");
            }
            case 7: {
                return L.l("Resource has been heuristically committed.");
            }
            case 6: {
                return L.l("Resource has been heuristically rolled back.");
            }
            case 5: {
                return L.l("Resource has been heuristically committed and rolled back.");
            }
            case 3: {
                return L.l("Resource was read-only and has been heuristically committed.");
            }
            case -3: {
                return L.l("Resource manager error.");
            }
            case -4: {
                return L.l("The XID (transaction identifier) was invalid.");
            }
            case -5: {
                return L.l("Invalid arguments were given.");
            }
            case -6: {
                return L.l("Method called in an invalid context.");
            }
            case -7: {
                return L.l("Resource manager is unavailable.");
            }
            case -8: {
                return L.l("Duplicate XID (transaction identifier).");
            }
            case -9: {
                return L.l("Resource manager called outside of transaction.");
            }
        }
        return "";
    }
}

