/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpandableArray<T> {
    private final int INITIAL_SIZE = 8;
    private final int CHUNK_SIZE = 8192;
    private final Class<T> _type;
    private T[] _data;
    private int _size;

    public ExpandableArray(Class<T> type) {
        this._type = type;
        this._data = this.createArray(8);
    }

    public final int getCapacity() {
        return this._data.length;
    }

    public int getSize() {
        return this._size;
    }

    public final T[] getArray() {
        return this._data;
    }

    public final void add(T value) {
        T[] data = this._data;
        int capacity = data.length;
        int size = this._size;
        if (capacity <= size) {
            this.expandData(size + 1);
            data = this._data;
            size = this._size;
        }
        data[size] = value;
        this._size = size + 1;
    }

    public final void remove(int index) {
        T[] data = this._data;
        int size = this._size;
        System.arraycopy(data, index + 1, data, index, size - index - 1);
        this._size = size - 1;
    }

    private void expandData(int requiredCapacity) {
        int capacity;
        if (8192 < requiredCapacity) {
            capacity = requiredCapacity + 8192 - 1 & 0xFFFFDFFF;
        } else {
            for (capacity = this._data.length; capacity < requiredCapacity; capacity = 2 * capacity) {
            }
        }
        T[] newData = this.createArray(capacity);
        System.arraycopy(this._data, 0, newData, 0, this._size);
        this._data = newData;
    }

    private T[] createArray(int size) {
        return (Object[])Array.newInstance(this._type, size);
    }
}

