/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeList;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class ResinDeflaterInputStream
extends OutputStream {
    private static FreeList<Deflater> _freeDeflaterList = new FreeList(16);
    private OutputStream _os;
    private Deflater _deflater;
    private byte[] _byteBuf = new byte[1];
    private TempBuffer _tempBuf;
    private byte[] _buf;

    public ResinDeflaterInputStream(OutputStream os) {
        this.init(os);
    }

    public void init(OutputStream os) {
        this._os = os;
        this._tempBuf = TempBuffer.allocate();
        this._buf = this._tempBuf.getBuffer();
        try {
            this._deflater = _freeDeflaterList.allocate();
            if (this._deflater == null) {
                this._deflater = new Deflater();
            } else {
                this._deflater.reset();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(int value) throws IOException {
        this._byteBuf[0] = (byte)value;
        this.write(this._byteBuf, 0, 1);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        Deflater def = this._deflater;
        while (length > 0) {
            int sublen = length;
            if (this._buf.length < sublen) {
                sublen = this._buf.length;
            }
            def.setInput(buffer, offset, sublen);
            while (!def.needsInput()) {
                this.deflate();
            }
            offset += sublen;
            length -= sublen;
        }
    }

    private void deflate() throws IOException {
        int len = this._deflater.deflate(this._buf, 0, this._buf.length);
        if (len > 0) {
            this._os.write(this._buf, 0, len);
        }
    }

    public void close() throws IOException {
        Deflater deflater = this._deflater;
        if (deflater == null) {
            return;
        }
        deflater.finish();
        while (!deflater.finished()) {
            this.deflate();
        }
        this._deflater = null;
        if (!_freeDeflaterList.free(deflater)) {
            deflater.end();
        }
        this._buf = null;
        TempBuffer tempBuf = this._tempBuf;
        this._tempBuf = null;
        TempBuffer.free(tempBuf);
    }
}

