/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ComparableElement;
import com.caucho.util.TimeIntervalEntry;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TimeInterval
extends ComparableElement<TimeInterval>,
Comparator<TimeInterval>,
TimeIntervalEntry {
    public long startTime();

    public long stopTime();

    public long duration();

    public boolean current();

    public boolean current(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Comparison implements ComparableElement.Comparison<TimeInterval>
    {
        PRECEDES(IntervalDistance.DISJOINT, Relation.BEFORE),
        PRECEDES_IMMEDIATELY(IntervalDistance.CONTIGUOUS, Relation.BEFORE),
        ENDS_DURING(IntervalDistance.OVERLAPPING, Relation.BEFORE),
        CONTAINS(IntervalDistance.NESTED, Relation.CHILD),
        IS_CONTAINED(IntervalDistance.NESTED, Relation.PARENT),
        EQUAL(IntervalDistance.EQUAL, Relation.EQUAL),
        STARTS_DURING(IntervalDistance.OVERLAPPING, Relation.AFTER),
        FOLLOWS_IMMEDIATELY(IntervalDistance.CONTIGUOUS, Relation.AFTER),
        FOLLOWS(IntervalDistance.DISJOINT, Relation.AFTER);

        private int _distance;

        private Comparison(IntervalDistance intervalDistance, Relation relation) {
            this._distance = intervalDistance.value() * Integer.signum(relation.value());
        }

        @Override
        public int value() {
            return this._distance;
        }

        public static Comparison comparison(TimeInterval a, TimeInterval b) {
            long aStarts = a.startTime();
            long aStops = a.stopTime();
            long bStarts = b.startTime();
            long bStops = b.stopTime();
            switch (Relation.comparison(aStarts, bStarts)) {
                case BEFORE: {
                    switch (Relation.comparison(aStarts, bStops)) {
                        case BEFORE: {
                            return PRECEDES;
                        }
                        case EQUAL: {
                            return PRECEDES_IMMEDIATELY;
                        }
                        case AFTER: {
                            return bStops > aStops ? CONTAINS : ENDS_DURING;
                        }
                    }
                }
                case EQUAL: {
                    switch (Relation.comparison(aStops, bStops)) {
                        case BEFORE: {
                            return CONTAINS;
                        }
                        case EQUAL: {
                            return EQUAL;
                        }
                        case AFTER: {
                            return IS_CONTAINED;
                        }
                    }
                }
                case AFTER: {
                    switch (Relation.comparison(aStops, bStarts)) {
                        case BEFORE: {
                            return aStops > bStops ? IS_CONTAINED : STARTS_DURING;
                        }
                        case EQUAL: {
                            return FOLLOWS_IMMEDIATELY;
                        }
                        case AFTER: {
                            return FOLLOWS;
                        }
                    }
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum IntervalDistance {
            EQUAL(0),
            CONTIGUOUS(1),
            NESTED(2),
            OVERLAPPING(3),
            DISJOINT(4);

            private int _distance;

            private IntervalDistance(int distance) {
                this._distance = distance >= 0 ? distance : -distance;
            }

            public int value() {
                return this._distance;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Relation {
            CHILD(-2),
            BEFORE(-1),
            EQUAL(0),
            AFTER(1),
            PARENT(2);

            private int _relation;

            private Relation(int direction) {
                this._relation = direction;
            }

            public int value() {
                return this._relation;
            }

            static Relation comparison(long time1, long time2) {
                return time1 == time2 ? EQUAL : (time1 < time2 ? AFTER : BEFORE);
            }
        }
    }
}

