/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.GooglePath;
import com.caucho.vfs.StreamImpl;
import com.google.appengine.api.files.FileReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

class GoogleReadStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(GoogleReadStream.class.getName());
    private static final L10N L = new L10N(GoogleReadStream.class);
    private final GooglePath _path;
    private FileReadChannel _is;
    private final ByteBuffer _buf = ByteBuffer.allocate(8192);

    GoogleReadStream(GooglePath path, FileReadChannel is) throws IOException {
        this._path = path;
        this._is = is;
        this._buf.clear();
        int sublen = this._is.read(this._buf);
        this._buf.flip();
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() throws IOException {
        return 1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (!this._buf.hasRemaining()) {
            this._buf.clear();
            int result = this._is.read(this._buf);
            this._buf.flip();
            if (result <= 0) {
                return result;
            }
        }
        int sublen = Math.min(length, this._buf.remaining());
        this._buf.get(buffer, offset, sublen);
        return sublen;
    }

    public void seekStart(long offset) throws IOException {
        this._is.position(offset);
        this._buf.clear();
        this._buf.flip();
    }

    public long getReadPosition() {
        try {
            return this._is.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasSkip() {
        return true;
    }

    public long skip(long n) throws IOException {
        long remaining = this._buf.remaining();
        if (n <= remaining) {
            this._buf.position(this._buf.position() + (int)n);
            return n;
        }
        this._buf.clear();
        this._buf.flip();
        long toSkip = n - remaining;
        long pos = this._is.position();
        this._is.position(pos + toSkip);
        return this._is.position() - pos + remaining;
    }

    public void close() throws IOException {
        FileReadChannel is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path.getNativePath() + "," + this._is + "]";
    }
}

