/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.AbstractParser;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.DtdRelaxGenerator;
import com.caucho.xml.ExtendedLocator;
import com.caucho.xml.HtmlPolicy;
import com.caucho.xml.NamespaceMap;
import com.caucho.xml.Policy;
import com.caucho.xml.QAttributes;
import com.caucho.xml.QComment;
import com.caucho.xml.QContentParticle;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QEntity;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.QNotation;
import com.caucho.xml.QProcessingInstruction;
import com.caucho.xml.RemoteURLException;
import com.caucho.xml.TeeContentHandler;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlParseException;
import com.caucho.xml.XmlPolicy;
import com.caucho.xml.readers.MacroReader;
import com.caucho.xml.readers.Utf16Reader;
import com.caucho.xml.readers.Utf8Reader;
import com.caucho.xml.readers.XmlReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String XML = "http://www.w3.org/XML/1998/namespace";
    static final QName DOC_NAME = new QName(null, "#document", null);
    static final QName TEXT_NAME = new QName(null, "#text", null);
    static final QName JSP_NAME = new QName(null, "#jsp", null);
    static final QName WHITESPACE_NAME = new QName(null, "#whitespace", null);
    static final QName JSP_ATTRIBUTE_NAME = new QName("xtp", "jsp-attribute", null);
    QAttributes _attributes;
    QAttributes _nullAttributes;
    boolean _inDtd;
    CharBuffer _text;
    CharBuffer _eltName;
    CharBuffer _cb;
    CharBuffer _buf = new CharBuffer();
    String _textFilename;
    int _textLine;
    char[] _textBuffer = new char[1024];
    int _textLength;
    int _textCapacity = this._textBuffer.length;
    boolean _isIgnorableWhitespace;
    boolean _isJspText;
    CharBuffer _name = new CharBuffer();
    CharBuffer _nameBuffer = new CharBuffer();
    MacroReader _macro = new MacroReader();
    int _macroIndex = 0;
    int _macroLength = 0;
    char[] _macroBuffer;
    QName[] _elementNames = new QName[64];
    NamespaceMap[] _namespaces = new NamespaceMap[64];
    int[] _elementLines = new int[64];
    int _elementTop;
    NamespaceMap _namespaceMap;
    ArrayList<String> _attrNames = new ArrayList();
    ArrayList<String> _attrValues = new ArrayList();
    ReadStream _is;
    XmlReader _reader;
    String _extPublicId;
    String _extSystemId;
    QName _activeNode;
    QName _topNamespaceNode;
    boolean _isTagStart;
    boolean _stopOnIncludeEnd;
    boolean _hasTopElement;
    boolean _hasDoctype;
    boolean _isHtml;
    Locator _locator = new LocatorImpl(this);

    public XmlParser() {
        this.clear();
    }

    XmlParser(Policy policy, QDocumentType dtd) {
        super(policy, dtd);
        this.clear();
    }

    void init() {
        super.init();
        this._attributes = new QAttributes();
        this._nullAttributes = new QAttributes();
        this._eltName = new CharBuffer();
        this._text = new CharBuffer();
        this._isHtml = this._policy instanceof HtmlPolicy;
        this._textLength = 0;
        this._isIgnorableWhitespace = true;
        this._elementTop = 0;
        this._elementLines[0] = 1;
        this._line = 1;
        this._dtd = null;
        this._inDtd = false;
        this._isTagStart = false;
        this._stopOnIncludeEnd = false;
        this._extPublicId = null;
        this._extSystemId = null;
        this._publicId = null;
        this._systemId = null;
        this._hasTopElement = false;
        this._hasDoctype = false;
        this._macroIndex = 0;
        this._macroLength = 0;
        this._reader = null;
        this._policy.init();
    }

    Document parseInt(ReadStream is) throws IOException, SAXException {
        this._is = is;
        if (this._filename == null && this._systemId != null) {
            this._filename = this._systemId;
        } else if (this._filename == null) {
            this._filename = this._is.getUserPath();
        }
        if (this._systemId == null) {
            this._systemId = this._is.getPath().getURL();
            if ("null:".equals(this._systemId) || "string:".equals(this._systemId)) {
                this._systemId = "stream";
            }
        }
        this._policy.setNamespaceAware(this._isNamespaceAware);
        if (this._filename == null) {
            this._filename = this._systemId;
        }
        if (this._filename == null) {
            this._filename = "stream";
        }
        if (this._dtd != null) {
            this._dtd.setSystemId(this._systemId);
        }
        if (this._builder != null) {
            if (!"string:".equals(this._systemId) && !"stream".equals(this._systemId)) {
                this._builder.setSystemId(this._systemId);
            }
            this._builder.setFilename(this._is.getPath().getURL());
        }
        if (this._contentHandler == null) {
            this._contentHandler = new DefaultHandler();
        }
        this._contentHandler.setDocumentLocator(this._locator);
        if (this._owner == null) {
            this._owner = new QDocument();
        }
        if (this._defaultEncoding != null) {
            this._owner.setAttribute("encoding", this._defaultEncoding);
        }
        this._activeNode = DOC_NAME;
        this._policy.setStream(is);
        this._policy.setNamespace(this._namespaceMap);
        this._contentHandler.startDocument();
        int ch = this.parseXMLDeclaration(null);
        ch = this.skipWhitespace(ch);
        this.parseNode(ch, false);
        if (this._strictXml && !this._hasTopElement) {
            throw this.error(L.l("XML file has no top-element.  All well-formed XML files have a single top-level element."));
        }
        if (this._contentHandler != null) {
            this._contentHandler.endDocument();
        }
        QDocument owner = this._owner;
        this._owner = null;
        Path path = is.getPath();
        is.close();
        owner.addDepend(path);
        return owner;
    }

    private void parseNode(int ch, boolean special) throws IOException, SAXException {
        this._text.clear();
        block8: while (true) {
            if (this._textLength == 0) {
                this._textFilename = this.getFilename();
                this._textLine = this.getLine();
            }
            switch (ch) {
                case -1: {
                    if (this._textLength != 0) {
                        this.appendText();
                    }
                    if (!this._stopOnIncludeEnd && this._reader.getNext() != null) {
                        this.popInclude();
                        if (this._reader != null) {
                            this.parseNode(this._reader.read(), special);
                        }
                        return;
                    }
                    this.closeTag("");
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!this._normalizeWhitespace) {
                        this.addText((char)ch);
                    } else if (this._textLength == 0) {
                        if (!this._isTagStart) {
                            this.addText(' ');
                        }
                    } else if (this._textBuffer[this._textLength - 1] != ' ') {
                        this.addText(' ');
                    }
                    ch = this._reader.read();
                    continue block8;
                }
                case 65535: {
                    return;
                }
                default: {
                    this.addText((char)ch);
                    ch = this._reader.read();
                    continue block8;
                }
                case 47: {
                    if (!special) {
                        this.addText((char)ch);
                        ch = this._reader.read();
                        continue block8;
                    }
                    ch = this._reader.read();
                    if (ch == 62 || ch == -1) {
                        this.appendText();
                        this.popNode();
                        return;
                    }
                    this.addText('/');
                    continue block8;
                }
                case 38: {
                    ch = this.parseEntityReference();
                    continue block8;
                }
                case 60: 
            }
            boolean endTag = false;
            ch = this._reader.read();
            if (ch == 47 && !special) {
                if (this._normalizeWhitespace && this._textLength > 0 && this._textBuffer[this._textLength - 1] == ' ') {
                    --this._textLength;
                }
                this.appendText();
                ch = this._reader.parseName(this._name, this._reader.read());
                if (ch != 62) {
                    while (XmlChar.isWhitespace(ch)) {
                        ch = this._reader.read();
                    }
                    if (ch != 62) {
                        throw this.error(L.l("`</{0}>' expected `>' at {1}.  Closing tags must close immediately after the tag name.", (Object)this._name, (Object)XmlParser.badChar(ch)));
                    }
                }
                this.closeTag(this._policy.getName(this._name).getName());
                ch = this._reader.read();
                continue;
            }
            if (XmlChar.isNameStart(ch)) {
                this.appendText();
                this.parseElement(ch);
                ch = this._reader.read();
                continue;
            }
            if (ch == 33) {
                ch = this._reader.read();
                if (ch == 91) {
                    this.parseCdata();
                    ch = this._reader.read();
                    continue;
                }
                if (ch == 45) {
                    this.parseComment();
                    ch = this._reader.read();
                    continue;
                }
                if (XmlChar.isNameStart(ch)) {
                    this.appendText();
                    ch = this._reader.parseName(this._name, ch);
                    String declName = this._name.toString();
                    if (declName.equals("DOCTYPE")) {
                        this.parseDoctype(ch);
                        if (this._contentHandler instanceof DOMBuilder) {
                            ((DOMBuilder)this._contentHandler).dtd(this._dtd);
                        }
                        ch = this._reader.read();
                    } else if (this._forgiving && declName.equalsIgnoreCase("doctype")) {
                        this.parseDoctype(ch);
                        if (this._contentHandler instanceof DOMBuilder) {
                            ((DOMBuilder)this._contentHandler).dtd(this._dtd);
                        }
                        ch = this._reader.read();
                    } else {
                        throw this.error(L.l("expected `<!DOCTYPE' declaration at {0}", (Object)declName));
                    }
                    if (!this.isDtdValidating()) continue;
                    this.generateDtdValidator(this._dtd);
                    continue;
                }
                if (this._forgiving) {
                    this.addText("<!");
                    continue;
                }
                throw this.error(L.l("expected `<!DOCTYPE' declaration at {0}", (Object)XmlParser.badChar(ch)));
            }
            if (ch == 63) {
                ch = this.parsePI();
                continue;
            }
            if (this._strictXml) {
                throw this.error(L.l("expected tag name after `<' at {0}.  Open tag names must immediately follow the open brace like `<foo ...>'", (Object)XmlParser.badChar(ch)));
            }
            if (this._isJsp && ch == 37) {
                ch = this._reader.read();
                this.appendText();
                this._isJspText = ch != 61;
                this.addText("<%");
                while (ch >= 0) {
                    if (ch == 37) {
                        ch = this._reader.read();
                        if (ch == 62) {
                            this.addText("%>");
                            ch = this._reader.read();
                            break;
                        }
                        this.addText('%');
                        continue;
                    }
                    this.addText((char)ch);
                    ch = this._reader.read();
                }
                this.appendText();
                this._isJspText = false;
                continue;
            }
            this.addText('<');
        }
    }

    private void parseDoctype(int ch) throws IOException, SAXException {
        if (this._activeNode != DOC_NAME) {
            throw this.error(L.l("<!DOCTYPE immediately follow the <?xml ...?> declaration."));
        }
        this._inDtd = true;
        ch = this.skipWhitespace(ch);
        ch = this._reader.parseName(this._nameBuffer, ch);
        String name = this._nameBuffer.toString();
        ch = this.skipWhitespace(ch);
        if (this._dtd == null) {
            this._dtd = new QDocumentType(name);
        }
        this._dtd.setName(name);
        if (XmlChar.isNameStart(ch)) {
            ch = this.parseExternalID(ch);
            ch = this.skipWhitespace(ch);
            this._dtd._publicId = this._extPublicId;
            this._dtd._systemId = this._extSystemId;
        }
        if (this._dtd._systemId != null && !this._dtd._systemId.equals("")) {
            Object is = null;
            this.unread(ch);
            XmlReader oldReader = this._reader;
            boolean hasInclude = false;
            try {
                this.pushInclude(this._extPublicId, this._extSystemId);
                hasInclude = true;
            }
            catch (RemoteURLException e) {
                log.finest(e.toString());
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINER, e.toString(), e);
                }
                log.finer(e.toString());
            }
            if (hasInclude) {
                this._stopOnIncludeEnd = true;
                try {
                    ch = this.parseDoctypeDecl(this._dtd);
                }
                catch (XmlParseException e) {
                    if (this._extSystemId != null && this._extSystemId.startsWith("http")) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                    throw e;
                }
                this._stopOnIncludeEnd = false;
                while (this._reader != null && this._reader != oldReader) {
                    this.popInclude();
                }
            }
            if (this._reader != null) {
                ch = this.skipWhitespace(this.read());
            }
        }
        if (ch == 91) {
            ch = this.parseDoctypeDecl(this._dtd);
        }
        ch = this.skipWhitespace(ch);
        this._inDtd = false;
        if (ch != 62) {
            throw this.error(L.l("expected `>' in <!DOCTYPE at {0}", (Object)XmlParser.badChar(ch)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDoctypeDecl(QDocumentType doctype) throws IOException, SAXException {
        this._hasDoctype = true;
        int ch = 0;
        ch = this.skipWhitespace(this.read());
        while (ch >= 0 && ch != 93) {
            if (ch == 60) {
                ch = this.read();
                if (ch == 33) {
                    String name;
                    ch = this.read();
                    if (XmlChar.isNameStart(ch)) {
                        ch = this._reader.parseName(this._text, ch);
                        name = this._text.toString();
                        if (name.equals("ELEMENT")) {
                            this.parseElementDecl(doctype);
                        } else if (name.equals("ATTLIST")) {
                            this.parseAttlistDecl(doctype);
                        } else if (name.equals("NOTATION")) {
                            this.parseNotationDecl(doctype);
                        } else {
                            if (!name.equals("ENTITY")) throw this.error("unknown declaration `" + name + "'");
                            this.parseEntityDecl(doctype);
                        }
                    } else if (ch == 45) {
                        this.parseComment();
                    } else if (ch == 91) {
                        ch = this._reader.parseName(this._text, this.read());
                        name = this._text.toString();
                        if (name.equals("IGNORE")) {
                            this.parseIgnore();
                        } else {
                            if (!name.equals("INCLUDE")) throw this.error("unknown declaration `" + name + "'");
                            this.parseIgnore();
                        }
                    }
                } else {
                    if (ch != 63) throw this.error(L.l("expected markup at {0}", (Object)XmlParser.badChar(ch)));
                    this.parsePI();
                }
            } else {
                if (ch != 37) throw this.error(L.l("expected '<' at {0}", (Object)XmlParser.badChar(ch)));
                ch = this._reader.parseName(this._buf, this.read());
                if (ch != 59) {
                    throw this.error(L.l("`%{0};' expects `;' at {1}.  Parameter entities have a `%name;' syntax.", (Object)this._buf, (Object)XmlParser.badChar(ch)));
                }
                this.addPEReference(this._text, this._buf.toString());
            }
            this._text.clear();
            ch = this.skipWhitespace(this.read());
        }
        this._text.clear();
        return this.read();
    }

    private void parseElement(int ch) throws IOException, SAXException {
        QElementDef elementDef;
        ch = this._reader.parseName(this._eltName, ch);
        NamespaceMap oldNamespace = this._namespaceMap;
        if (ch != 62 && ch != 47) {
            ch = this.parseAttributes(ch, true);
        } else {
            this._attributes.clear();
        }
        QName qname = this._policy.getName(this._eltName);
        if (this._isValidating && this._dtd != null && (elementDef = this._dtd.getElement(qname.getName())) != null) {
            elementDef.fillDefaults(this._attributes);
        }
        if (ch == 47) {
            ch = this._reader.read();
            if (ch == 62) {
                this.addElement(qname, true, this._attributes, oldNamespace);
            } else {
                this.addElement(qname, false, this._attributes, oldNamespace);
                this.parseNode(ch, true);
            }
        } else if (ch == 62) {
            this.addElement(qname, false, this._attributes, oldNamespace);
        } else {
            throw this.error(L.l("unexpected character {0} while parsing `{1}' attributes.  Expected an attribute name or `>' or `/>'.  XML element syntax is:\n  <name attr-1=\"value-1\" ... attr-n=\"value-n\">", (Object)XmlParser.badChar(ch), (Object)qname.getName()));
        }
    }

    private int parseAttributes(int ch, boolean isElement) throws IOException, SAXException {
        ch = this.skipWhitespace(ch);
        this._attributes.clear();
        this._attrNames.clear();
        this._attrValues.clear();
        boolean hasWhitespace = true;
        while (ch != -1) {
            if (!XmlChar.isNameStart(ch)) {
                if (!this._isJsp || ch != 60) break;
                ch = this.parseJspAttribute(isElement);
                continue;
            }
            if (!hasWhitespace) {
                throw this.error(L.l("attributes must be separated by whitespace"));
            }
            hasWhitespace = false;
            ch = this._reader.parseName(this._text, ch);
            if (this._text.startsWith("xmlns")) {
                String prefix;
                QName name = this._isNamespaceAware && this._contentHandler instanceof DOMBuilder ? this._policy.getNamespaceName(this._text) : new QName(this._text.toString(), null);
                if (this._text.length() > 5) {
                    prefix = this._text.substring(6);
                    if (prefix.equals("")) {
                        throw this.error(L.l("'{0}' is an illegal namespace declaration.", (Object)this._text));
                    }
                } else {
                    prefix = "";
                }
                this._text.clear();
                ch = this.skipWhitespace(ch);
                if (ch != 61) {
                    throw this.error(L.l("xmlns: needs value at {0}", (Object)XmlParser.badChar(ch)));
                }
                ch = this.skipWhitespace(this._reader.read());
                ch = this.parseValue(this._text, ch, true);
                hasWhitespace = this.isWhitespace(ch);
                ch = this.skipWhitespace(ch);
                String uri = this._text.toString();
                if (this._isXmlnsPrefix) {
                    this._namespaceMap = new NamespaceMap(this._namespaceMap, prefix, uri);
                    this._policy.setNamespace(this._namespaceMap);
                    this._contentHandler.startPrefixMapping(prefix, uri);
                }
                if (!isElement || !this._isXmlnsAttribute || !(this._contentHandler instanceof DOMBuilder)) continue;
                this._attributes.add(name, uri);
                continue;
            }
            String attrName = this._text.toString();
            this._attrNames.add(attrName);
            this._text.clear();
            ch = this.skipWhitespace(ch);
            String value = null;
            if (ch == 61) {
                ch = this.skipWhitespace(this._reader.read());
                ch = this.parseValue(this._text, ch, true);
                hasWhitespace = this.isWhitespace(ch);
                ch = this.skipWhitespace(ch);
                value = this._text.toString();
            } else {
                if (this._strictAttributes) {
                    throw this.error(L.l("attribute `{0}' expects value at {1}.  XML requires attributes to have explicit values.", (Object)attrName, (Object)XmlParser.badChar(ch)));
                }
                value = attrName;
                hasWhitespace = true;
            }
            this._attrValues.add(value);
        }
        int len = this._attrNames.size();
        for (int i = 0; i < len; ++i) {
            String attrName = this._attrNames.get(i);
            String value = this._attrValues.get(i);
            this._text.clear();
            this._text.append(attrName);
            QName name = this._contentHandler instanceof DOMBuilder ? this._policy.getAttributeName(this._eltName, this._text, true) : this._policy.getAttributeName(this._eltName, this._text);
            this._attributes.add(name, value);
        }
        return ch;
    }

    private int parseJspAttribute(boolean isElement) throws IOException, XmlParseException {
        int ch = this._reader.read();
        if (ch != 37) {
            throw this.error(L.l("unexpected char `{0}' in element", (Object)"%"));
        }
        ch = this._reader.read();
        if (ch != 61) {
            throw this.error(L.l("unexpected char `{0}' in element", (Object)"="));
        }
        this._text.clear();
        ch = this._reader.read();
        while (ch >= 0) {
            if (ch == 37) {
                ch = this._reader.read();
                if (ch == 62) {
                    ch = this._reader.read();
                    break;
                }
                this._text.append((char)ch);
                continue;
            }
            this._text.append((char)ch);
            ch = this._reader.read();
        }
        String value = this._text.toString();
        if (isElement) {
            this._attributes.add(JSP_ATTRIBUTE_NAME, value);
        }
        return ch;
    }

    private void closeTag(String endTagName) throws IOException, SAXException {
        block5: while (this._activeNode != null && this._activeNode != DOC_NAME) {
            switch (this._policy.elementCloseAction(this, this._activeNode, endTagName)) {
                case 6: {
                    this.popNode();
                    return;
                }
                case 7: {
                    this.popNode();
                    continue block5;
                }
                case 1: {
                    return;
                }
            }
            throw new RuntimeException();
        }
        if (!this._extraForgiving && endTagName != null && !endTagName.equals("")) {
            throw this.error(L.l("Unexpected end tag `</{0}>' at top-level.  All open tags have already been closed.", (Object)endTagName));
        }
    }

    private void handleResinInclude() throws IOException, SAXException {
        String filename = this._attributes.getValue("path");
        if (filename == null || filename.equals("")) {
            filename = this._attributes.getValue("href");
        }
        if (filename.equals("")) {
            throw this.error(L.l("<resin:include> expects a `path' attribute."));
        }
        this.pushInclude(filename);
    }

    private void handleResinIncludeDirectory() throws IOException, SAXException {
        String filename = this._attributes.getValue("path");
        if (filename == null || filename.equals("")) {
            filename = this._attributes.getValue("href");
        }
        String extension = this._attributes.getValue("extension");
        if (filename.equals("")) {
            throw this.error(L.l("<resin:include> expects a `path' attribute."));
        }
        Path pwd = this._searchPath != null ? this._searchPath : Vfs.lookup(this._systemId).getParent();
        Path dir = pwd.lookup(filename);
        if (!dir.isDirectory()) {
            throw this.error(L.l("`{0}' is not a directory for resin:include-directory.  The href for resin:include-directory must refer to a directory.", (Object)dir.getNativePath()));
        }
        Object[] list = dir.list();
        Arrays.sort(list);
        for (int i = list.length - 1; i >= 0; --i) {
            if (((String)list[i]).startsWith(".") || extension != null && !((String)list[i]).endsWith(extension)) continue;
            this.pushInclude(dir.lookup((String)list[i]).getPath());
        }
    }

    private int parseNameToken(CharBuffer name, int ch) throws IOException, SAXException {
        name.clear();
        if (!XmlChar.isNameChar(ch)) {
            throw this.error(L.l("expected name at {0}", (Object)XmlParser.badChar(ch)));
        }
        while (XmlChar.isNameChar(ch)) {
            name.append((char)ch);
            ch = this._reader.read();
        }
        return ch;
    }

    private void popNode() throws SAXException {
        QName node = this._activeNode;
        if (this._activeNode != DOC_NAME) {
            String uri = this._activeNode.getNamespaceURI();
            String localName = this._activeNode.getLocalName();
            if (uri == null) {
                uri = "";
                localName = this._isNamespaceAware ? this._activeNode.getName() : "";
            }
            this._contentHandler.endElement(uri, localName, this._activeNode.getName());
        }
        if (this._elementTop > 0) {
            --this._elementTop;
            NamespaceMap oldMap = this._namespaces[this._elementTop];
            this.popNamespaces(oldMap);
            this._activeNode = this._elementNames[this._elementTop];
        }
        if (this._elementTop == 0) {
            this._activeNode = DOC_NAME;
        }
    }

    public void pushNamespace(String prefix, String uri) {
        this._namespaceMap = new NamespaceMap(this._namespaceMap, prefix, uri);
        this._policy.setNamespace(this._namespaceMap);
    }

    private void popNamespaces(NamespaceMap oldMap) throws SAXException {
        while (this._namespaceMap != null && this._namespaceMap != oldMap) {
            this._contentHandler.endPrefixMapping(this._namespaceMap.prefix);
            this._namespaceMap = this._namespaceMap.next;
        }
        this._namespaceMap = oldMap;
        this._policy.setNamespace(this._namespaceMap);
    }

    private void appendText(String s) {
        if (this._text.length() == 0) {
            this._textFilename = this.getFilename();
            this._textLine = this.getLine();
        }
        this._text.append(s);
    }

    private int parseEntityReference() throws IOException, SAXException {
        int ch = this._reader.read();
        if (ch == 35) {
            this.addText((char)this.parseCharacterReference());
            return this._reader.read();
        }
        if (XmlChar.isNameStart(ch)) {
            if ((ch = this._reader.parseName(this._buf, ch)) != 59 && this._strictXml) {
                throw this.error(L.l("`&{0};' expected `;' at {0}.  Entity references have a `&name;' syntax.", (Object)this._buf, (Object)XmlParser.badChar(ch)));
            }
            if (ch != 59) {
                this.addText('&');
                this.addText(this._buf.toString());
                return ch;
            }
            this.addEntityReference(this._buf.toString());
            ch = this._reader.read();
            return ch;
        }
        if (this._strictXml) {
            throw this.error(L.l("expected name at {0}", (Object)XmlParser.badChar(ch)));
        }
        this.addText('&');
        return ch;
    }

    private int parseCharacterReference() throws IOException, SAXException {
        int ch = this._reader.read();
        int radix = 10;
        if (ch == 120) {
            radix = 16;
            ch = this._reader.read();
        }
        int value = 0;
        while (ch != 59) {
            if (ch >= 48 && ch <= 57) {
                value = radix * value + ch - 48;
            } else if (radix == 16 && ch >= 97 && ch <= 102) {
                value = radix * value + ch - 97 + 10;
            } else if (radix == 16 && ch >= 65 && ch <= 70) {
                value = radix * value + ch - 65 + 10;
            } else {
                throw this.error(L.l("malformed entity ref at {0}", (Object)XmlParser.badChar(ch)));
            }
            ch = this._reader.read();
        }
        if (value > 65535) {
            throw this.error(L.l("malformed entity ref at {0}", (Object)("" + value)));
        }
        if (this._strictCharacters && !this.isChar(value)) {
            throw this.error(L.l("illegal character ref at {0}", (Object)XmlParser.badChar(value)));
        }
        return value;
    }

    private void addEntityReference(String name) throws IOException, SAXException {
        QEntity entity;
        boolean expand;
        boolean bl = expand = !this._entitiesAsText || this._hasDoctype || !this._switchToXml;
        if (!expand) {
            this.addText("&" + name + ";");
            return;
        }
        int ch = this._entities.getEntity(name);
        if (ch >= 0 && ch <= 65535) {
            this.addText((char)ch);
            return;
        }
        QEntity qEntity = entity = this._dtd == null ? null : this._dtd.getEntity(name);
        if (!this._expandEntities) {
            this.addText("&" + name + ";");
            return;
        }
        if (!(entity != null || this._dtd != null && this._dtd.getName() != null && this._dtd.isExternal())) {
            if (this._strictXml) {
                throw this.error(L.l("`&{0};' is an unknown entity.  XML predefines only `&lt;', `&amp;', `&gt;', `&apos;' and  `&quot;'. All other entities must be defined in an &lt;!ENTITY> definition in the DTD.", (Object)name));
            }
            if (expand && this._contentHandler instanceof DOMBuilder) {
                this.appendText();
                ((DOMBuilder)this._contentHandler).entityReference(name);
            } else {
                this.addText("&" + name + ";");
            }
        } else if (entity != null) {
            if (expand && entity._isSpecial && entity._value != null) {
                this.addText(entity._value);
            } else if (entity.getSystemId() != null) {
                if (!this.pushSystemEntity(entity)) {
                    if (this._contentHandler instanceof DOMBuilder) {
                        this.appendText();
                        ((DOMBuilder)this._contentHandler).entityReference(name);
                    } else {
                        this.addText("&" + name + ";");
                    }
                }
            } else if (expand && entity._value != null) {
                this.setMacro(entity._value);
            } else {
                this.addText("&" + name + ";");
            }
        } else if (expand && this._contentHandler instanceof DOMBuilder) {
            this.appendText();
            ((DOMBuilder)this._contentHandler).entityReference(name);
        } else {
            this.addText("&" + name + ";");
        }
    }

    private boolean pushSystemEntity(QEntity entity) throws IOException, SAXException {
        String publicId = entity.getPublicId();
        String systemId = entity.getSystemId();
        Object value = null;
        InputSource source = null;
        ReadStream is = null;
        if (this._entityResolver != null) {
            source = this._entityResolver.resolveEntity(publicId, systemId);
        }
        if (source != null && source.getByteStream() != null) {
            is = Vfs.openRead(source.getByteStream());
        } else if (source != null && source.getCharacterStream() != null) {
            is = Vfs.openRead(source.getCharacterStream());
        } else if (source != null && source.getSystemId() != null && this._searchPath.lookup(source.getSystemId()).isFile()) {
            this._owner.addDepend(this._searchPath.lookup(source.getSystemId()));
            is = this._searchPath.lookup(source.getSystemId()).openRead();
        } else if (systemId != null && !systemId.equals("")) {
            String path = systemId;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (this._searchPath != null && this._searchPath.lookup(path).isFile()) {
                this._owner.addDepend(this._searchPath.lookup(path));
                is = this._searchPath.lookup(path).openRead();
            }
        }
        if (is == null) {
            return false;
        }
        this._filename = systemId;
        this._systemId = systemId;
        Path oldSearchPath = this._searchPath;
        Path path = is.getPath();
        if (path != null) {
            this._owner.addDepend(path);
            if (this._searchPath != null) {
                this._searchPath = path.getParent();
                this._reader.setSearchPath(oldSearchPath);
            }
        }
        this._is = is;
        this._line = 1;
        XmlReader oldReader = this._reader;
        this._reader = null;
        int ch = this.parseXMLDeclaration(oldReader);
        this.unread(ch);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseValue(CharBuffer value, int ch, boolean isGeneral) throws IOException, SAXException {
        int end = ch;
        value.clear();
        if (end == 39 || end == 34) {
            ch = this._reader.read();
        } else {
            if (this._strictAttributes) {
                value.append((char)end);
                ch = this._reader.read();
                while (ch >= 0) {
                    if (!XmlChar.isNameChar(ch)) throw this.error(L.l("XML attribute value must be quoted at `{0}'.  XML attribute syntax is either attr=\"value\" or attr='value'.", (Object)value));
                    value.append((char)ch);
                    ch = this._reader.read();
                }
                throw this.error(L.l("XML attribute value must be quoted at `{0}'.  XML attribute syntax is either attr=\"value\" or attr='value'.", (Object)value));
            }
            end = 0;
        }
        while (true) {
            block25: {
                block32: {
                    block26: {
                        block33: {
                            block31: {
                                block30: {
                                    block27: {
                                        QEntity entity;
                                        block29: {
                                            block28: {
                                                if (ch == -1 || (end == 0 || ch == end) && (end != 0 || !this.isAttributeChar(ch))) break block26;
                                                if (end == 0 && ch == 47) {
                                                    ch = this._reader.read();
                                                    if (!this.isWhitespace(ch) && ch != 62) {
                                                        value.append('/');
                                                        value.append((char)ch);
                                                        break block25;
                                                    } else {
                                                        this.unread(ch);
                                                        return 47;
                                                    }
                                                }
                                                if (ch != 38 || this._entitiesAsText) break block27;
                                                ch = this._reader.read();
                                                if (ch != 35) break block28;
                                                value.append((char)this.parseCharacterReference());
                                                break block25;
                                            }
                                            if (isGeneral) break block29;
                                            value.append('&');
                                            value.append((char)ch);
                                            break block25;
                                        }
                                        if (!XmlChar.isNameStart(ch)) break block25;
                                        ch = this._reader.parseName(this._buf, ch);
                                        String name = this._buf.toString();
                                        if (ch != 59 && this._strictXml) {
                                            throw this.error(L.l("expected `{0}' at {1}", (Object)";", (Object)XmlParser.badChar(ch)));
                                        }
                                        if (ch != 59) {
                                            value.append('&');
                                            value.append(name);
                                            continue;
                                        }
                                        int lookup = this._entities.getEntity(name);
                                        if (lookup >= 0 && lookup <= 65535) {
                                            ch = this._reader.read();
                                            value.append((char)lookup);
                                            continue;
                                        }
                                        QEntity qEntity = entity = this._dtd == null ? null : this._dtd.getEntity(name);
                                        if (entity != null && entity._value != null) {
                                            this.setMacroAttr(entity._value);
                                            break block25;
                                        } else {
                                            if (this._strictXml) {
                                                throw this.error(L.l("expected local reference at `&{0};'", (Object)name));
                                            }
                                            value.append('&');
                                            value.append(name);
                                            value.append(';');
                                        }
                                        break block25;
                                    }
                                    if (ch != 37 || isGeneral) break block30;
                                    ch = this._reader.read();
                                    if (!XmlChar.isNameStart(ch)) {
                                        value.append('%');
                                        continue;
                                    }
                                    if ((ch = this._reader.parseName(this._buf, ch)) != 59) {
                                        throw this.error(L.l("expected `{0}' at {1}", (Object)";", (Object)XmlParser.badChar(ch)));
                                    }
                                    this.addPEReference(value, this._buf.toString());
                                    break block25;
                                }
                                if (ch != 60 || !this._isJsp) break block31;
                                value.append('<');
                                ch = this._reader.read();
                                if (ch != 37) continue;
                                value.append('%');
                                ch = this._reader.read();
                                break block32;
                            }
                            if (!isGeneral) break block33;
                            if (ch == 13 && (ch = this._reader.read()) != 10) {
                                value.append('\n');
                                continue;
                            }
                            value.append((char)ch);
                            break block25;
                        }
                        if (ch == 13) {
                            value.append(' ');
                            ch = this._reader.read();
                            if (ch != 10) {
                                continue;
                            }
                            break block25;
                        } else if (ch == 10) {
                            value.append(' ');
                            break block25;
                        } else {
                            value.append((char)ch);
                        }
                        break block25;
                    }
                    if (end == 0) return ch;
                    return this._reader.read();
                }
                while (ch >= 0) {
                    if (ch == 37) {
                        ch = this._reader.read();
                        if (ch == 62) {
                            value.append("%>");
                            break;
                        }
                        value.append('%');
                        continue;
                    }
                    value.append((char)ch);
                    ch = this._reader.read();
                }
            }
            ch = this._reader.read();
        }
    }

    private boolean isAttributeChar(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return false;
            }
            case 34: 
            case 39: 
            case 60: 
            case 61: 
            case 62: {
                return false;
            }
        }
        return true;
    }

    private void parsePcdata(QNode node) throws IOException, SAXException {
        String tail = "</" + node.getNodeName() + ">";
        this._text.clear();
        int ch = this._reader.read();
        if (ch == 10) {
            ch = this._reader.read();
        }
        while (ch != -1) {
            this.addText((char)ch);
            if (this._text.endsWith(tail)) {
                this._text.setLength(this._text.length() - tail.length());
                if (this._text.length() > 1 && this._text.charAt(this._text.length() - 1) == '\n') {
                    this._text.setLength(this._text.length() - 1);
                }
                this.appendText();
                return;
            }
            ch = this._reader.read();
        }
        throw this.error("bad pcdata");
    }

    private int parseXMLDeclaration(XmlReader oldReader) throws IOException, SAXException {
        int startOffset = this._is.getOffset();
        boolean isEBCDIC = false;
        int ch = this._is.read();
        XmlReader reader = null;
        if (ch == 254) {
            ch = this._is.read();
            if (ch == 255) {
                this._owner.setAttribute("encoding", "UTF-16");
                this._is.setEncoding("utf-16");
                reader = new Utf16Reader(this, this._is);
                ch = reader.read();
            }
        } else if (ch == 255) {
            ch = this._is.read();
            if (ch == 254) {
                this._owner.setAttribute("encoding", "UTF-16");
                this._is.setEncoding("utf-16");
                reader = new Utf16Reader(this, this._is);
                ((Utf16Reader)reader).setReverse(true);
                ch = reader.read();
            }
        } else if (ch == 0) {
            ch = this._is.read();
            this._owner.setAttribute("encoding", "UTF-16");
            this._is.setEncoding("utf-16");
            reader = new Utf16Reader(this, this._is);
        } else if (ch == 239) {
            ch = this._is.read();
            if (ch == 187 && (ch = this._is.read()) == 191) {
                ch = this._is.read();
                this._owner.setAttribute("encoding", "UTF-8");
                this._is.setEncoding("utf-8");
                reader = new Utf8Reader(this, this._is);
            }
        } else if (ch == 76) {
            this._is.unread();
            this._is.setEncoding("cp500");
            isEBCDIC = true;
            reader = new XmlReader(this, this._is);
            ch = reader.read();
        } else {
            int ch2 = this._is.read();
            if (ch2 == 0) {
                this._owner.setAttribute("encoding", "UTF-16LE");
                this._is.setEncoding("utf-16le");
                reader = new Utf16Reader(this, this._is);
                ((Utf16Reader)reader).setReverse(true);
            } else if (ch2 > 0) {
                this._is.unread();
            }
        }
        if (reader == null || reader == oldReader) {
            reader = this._policy instanceof HtmlPolicy || this._is.getSource() instanceof ReaderWriterStream ? new XmlReader(this, this._is) : new Utf8Reader(this, this._is);
        }
        if (ch == 10) {
            reader.setLine(2);
        }
        reader.setSystemId(this._systemId);
        if (this._systemId == null) {
            reader.setSystemId(this._filename);
        }
        reader.setFilename(this._filename);
        reader.setPublicId(this._publicId);
        reader.setNext(oldReader);
        this._reader = reader;
        if (ch != 60) {
            return ch;
        }
        if (this.parseXMLDecl(this._reader) && isEBCDIC) {
            this._is.setOffset(startOffset);
            ch = this._reader.read();
            if (ch != 60) {
                throw new IllegalStateException();
            }
            this.parseXMLDecl(this._reader);
        }
        return this._reader.read();
    }

    private boolean parseXMLDecl(XmlReader reader) throws IOException, SAXException {
        int ch = reader.read();
        if (ch != 63) {
            this.unread((char)ch);
            this.unread(60);
            return false;
        }
        ch = this._reader.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name after '<?' at {0}.  Processing instructions expect a name like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.parseName(this._text, ch);
        String piName = this._text.toString();
        if (!piName.equals("xml")) {
            ch = this.parsePITail(piName, ch);
            this.unread(ch);
            return false;
        }
        if (this._switchToXml && this._activeNode == DOC_NAME && !this._inDtd) {
            this._policy = new XmlPolicy();
        }
        if ((ch = this.parseAttributes(ch, false)) != 63) {
            throw this.error(L.l("expected `?' at {0}.  Processing instructions end with `?>' like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.read();
        if (ch != 62) {
            throw this.error(L.l("expected `>' at {0}.  Processing instructions end with `?>' like <?foo ... ?>", (Object)">", (Object)XmlParser.badChar(ch)));
        }
        for (int i = 0; i < this._attributes.getLength(); ++i) {
            QName name = this._attributes.getName(i);
            String value = this._attributes.getValue(i);
            if (this._owner != null) {
                this._owner.setAttribute(name.getName(), value);
            }
            if (!name.getName().equals("encoding")) continue;
            String encoding = value;
            if (this._isStaticEncoding || encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF-16") || this._is.getSource() instanceof ReaderWriterStream) continue;
            this._is.setEncoding(encoding);
            XmlReader oldReader = this._reader;
            this._reader = new XmlReader(this, this._is);
            this._reader.setLine(oldReader.getLine());
            this._reader.setSystemId(this._filename);
            this._reader.setPublicId(null);
        }
        return true;
    }

    private int parsePI() throws IOException, SAXException {
        this.appendText();
        int ch = this._reader.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name after '<?' at {0}.  Processing instructions expect a name like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.parseName(this._text, ch);
        String piName = this._text.toString();
        if (!piName.equals("xml")) {
            return this.parsePITail(piName, ch);
        }
        if (this._switchToXml && this._activeNode == DOC_NAME && !this._inDtd) {
            this._policy = new XmlPolicy();
            return this.parsePITail(piName, ch);
        }
        throw this.error(L.l("<?xml ... ?> occurs after content.  The <?xml ... ?> prolog must be at the document start."));
    }

    private int parsePITail(String piName, int ch) throws IOException, SAXException {
        ch = this.skipWhitespace(ch);
        this._text.clear();
        while (ch != -1) {
            if (ch == 63) {
                ch = this._reader.read();
                if (ch == 62) break;
                this._text.append('?');
                continue;
            }
            this._text.append((char)ch);
            ch = this._reader.read();
        }
        if (this._inDtd) {
            QProcessingInstruction pi = new QProcessingInstruction(piName, this._text.toString());
            pi._owner = this._dtd._owner;
            this._dtd.appendChild(pi);
        } else {
            this._contentHandler.processingInstruction(piName, this._text.toString());
        }
        return this._reader.read();
    }

    private void parseComment() throws IOException, SAXException {
        int ch;
        if (!this._skipComments) {
            this.appendText();
        }
        if ((ch = this._reader.read()) != 45) {
            throw this.error(L.l("expected comment at {0}", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.read();
        if (!this._skipComments) {
            this._buf.clear();
        }
        block0: while (ch != -1) {
            if (ch == 45) {
                ch = this._reader.read();
                while (ch == 45) {
                    ch = this._reader.read();
                    if (ch == 62) break block0;
                    if (this._strictComments) {
                        throw this.error(L.l("XML forbids `--' in comments"));
                    }
                    if (ch == 45) {
                        if (this._skipComments) continue;
                        this._buf.append('-');
                        continue;
                    }
                    if (this._skipComments) break;
                    this._buf.append("--");
                    break;
                }
                this._buf.append('-');
                continue;
            }
            if (!XmlChar.isChar(ch)) {
                throw this.error(L.l("bad character {0}", (Object)XmlParser.hex(ch)));
            }
            this._buf.append((char)ch);
            ch = this._reader.read();
        }
        if (this._inDtd) {
            QComment comment = new QComment(this._buf.toString());
            comment._owner = this._dtd._owner;
            this._dtd.appendChild(comment);
        } else if (!this._skipComments) {
            if (this._contentHandler instanceof XMLWriter && !this._skipComments) {
                ((XMLWriter)((Object)this._contentHandler)).comment(this._buf.toString());
                this._isIgnorableWhitespace = true;
            } else if (this._lexicalHandler != null) {
                this._lexicalHandler.comment(this._buf.getBuffer(), 0, this._buf.getLength());
                this._isIgnorableWhitespace = true;
            }
        }
    }

    private void parseCdata() throws IOException, SAXException {
        int ch;
        if (this._forgiving) {
            ch = this._reader.read();
            if (ch != 67) {
                this.appendText("<![" + (char)ch);
                return;
            }
            ch = this._reader.read();
            if (ch != 68) {
                this.appendText("<![C" + (char)ch);
                return;
            }
            ch = this._reader.read();
            if (ch != 65) {
                this.appendText("<![CD" + (char)ch);
                return;
            }
            ch = this._reader.read();
            if (ch != 84) {
                this.appendText("<![CDA" + (char)ch);
                return;
            }
            ch = this._reader.read();
            if (ch != 65) {
                this.appendText("<![CDAT" + (char)ch);
                return;
            }
            ch = this._reader.read();
            if (ch != 91) {
                this.appendText("<![CDATA" + (char)ch);
                return;
            }
        } else {
            ch = this._reader.read();
            if (ch != 67 || (ch = this._reader.read()) != 68 || (ch = this._reader.read()) != 65 || (ch = this._reader.read()) != 84 || (ch = this._reader.read()) != 65 || (ch = this._reader.read()) != 91) {
                throw this.error(L.l("expected `<![CDATA[' at {0}", (Object)XmlParser.badChar(ch)));
            }
        }
        ch = this._reader.read();
        if (this._lexicalHandler != null) {
            this._lexicalHandler.startCDATA();
            this.appendText();
        } else if (!this._isCoalescing) {
            this.appendText();
        }
        block0: while (ch != -1) {
            if (ch == 93) {
                ch = this._reader.read();
                while (ch == 93) {
                    ch = this._reader.read();
                    if (ch == 62) break block0;
                    if (ch == 93) {
                        this.addText(']');
                        continue;
                    }
                    this.addText(']');
                    break;
                }
                this.addText(']');
                continue;
            }
            if (this._strictCharacters && !this.isChar(ch)) {
                throw this.error(L.l("expected character in cdata at {0}", (Object)XmlParser.badChar(ch)));
            }
            this.addText((char)ch);
            ch = this._reader.read();
        }
        if (this._lexicalHandler != null) {
            this.appendText();
            this._lexicalHandler.endCDATA();
        } else if (!this._isCoalescing) {
            this.appendText();
        }
    }

    private void parseIgnore() throws IOException, SAXException {
        int ch = this.read();
        while (ch >= 0) {
            if (ch != 93) {
                ch = this.read();
                continue;
            }
            ch = this.read();
            if (ch != 93 || (ch = this.read()) != 62) continue;
            return;
        }
    }

    private int parseContentSpec(QElementDef def, int ch) throws IOException, SAXException {
        if (XmlChar.isNameStart(ch = this.expandPE(ch))) {
            ch = this._reader.parseName(this._text, ch);
            String name = this._text.toString();
            if (name.equals("EMPTY")) {
                def._content = "EMPTY";
                return ch;
            }
            if (name.equals("ANY")) {
                def._content = "ANY";
                return ch;
            }
            throw this.error(L.l("expected EMPTY or ANY at `{0}'", (Object)name));
        }
        if (ch != 40) {
            throw this.error(L.l("expected grammar definition starting with '(' at {0}.  <!ELEMENT> definitions have the syntax <!ELEMENT name - - (grammar)>", (Object)XmlParser.badChar(ch)));
        }
        QContentParticle cp = new QContentParticle();
        def._content = cp;
        return this.parseContentParticle(cp, true);
    }

    private int parseContentParticle(QContentParticle cp, boolean isTop) throws IOException, SAXException {
        boolean hasCdata = false;
        cp._separator = 0;
        cp._repeat = 0;
        int ch = this.expandPE(this._reader.read());
        while (ch != -1) {
            Object child;
            if (ch == 40) {
                child = new QContentParticle();
                cp.addChild(child);
                ch = this.parseContentParticle((QContentParticle)child, false);
            } else if (XmlChar.isNameStart(ch)) {
                ch = this._reader.parseName(this._text, ch);
                cp.addChild(this._text.toString());
            } else if (ch == 35) {
                ch = this._reader.parseName(this._text, this._reader.read());
                String name = this._text.toString();
                if (this._strictXml && cp._children.size() != 0) {
                    throw this.error(L.l("`#{0}' must occur first", (Object)name));
                }
                if (this._strictXml && !isTop) {
                    throw this.error(L.l("`#{0}' may only occur at top level", (Object)name));
                }
                if (!name.equals("PCDATA")) {
                    throw this.error(L.l("illegal content particle at `#{0}'", (Object)name));
                }
                cp.addChild("#PCDATA");
                hasCdata = true;
            } else {
                throw this.error(L.l("expected content particle at {0}", (Object)XmlParser.badChar(ch)));
            }
            ch = this.expandPE(ch);
            if (ch == 63 || ch == 42 || ch == 43) {
                QContentParticle cpChild;
                child = cp.getChild(cp.getChildSize() - 1);
                if (child instanceof QContentParticle) {
                    cpChild = (QContentParticle)child;
                    cpChild._repeat = ch;
                } else {
                    cpChild = new QContentParticle();
                    cpChild.addChild(child);
                    cpChild._repeat = ch;
                    cp.setChild(cp.getChildSize() - 1, cpChild);
                }
                ch = this.expandPE(this._reader.read());
            }
            if (ch == 41) break;
            if (cp._separator == 0) {
                if (ch == 124) {
                    cp._separator = ch;
                } else {
                    if (hasCdata && this._strictXml) {
                        throw this.error(L.l("#PCDATA must be separated by `|' at {0}", (Object)XmlParser.badChar(ch)));
                    }
                    if (ch == 44) {
                        cp._separator = ch;
                    } else if (!this._strictXml && ch == 38) {
                        cp._separator = ch;
                    } else {
                        throw this.error(L.l("expected separator at {0}", (Object)XmlParser.badChar(ch)));
                    }
                }
                ch = this._reader.read();
            } else {
                if (ch != cp._separator) {
                    throw this.error(L.l("expected `{0}' at {1}", (Object)("" + (char)cp._separator), (Object)XmlParser.badChar(ch)));
                }
                ch = this._reader.read();
            }
            ch = this.expandPE(ch);
        }
        ch = this.expandPE(this._reader.read());
        if (this._strictXml && hasCdata && (ch == 43 || ch == 63)) {
            throw this.error(L.l("pcdata clause can not have {0}", (Object)XmlParser.badChar(ch)));
        }
        if (ch == 42 || ch == 43 || ch == 63) {
            cp._repeat = ch;
            return this._reader.read();
        }
        return ch;
    }

    private int expandPE(int ch) throws IOException, SAXException {
        ch = this.skipWhitespace(ch);
        while (ch == 37) {
            this.parsePEReference();
            ch = this.skipWhitespace(this._reader.read());
        }
        return ch;
    }

    private void parsePEReference() throws IOException, SAXException {
        int ch = this._reader.parseName(this._buf, this._reader.read());
        if (ch != 59) {
            throw this.error(L.l("`%{0};' expects `;' at {1}.  Parameter entities have a `%name;' syntax.", (Object)this._buf, (Object)XmlParser.badChar(ch)));
        }
        this.addPEReference(this._text, this._buf.toString());
    }

    private void addPEReference(CharBuffer value, String name) throws IOException, SAXException {
        QEntity entity = this._dtd.getParameterEntity(name);
        if (entity == null && !this._dtd.isExternal()) {
            throw this.error(L.l("`%{0};' is an unknown parameter entity.  Parameter entities must be defined in an <!ENTITY> declaration before use.", (Object)name));
        }
        if (entity != null && entity._value != null) {
            this.setMacro(entity._value);
        } else if (entity != null && entity.getSystemId() != null) {
            this.pushInclude(entity.getPublicId(), entity.getSystemId());
        } else {
            value.append("%");
            value.append(name);
            value.append(";");
        }
    }

    private void parseElementDecl(QDocumentType doctype) throws IOException, SAXException {
        int ch = this.skipWhitespace(this._reader.read());
        ch = this._reader.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this.skipWhitespace(ch);
        QElementDef def = this._dtd.addElement(name);
        def.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        boolean needsStartTag = true;
        boolean needsEndTag = true;
        if (this._optionalTags && (ch == 79 || ch == 45)) {
            needsStartTag = ch == 45;
            if ((ch = this.skipWhitespace(ch)) == 48) {
                needsEndTag = false;
            } else if (ch == 45) {
                needsEndTag = true;
            } else {
                throw this.error(L.l("unknown short tag"));
            }
        }
        ch = this.parseContentSpec(def, ch);
        if ((ch = this.skipWhitespace(ch)) != 62) {
            throw this.error(L.l("`<!ELEMENT' must close with `>' at {0}", (Object)XmlParser.badChar(ch)));
        }
    }

    private static String toAttrDefault(CharBuffer text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                text.delete(i, i + 1);
                text.insert(i, "&#34;");
                --i;
                continue;
            }
            if (ch != '\'') continue;
            text.delete(i, i + 1);
            text.insert(i, "&#39;");
            --i;
        }
        return text.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttlistDecl(QDocumentType doctype) throws IOException, SAXException {
        int ch = this.skipWhitespace(this._reader.read());
        ch = this._reader.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this.skipWhitespace(ch);
        QElementDef def = this._dtd.addElement(name);
        while (XmlChar.isNameStart(ch = this.expandPE(ch))) {
            ch = this._reader.parseName(this._text, ch);
            String attrName = this._text.toString();
            String attrType = null;
            ArrayList<String> enumeration = null;
            if ((ch = this.expandPE(ch)) == 40) {
                attrType = "#ENUM";
                enumeration = new ArrayList<String>();
                do {
                    ch = this.expandPE(this._reader.read());
                    ch = this.parseNameToken(this._text, ch);
                    enumeration.add(this._text.toString());
                } while ((ch = this.expandPE(ch)) == 124);
                if (ch != 41) {
                    throw this.error(L.l("expected `{0}' at {1}.  <!ATTRLIST> enumerations definitions are enclosed in '(' ... ')'.", (Object)")", (Object)XmlParser.badChar(ch)));
                }
                ch = this._reader.read();
            } else {
                ch = this._reader.parseName(this._text, ch);
                attrType = this._text.toString();
                if (attrType.equals("NOTATION")) {
                    enumeration = new ArrayList();
                    if ((ch = this.expandPE(ch)) != 40) {
                        throw this.error(L.l("expected `{0}' at {1}", (Object)"(", (Object)XmlParser.badChar(ch)));
                    }
                    do {
                        ch = this.expandPE(this._reader.read());
                        ch = this._reader.parseName(this._text, ch);
                        enumeration.add(this._text.toString());
                    } while ((ch = this.expandPE(ch)) == 124);
                    if (ch != 41) {
                        throw this.error(L.l("expected `{0}' at {1}", (Object)")", (Object)XmlParser.badChar(ch)));
                    }
                    ch = this._reader.read();
                } else if (_attrTypes.get(attrType) == null) {
                    throw this.error(L.l("expected attribute type at `{0}'", (Object)attrType));
                }
            }
            ch = this.skipWhitespace(ch);
            String qualifier = null;
            String attrDefault = null;
            if (ch == 35) {
                ch = this._reader.parseName(this._text, this._reader.read());
                qualifier = "#" + this._text.toString();
                if (!qualifier.equals("#IMPLIED") && !qualifier.equals("#REQUIRED")) {
                    if (!qualifier.equals("#FIXED")) throw this.error(L.l("expected attribute default at `{0}'", (Object)qualifier));
                    ch = this.skipWhitespace(ch);
                    ch = this.parseValue(this._text, ch, false);
                    attrDefault = this._text.toString();
                }
            } else if (ch != 62) {
                ch = this.parseValue(this._text, ch, false);
                attrDefault = this._text.toString();
            }
            def.addAttribute(attrName, attrType, enumeration, qualifier, attrDefault);
            if (attrType != null && attrType.equals("ID")) {
                doctype.setElementId(name, attrName);
            }
            ch = this.skipWhitespace(ch);
        }
        if (ch == 62) return;
        throw this.error(L.l("expected `{0}' at {1}", (Object)">", (Object)XmlParser.badChar(ch)));
    }

    private void parseNotationDecl(QDocumentType doctype) throws IOException, SAXException {
        QNotation notation;
        int ch = this.skipWhitespace(this._reader.read());
        ch = this._reader.parseName(this._text, ch);
        String name = this._text.toString();
        ch = this.skipWhitespace(ch);
        ch = this._reader.parseName(this._text, ch);
        String key = this._text.toString();
        ch = this.skipWhitespace(ch);
        ch = this.parseValue(this._text, ch, false);
        String id = this._text.toString();
        ch = this.skipWhitespace(ch);
        if (key.equals("PUBLIC")) {
            String systemId = null;
            if (ch == 34 || ch == 39) {
                ch = this.parseValue(this._text, ch, false);
                ch = this.skipWhitespace(ch);
                systemId = this._text.toString();
            }
            notation = new QNotation(name, id, systemId);
            notation._owner = doctype._owner;
            notation.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else if (key.equals("SYSTEM")) {
            notation = new QNotation(name, null, id);
            notation._owner = doctype._owner;
            notation.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else {
            throw this.error(L.l("expected PUBLIC or SYSTEM at `{0}'", (Object)key));
        }
        doctype.addNotation(notation);
        doctype.appendChild(notation);
        if (ch != 62) {
            throw this.error(L.l("expected `{0}' at {1}", (Object)">", (Object)XmlParser.badChar(ch)));
        }
    }

    private int parseExternalID(int ch) throws IOException, SAXException {
        ch = this._reader.parseName(this._text, ch);
        String key = this._text.toString();
        ch = this.skipWhitespace(ch);
        this._extSystemId = null;
        this._extPublicId = null;
        if (key.equals("PUBLIC") || this._forgiving && key.equalsIgnoreCase("public")) {
            ch = this.parseValue(this._text, ch, false);
            this._extPublicId = this._text.toString();
            ch = this.skipWhitespace(ch);
            if (this._extPublicId.indexOf(38) > 0) {
                throw this.error(L.l("Illegal character '&' in PUBLIC identifier '{0}'", (Object)this._extPublicId));
            }
            ch = this.parseValue(this._text, ch, false);
            ch = this.skipWhitespace(ch);
            this._extSystemId = this._text.toString();
        } else if (key.equals("SYSTEM") || this._forgiving && key.equalsIgnoreCase("system")) {
            ch = this.parseValue(this._text, ch, false);
            this._extSystemId = this._text.toString();
        } else {
            throw this.error(L.l("expected PUBLIC or SYSTEM at `{0}'", (Object)key));
        }
        return ch;
    }

    private void parseEntityDecl(QDocumentType doctype) throws IOException, SAXException {
        QEntity entity;
        boolean isPe;
        int ch = this.skipWhitespace(this._reader.read());
        boolean bl = isPe = ch == 37;
        if (isPe) {
            ch = this.skipWhitespace(this._reader.read());
        }
        ch = this._reader.parseName(this._text, ch);
        String name = this._text.toString();
        if ((ch = this.skipWhitespace(ch)) == 34 || ch == 39) {
            ch = this.parseValue(this._text, ch, false);
            entity = new QEntity(name, this._text.toString(), null, null);
            entity._owner = doctype._owner;
            entity.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
        } else {
            ch = this.parseExternalID(ch);
            entity = new QEntity(name, null, this._extPublicId, this._extSystemId);
            entity._owner = doctype._owner;
            entity.setLocation(this.getSystemId(), this.getFilename(), this.getLine(), this.getColumn());
            ch = this.skipWhitespace(ch);
            if (!isPe && XmlChar.isNameStart(ch)) {
                ch = this._reader.parseName(this._text, ch);
                String key = this._text.toString();
                if (key.equals("NDATA")) {
                    String ndata;
                    ch = this.skipWhitespace(ch);
                    ch = this._reader.parseName(this._text, ch);
                    entity._ndata = ndata = this._text.toString();
                } else {
                    throw this.error(L.l("expected `NDATA' at `{0}'", (Object)key));
                }
            }
        }
        entity._isPe = isPe;
        if (isPe) {
            doctype.addParameterEntity(entity);
        } else {
            doctype.addEntity(entity);
        }
        doctype.appendChild(entity);
        ch = this.skipWhitespace(ch);
        if (ch != 62) {
            throw this.error(L.l("expected `>' at {0}", (Object)XmlParser.badChar(ch)));
        }
    }

    private boolean isWhitespace(int ch) {
        return ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13);
    }

    private boolean isChar(int ch) {
        return ch >= 32 && ch <= 55295 || ch == 9 || ch == 10 || ch == 13 || ch >= 57344 && ch <= 65533;
    }

    private static String hex(int value) {
        CharBuffer cb = CharBuffer.allocate();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.close();
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    private int getColumn() {
        return 0;
    }

    int getNodeLine() {
        if (this._elementTop > 0) {
            return this._elementLines[this._elementTop - 1];
        }
        return 1;
    }

    public String getPublicId() {
        if (this._reader != null) {
            return this._reader.getPublicId();
        }
        return this._publicId;
    }

    public String getSystemId() {
        if (this._reader != null) {
            return this._reader.getSystemId();
        }
        if (this._systemId != null) {
            return this._systemId;
        }
        return this._filename;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public int getLineNumber() {
        return this.getLine();
    }

    public int getColumnNumber() {
        return this.getColumn();
    }

    private void addText(String s) throws IOException, SAXException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.addText(s.charAt(i));
        }
    }

    private void addText(char ch) throws IOException, SAXException {
        if (this._textLength >= this._textCapacity) {
            this.appendText();
        }
        if (this._textLength > 0 && this._textBuffer[this._textLength - 1] == '\r') {
            this._textBuffer[this._textLength - 1] = 10;
            if (ch == '\n') {
                return;
            }
        }
        if (this._isIgnorableWhitespace && !XmlChar.isWhitespace(ch)) {
            this._isIgnorableWhitespace = false;
        }
        this._textBuffer[this._textLength++] = ch;
    }

    private void appendText() throws IOException, SAXException {
        if (this._textLength > 0) {
            if (this._activeNode == DOC_NAME) {
                if (this._isJspText) {
                    this._contentHandler.characters(this._textBuffer, 0, this._textLength);
                } else if (!this._isIgnorableWhitespace) {
                    if (this._strictXml) {
                        throw this.error(L.l("expected top element at `{0}'", (Object)new String(this._textBuffer, 0, this._textLength)));
                    }
                    this.addChild(TEXT_NAME);
                    this._contentHandler.characters(this._textBuffer, 0, this._textLength);
                }
            } else if (this._isJspText) {
                this._contentHandler.characters(this._textBuffer, 0, this._textLength);
            } else if (this._isIgnorableWhitespace) {
                if (this._isHtml) {
                    this._contentHandler.characters(this._textBuffer, 0, this._textLength);
                } else {
                    this._contentHandler.ignorableWhitespace(this._textBuffer, 0, this._textLength);
                }
            } else if (!this._strictXml || this._isIgnorableWhitespace || this._activeNode != DOC_NAME) {
                if (!this._isJspText) {
                    if (this._isIgnorableWhitespace) {
                        this.addChild(WHITESPACE_NAME);
                    } else {
                        this.addChild(TEXT_NAME);
                    }
                }
                this._contentHandler.characters(this._textBuffer, 0, this._textLength);
            }
            this._textLength = 0;
            this._isIgnorableWhitespace = true;
        }
    }

    private void addElement(String child, boolean isEmpty, QAttributes attributes, NamespaceMap oldNamespace) throws IOException, SAXException {
        this._text.clear();
        this._text.append(child);
        this.addElement(this._policy.getName(this._text), isEmpty, attributes, oldNamespace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addElement(QName child, boolean isEmpty, QAttributes attributes, NamespaceMap oldNamespace) throws IOException, SAXException {
        if (this._doResinInclude) {
            if (child.getName() == "include" && child.getNamespaceURI() == "http://caucho.com/ns/resin/core" || child.getName() == "resin:include") {
                if (!isEmpty) {
                    throw this.error(L.l("resin:include must be an empty tag"));
                }
                this.handleResinInclude();
                return;
            }
            if (child.getName() == "include-directory" && child.getNamespaceURI() == "http://caucho.com/ns/resin/core" || child.getName() == "resin:include-directory") {
                if (!isEmpty) {
                    throw this.error(L.l("resin:include-directory must be an empty tag"));
                }
                this.handleResinIncludeDirectory();
                return;
            }
        }
        if (this._activeNode == DOC_NAME && this._hasTopElement && this._strictXml) {
            throw this.error(L.l("expected a single top-level element at `{0}'", (Object)child.getName()));
        }
        this._hasTopElement = true;
        String childURI = child.getNamespaceURI();
        String childLocal = child.getLocalName();
        if (childURI == null) {
            childURI = "";
            childLocal = this._isNamespaceAware ? child.getName() : "";
        }
        block8: while (true) {
            int action = this._policy.openAction(this, this._activeNode, child);
            switch (action) {
                case 1: {
                    return;
                }
                case 2: {
                    if (this._contentHandler instanceof DOMBuilder) {
                        ((DOMBuilder)this._contentHandler).startElement(child, attributes);
                    } else {
                        this._contentHandler.startElement(childURI, childLocal, child.getName(), attributes);
                    }
                    if (isEmpty) {
                        this._contentHandler.endElement(childURI, childLocal, child.getName());
                        this.popNamespaces(oldNamespace);
                        return;
                    } else {
                        if (this._elementTop == this._elementNames.length) {
                            int len = this._elementNames.length;
                            QName[] names = new QName[2 * len];
                            NamespaceMap[] newNamespaces = new NamespaceMap[2 * len];
                            int[] lines = new int[2 * len];
                            System.arraycopy(this._elementNames, 0, names, 0, len);
                            System.arraycopy(this._elementLines, 0, lines, 0, len);
                            System.arraycopy(this._namespaces, 0, newNamespaces, 0, len);
                            this._elementNames = names;
                            this._elementLines = lines;
                            this._namespaces = newNamespaces;
                        }
                        this._namespaces[this._elementTop] = oldNamespace;
                        this._elementLines[this._elementTop] = this.getLine();
                        this._elementNames[this._elementTop] = this._activeNode;
                        ++this._elementTop;
                        this._activeNode = child;
                        this._isTagStart = true;
                    }
                    return;
                }
                case 3: {
                    if (this._contentHandler instanceof DOMBuilder) {
                        ((DOMBuilder)this._contentHandler).startElement(child, attributes);
                    } else {
                        this._contentHandler.startElement(childURI, childLocal, child.getName(), attributes);
                    }
                    this._contentHandler.endElement(childURI, childLocal, child.getName());
                    this.popNamespaces(oldNamespace);
                    return;
                }
                case 4: {
                    this.addElement(this._policy.getOpt(), false, this._nullAttributes, oldNamespace);
                    continue block8;
                }
                case 5: {
                    if (this._contentHandler instanceof DOMBuilder) {
                        ((DOMBuilder)this._contentHandler).startElement(child, attributes);
                    } else {
                        this._contentHandler.startElement(childURI, childLocal, child.getName(), attributes);
                    }
                    this.scanVerbatim(child.getName());
                    this.appendText();
                    this._contentHandler.endElement(childURI, childLocal, child.getName());
                    return;
                }
                case 6: {
                    this.popNode();
                    if (this._activeNode == null) return;
                    continue block8;
                }
            }
            break;
        }
        throw this.error(L.l("can't add `{0}' to `{1}'", (Object)child.getName(), (Object)this._activeNode.getName()));
    }

    private void addChild(QName child) throws IOException, SAXException {
        block8: while (this._activeNode != null) {
            int action = this._policy.openAction(this, this._activeNode, child);
            switch (action) {
                case 1: {
                    return;
                }
                case 2: {
                    this._isTagStart = true;
                }
                case 3: {
                    return;
                }
                case 4: {
                    this.addElement(this._policy.getOpt(), false, this._nullAttributes, this._namespaceMap);
                    continue block8;
                }
                case 5: {
                    this.scanVerbatim(child.getName());
                    return;
                }
                case 6: {
                    this.popNode();
                    continue block8;
                }
            }
            throw this.error(L.l("cannot add `{0}' to `{1}'", (Object)child.getName(), (Object)this._activeNode.getName()));
        }
    }

    private void scanVerbatim(String name) throws IOException, SAXException {
        int ch = this._reader.read();
        while (ch >= 0) {
            if (ch != 60) {
                this.addText((char)ch);
                ch = this._reader.read();
                continue;
            }
            ch = this._reader.read();
            if (ch != 47) {
                this.addText('<');
                continue;
            }
            ch = this._reader.parseName(this._eltName, this._reader.read());
            if (!this._eltName.matchesIgnoreCase(name)) {
                this.addText("</");
                this.addText(this._eltName.toString());
                continue;
            }
            if (ch != 62) {
                this.addText("</");
                this.addText(this._eltName.toString());
                continue;
            }
            return;
        }
        throw this.error(L.l("expected </{0}> at {1}", (Object)name, (Object)XmlParser.badChar(ch)));
    }

    private int skipWhitespace(int ch) throws IOException, SAXException {
        while (ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13)) {
            ch = this.read();
        }
        return ch;
    }

    public void setReader(XmlReader reader) {
        this._reader = reader;
    }

    private void setMacroAttr(String text) throws IOException, SAXException {
        if (this._reader != this._macro) {
            this._macro.init(this, this._reader);
            this._reader = this._macro;
        }
        int j = this._macroIndex;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\'') {
                this._macro.add("&#39;");
                continue;
            }
            if (ch == '\"') {
                this._macro.add("&#34;");
                continue;
            }
            this._macro.add(ch);
        }
    }

    private void pushInclude(String systemId) throws IOException, SAXException {
        this.pushInclude(null, systemId);
    }

    private void pushInclude(String publicId, String systemId) throws IOException, SAXException {
        InputStream stream = this.openStream(systemId, publicId);
        if (stream == null) {
            throw new FileNotFoundException(systemId);
        }
        this._is = Vfs.openRead(stream);
        Path oldSearchPath = this._searchPath;
        Path path = this._is.getPath();
        if (path != null) {
            this._owner.addDepend(path);
            if (this._searchPath != null) {
                this._searchPath = path.getParent();
                this._reader.setSearchPath(oldSearchPath);
            }
        }
        this._filename = systemId;
        XmlReader oldReader = this._reader;
        this._reader = null;
        this._line = 1;
        int ch = this.parseXMLDeclaration(oldReader);
        XmlReader reader = this._reader;
        if (reader instanceof MacroReader) {
            reader = reader.getNext();
        }
        reader.setSystemId(systemId);
        reader.setFilename(systemId);
        reader.setPublicId(publicId);
        reader.setNext(oldReader);
        this.unread(ch);
    }

    private void popInclude() throws IOException, SAXException {
        XmlReader oldReader = this._reader;
        this._reader = this._reader.getNext();
        oldReader.setNext(null);
        this._filename = this._reader.getFilename();
        this._line = this._reader.getLine();
        this._is = this._reader.getReadStream();
        if (this._reader.getSearchPath() != null) {
            this._searchPath = this._reader.getSearchPath();
        }
    }

    private void setMacro(String text) throws IOException, SAXException {
        if (this._reader != this._macro) {
            if (this._macro.getNext() == null) {
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            } else {
                this._macro = new MacroReader();
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            }
        }
        this._macro.add(text);
    }

    private int read() throws IOException, SAXException {
        int ch = this._reader.read();
        while (ch < 0 && this._reader.getNext() != null) {
            if (this._stopOnIncludeEnd) {
                return -1;
            }
            this.popInclude();
            ch = this._reader.read();
        }
        return ch;
    }

    public void unread(int ch) {
        if (ch < 0) {
            return;
        }
        if (this._reader != this._macro) {
            if (this._macro.getNext() == null) {
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            } else {
                this._macro = new MacroReader();
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            }
        }
        this._macro.prepend((char)ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlParseException error(String text) {
        StringBuilder lines;
        block8: {
            lines = new StringBuilder();
            try {
                Path path = Vfs.lookup(this._systemId);
                if (!path.canRead()) break block8;
                ReadStream is = path.openRead();
                lines.append("\n");
                try {
                    String line;
                    for (int i = 1; i < this._line + 3 && (line = is.readLine()) != null; ++i) {
                        if (this._line - 3 >= i || i >= this._line + 3) continue;
                        lines.append(i).append(": ").append(line).append("\n");
                    }
                    Object var8_9 = null;
                    is.close();
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    is.close();
                    throw throwable;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        text = text + lines;
        if (this._errorHandler != null) {
            SAXParseException e = new SAXParseException(text, this._locator);
            try {
                this._errorHandler.fatalError(e);
            }
            catch (SAXException e1) {
                // empty catch block
            }
        }
        return new XmlParseException(this._filename, this._line, text);
    }

    private void generateDtdValidator(QDocumentType dtd) throws SAXException {
        DtdRelaxGenerator gen = new DtdRelaxGenerator(dtd);
        ContentHandler handler = gen.generate();
        if (handler != null) {
            handler.setDocumentLocator(this._locator);
            handler.startDocument();
            this._contentHandler = new TeeContentHandler(handler, this._contentHandler);
        }
    }

    public void free() {
        this._filename = null;
    }

    static String badChar(int ch) {
        if (ch < 0 || ch == 65535) {
            return L.l("end of file");
        }
        if (ch == 10 || ch == 13) {
            return L.l("end of line");
        }
        if (ch >= 32 && ch <= 127) {
            return "`" + (char)ch + "'";
        }
        return "`" + (char)ch + "' (\\u" + XmlParser.hex(ch) + ")";
    }

    private void printDebugNode(WriteStream s, Node node, int depth) throws IOException {
        if (node == null) {
            return;
        }
        for (int i = 0; i < depth; ++i) {
            s.print(' ');
        }
        if (node.getFirstChild() != null) {
            s.println("<" + node.getNodeName() + ">");
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.printDebugNode(s, child, depth + 2);
            }
            for (int i = 0; i < depth; ++i) {
                s.print(' ');
            }
            s.println("</" + node.getNodeName() + ">");
        } else {
            s.println("<" + node.getNodeName() + "/>");
        }
    }

    public static class LocatorImpl
    implements ExtendedLocator {
        XmlParser _parser;

        LocatorImpl(XmlParser parser) {
            this._parser = parser;
        }

        public String getSystemId() {
            if (this._parser._reader != null && this._parser._reader.getSystemId() != null) {
                return this._parser._reader.getSystemId();
            }
            if (this._parser.getSystemId() != null) {
                return this._parser.getSystemId();
            }
            if (this._parser._reader != null && this._parser._reader.getFilename() != null) {
                return this._parser._reader.getFilename();
            }
            if (this._parser.getFilename() != null) {
                return this._parser.getFilename();
            }
            return null;
        }

        public String getFilename() {
            if (this._parser._reader != null && this._parser._reader.getFilename() != null) {
                return this._parser._reader.getFilename();
            }
            if (this._parser.getFilename() != null) {
                return this._parser.getFilename();
            }
            if (this._parser._reader != null && this._parser._reader.getSystemId() != null) {
                return this._parser._reader.getSystemId();
            }
            if (this._parser.getSystemId() != null) {
                return this._parser.getSystemId();
            }
            return null;
        }

        public String getPublicId() {
            if (this._parser._reader != null) {
                return this._parser._reader.getPublicId();
            }
            return this._parser.getPublicId();
        }

        public int getLineNumber() {
            if (this._parser._reader != null) {
                return this._parser._reader.getLine();
            }
            return this._parser.getLineNumber();
        }

        public int getColumnNumber() {
            return this._parser.getColumnNumber();
        }
    }
}

