/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.stream.PropertyNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXResultXMLStreamWriterImpl
implements XMLStreamWriter {
    private static final Logger log = Logger.getLogger(SAXResultXMLStreamWriterImpl.class.getName());
    private static final L10N L = new L10N(SAXResultXMLStreamWriterImpl.class);
    private LexicalHandler _lexicalHandler;
    private ContentHandler _contentHandler;
    private String _uri;
    private String _localName;
    private String _qName;
    private AttributesImpl _attributes = new AttributesImpl();
    private boolean _unwritten = false;
    private boolean _currentIsEmpty = false;
    private boolean _ended = false;
    private SimpleNamespaceContext _context = new SimpleNamespaceContext(null);

    public SAXResultXMLStreamWriterImpl(SAXResult result) throws XMLStreamException {
        this._lexicalHandler = result.getLexicalHandler();
        this._contentHandler = result.getHandler();
    }

    public void close() throws XMLStreamException {
        try {
            if (!this._ended) {
                this._contentHandler.endDocument();
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void flush() throws XMLStreamException {
    }

    public NamespaceContext getNamespaceContext() {
        return this._context;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this._context.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new PropertyNotSupportedException(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this._context.declare("", uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        String message = "please do not set the NamespaceContext";
        throw new UnsupportedOperationException(message);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        try {
            this._context.declare(prefix, uri);
            this._contentHandler.startPrefixMapping(prefix, uri);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this._unwritten) {
            throw new IllegalStateException();
        }
        this._attributes.addAttribute("", localName, localName, "CDATA", value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this._unwritten) {
            throw new IllegalStateException();
        }
        this._attributes.addAttribute(namespaceURI, localName, localName, "CDATA", value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this._unwritten) {
            throw new IllegalStateException();
        }
        this._attributes.addAttribute(namespaceURI, localName, prefix + ':' + localName, "CDATA", value);
    }

    public void writeCData(String data) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.handleUnwrittenStart();
        try {
            this._contentHandler.characters(text, start, len);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.handleUnwrittenStart();
        char[] array = text.toCharArray();
        this.writeCharacters(array, 0, array.length);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.handleUnwrittenStart();
        try {
            if (this._lexicalHandler != null) {
                char[] array = data.toCharArray();
                this._lexicalHandler.comment(array, 0, array.length);
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (!this._unwritten) {
            throw new IllegalStateException();
        }
        try {
            this._context.declare("", namespaceURI);
            this._contentHandler.startPrefixMapping("", namespaceURI);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.handleUnwrittenStart();
        throw new UnsupportedOperationException();
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        this.handleUnwrittenStart();
        this.pushContext();
        this._uri = null;
        this._localName = localName;
        this._qName = localName;
        this._attributes = new AttributesImpl();
        this._currentIsEmpty = true;
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        this.handleUnwrittenStart();
        this.pushContext();
        this._uri = namespaceURI;
        this._localName = localName;
        this._qName = localName;
        this._attributes = new AttributesImpl();
        this._currentIsEmpty = true;
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
        }
        this.handleUnwrittenStart();
        this.pushContext();
        this._uri = namespaceURI;
        this._localName = localName;
        this._qName = prefix + ':' + localName;
        this._attributes = new AttributesImpl();
        this._currentIsEmpty = true;
    }

    public void writeEndDocument() throws XMLStreamException {
        this.handleUnwrittenStart();
        try {
            this._contentHandler.endDocument();
            this._ended = true;
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndElement() throws XMLStreamException {
        this.popContext();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.handleUnwrittenStart();
        throw new UnsupportedOperationException();
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (!this._unwritten) {
            throw new IllegalStateException();
        }
        this._context.declare(prefix, namespaceURI);
        this._attributes.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", namespaceURI);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.handleUnwrittenStart();
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.handleUnwrittenStart();
        try {
            this._contentHandler.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            this._contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        try {
            this._contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartDocument(String version, String encoding) throws XMLStreamException {
        try {
            this._contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        this.pushContext();
        this._uri = null;
        this._localName = localName;
        this._qName = localName;
        this._attributes = new AttributesImpl();
        this._unwritten = true;
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        this.pushContext();
        this._uri = namespaceURI;
        this._localName = localName;
        this._qName = localName;
        this._attributes = new AttributesImpl();
        this._unwritten = true;
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this._currentIsEmpty) {
            this.popContext();
            this._currentIsEmpty = false;
        }
        this.pushContext();
        this._uri = namespaceURI;
        this._localName = localName;
        this._qName = prefix + ':' + localName;
        this._attributes = new AttributesImpl();
        this._unwritten = true;
    }

    private void handleUnwrittenStart() throws XMLStreamException {
        try {
            if (this._unwritten) {
                this._contentHandler.startElement(this._uri, this._localName, this._qName, this._attributes);
            }
            this._unwritten = false;
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void pushContext() throws XMLStreamException {
        this._context = new SimpleNamespaceContext(this._context);
    }

    private void popContext() throws XMLStreamException {
        try {
            if (this._currentIsEmpty) {
                this._contentHandler.startElement(this._uri, this._localName, this._qName, this._attributes);
            }
            for (String prefix : this._context.getPrefixMap().keySet()) {
                this._contentHandler.endPrefixMapping(prefix);
            }
            this._contentHandler.endElement(this._uri, this._localName, this._qName);
            this._context = this._context.getParent();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleNamespaceContext
    implements NamespaceContext {
        private HashMap<String, String> _uris = new HashMap();
        private HashMap<String, List<String>> _prefixes = new HashMap();
        private SimpleNamespaceContext _parent;
        private int _prefixCounter = 0;

        public SimpleNamespaceContext(SimpleNamespaceContext parent) {
            this._parent = parent;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this._uris.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            List<String> prefixes = this._prefixes.get(namespaceURI);
            if (prefixes == null || prefixes.size() == 0) {
                return null;
            }
            return prefixes.get(0);
        }

        public Iterator getPrefixes(String namespaceURI) {
            List<String> prefixes = this._prefixes.get(namespaceURI);
            if (prefixes == null) {
                prefixes = new ArrayList<String>();
                this._prefixes.put(namespaceURI, prefixes);
            }
            return prefixes.iterator();
        }

        public HashMap<String, String> getPrefixMap() {
            return this._uris;
        }

        public String declare(String namespaceURI) {
            String prefix = "ns" + this._prefixCounter;
            this.declare(prefix, namespaceURI);
            ++this._prefixCounter;
            return prefix;
        }

        public void declare(String prefix, String namespaceURI) {
            this._uris.put(prefix, namespaceURI);
            List<String> prefixes = this._prefixes.get(namespaceURI);
            if (prefixes == null) {
                prefixes = new ArrayList<String>();
                this._prefixes.put(namespaceURI, prefixes);
            }
            prefixes.add(prefix);
        }

        public SimpleNamespaceContext getParent() {
            return this._parent;
        }
    }
}

