/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.utils.RolloverMenuItemListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.CheckBoxMenuItemIcon;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceCheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI
implements SubstanceMenu {
    protected RolloverMenuItemListener substanceRolloverListener;
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;

    public static ComponentUI createUI(JComponent b) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)b;
        item.setRolloverEnabled(true);
        return new SubstanceCheckBoxMenuItemUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceRolloverListener = new RolloverMenuItemListener(this.menuItem);
        this.menuItem.addMouseListener(this.substanceRolloverListener);
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(this.menuItem, this.menuItem.getModel(), true, false, this.menuItem));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCheckBoxMenuItemUI.this.substanceFadeStateListener != null) {
                        SubstanceCheckBoxMenuItemUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceCheckBoxMenuItemUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceCheckBoxMenuItemUI.this.menuItem, SubstanceCheckBoxMenuItemUI.this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(SubstanceCheckBoxMenuItemUI.this.menuItem, SubstanceCheckBoxMenuItemUI.this.menuItem.getModel(), true, false, SubstanceCheckBoxMenuItemUI.this.menuItem));
                    SubstanceCheckBoxMenuItemUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceCheckBoxMenuItemUI.this.menuItem.updateUI();
                        }
                    });
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = new CheckBoxMenuItemIcon(this.menuItem, 1 + SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getComponentFontSize(this.menuItem)));
        }
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return this.checkIcon;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon, defaultTextIconGap);
    }
}

