/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    private static final String propertyPrefix = "CheckBox.";
    protected FadeStateListener substanceFadeStateListener;
    protected PropertyChangeListener substancePropertyListener;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceCheckBoxUI((JToggleButton)b);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCheckBoxUI.this.substanceFadeStateListener != null) {
                        SubstanceCheckBoxUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceCheckBoxUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
                    SubstanceCheckBoxUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    public static synchronized void reset() {
        icons.clear();
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        float checkMarkVisibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        boolean isCheckMarkFadingOut = false;
        boolean isTableRenderer = button instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(button, currState, isTableRenderer && currState == ComponentState.SELECTED);
        SubstanceTheme theme2 = SubstanceThemeUtilities.getTheme(button, prevState, isTableRenderer && currState == ComponentState.SELECTED);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                checkMarkVisibility = fadeState.getFadePosition();
                isCheckMarkFadingOut = !fadeState.isFadingIn();
            }
        }
        int checkMarkSize = SubstanceSizeUtils.getCheckBoxMarkSize(SubstanceSizeUtils.getComponentFontSize(button));
        String key = checkMarkSize + ":" + currState.name() + ":" + prevState.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + checkMarkVisibility + ":" + isCheckMarkFadingOut;
        ImageIcon result = null;
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, checkMarkSize, currState, theme, theme2, cyclePos, checkMarkVisibility / 10.0f, isCheckMarkFadingOut));
        icons.put(key, result);
        return result;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        ComponentState currState = ComponentState.getState(model, this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceCheckBoxUI.getIcon(this.button, currState, prevState);
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

