/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Highlighter;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.text.SubstanceHighlighter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceEditorPaneUI
extends BasicEditorPaneUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JEditorPane editorPane;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceEditorPaneUI(c);
    }

    public SubstanceEditorPaneUI(JComponent c) {
        this.editorPane = (JEditorPane)c;
    }

    protected void installListeners() {
        super.installListeners();
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.editorPane, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceEditorPaneUI.this.editorPane.updateUI();
                        }
                    });
                }
            }
        };
        this.editorPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.editorPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void installDefaults() {
        super.installDefaults();
        Border b = this.editorPane.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editorPane))), new BasicBorders.MarginBorder());
            this.editorPane.setBorder(newB);
        }
    }

    protected void paintBackground(Graphics g) {
        SubstanceCoreUtilities.paintTextCompBackground(g, this.editorPane);
    }

    protected Highlighter createHighlighter() {
        return new SubstanceHighlighter();
    }
}

