/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceLabelUI
extends BasicLabelUI {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private static final String ORIG_ICON = "substancelaf.internal.label.origIcon";
    private static final String REPLACING_ICON = "substancelaf.internal.label.replacingIcon";
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceLabelUI();
    }

    protected void replaceThemedIcon(final JLabel label) {
        if (!SubstanceCoreUtilities.useThemedDefaultIcon(label)) {
            return;
        }
        final Icon icon = label.getIcon();
        if (icon != null && !Boolean.TRUE.equals(label.getClientProperty(REPLACING_ICON))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    label.putClientProperty(SubstanceLabelUI.ORIG_ICON, label.getIcon());
                    label.putClientProperty(SubstanceLabelUI.REPLACING_ICON, Boolean.TRUE);
                    label.setIcon(new ImageIcon(SubstanceImageCreator.getThemeImage(label, icon, SubstanceThemeUtilities.getTheme(label, ComponentState.DEFAULT), false)));
                    label.putClientProperty(SubstanceLabelUI.REPLACING_ICON, null);
                }
            });
        }
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.replaceThemedIcon(c);
    }

    protected void uninstallDefaults(JLabel c) {
        Icon origIcon = (Icon)c.getClientProperty(ORIG_ICON);
        if (origIcon != null) {
            c.putClientProperty(REPLACING_ICON, Boolean.TRUE);
            c.setIcon(origIcon);
            c.putClientProperty(REPLACING_ICON, null);
        }
        super.uninstallDefaults(c);
    }

    protected void installListeners(final JLabel c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceLabelUI.this.replaceThemedIcon(c);
                }
                if ("substancelaf.useThemedDefaultIcons".equals(evt.getPropertyName())) {
                    SubstanceLabelUI.this.replaceThemedIcon(c);
                }
                if ("opaque".equals(evt.getPropertyName()) && !Boolean.TRUE.equals(c.getClientProperty("substancelaf.lockopacity"))) {
                    c.putClientProperty("substancelaf.buttonopacityoriginal", evt.getNewValue());
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    public void paint(Graphics g, final JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        final Rectangle paintIconR = new Rectangle();
        final Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        Insets insets = label.getInsets(paintViewInsets);
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = c.getWidth() - (insets.left + insets.right);
        paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        paintIconR.height = 0;
        paintIconR.width = 0;
        paintIconR.y = 0;
        paintIconR.x = 0;
        paintTextR.height = 0;
        paintTextR.width = 0;
        paintTextR.y = 0;
        paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(label, g.getFontMetrics(), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        textPainter.init(label, null, true);
        if (textPainter.needsBackgroundImage()) {
            Color color = label.isOpaque() || label.getParent() == null ? label.getBackground() : label.getParent().getBackground();
            textPainter.setBackgroundFill(label, color, true, 0, 0);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    if (icon != null) {
                        icon.paintIcon(c, g, paintIconR.x, paintIconR.y);
                    }
                }
            });
        } else {
            if (!DefaultListCellRenderer.class.isAssignableFrom(c.getClass())) {
                this.bgDelegate.updateIfOpaque(g2d, c);
            }
            if (icon != null) {
                icon.paintIcon(c, g2d, paintIconR.x, paintIconR.y);
            }
        }
        float textAlpha = 1.0f;
        if (text != null) {
            final View v = (View)c.getClientProperty("html");
            if (v != null) {
                if (textPainter.needsBackgroundImage()) {
                    textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                        public void paintBackground(Graphics g) {
                            v.paint(g, paintTextR);
                        }
                    });
                } else {
                    v.paint(g2d, paintTextR);
                }
            } else {
                ComponentState labelState = label.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
                textAlpha = SubstanceCoreUtilities.paintText(label, paintTextR, clippedText, label.getDisplayedMnemonicIndex(), labelState, labelState);
            }
        }
        g2d.setComposite(TransitionLayout.getAlphaComposite(label, textAlpha, g));
        textPainter.renderSurface(g2d);
        g2d.dispose();
    }

    public void update(Graphics g, JComponent c) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        this.paint(g, c);
    }
}

