/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSeparatorUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(c).getDefaultTheme();
        ColorScheme colorScheme = theme.getColorScheme();
        try {
            Container parent = c.getParent();
            if (!(parent instanceof JPopupMenu)) {
                SubstanceCoreUtilities.paintSeparator(c, graphics, colorScheme, SubstanceCoreUtilities.isThemeDark(theme), c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
                return;
            }
            int xOffset = MenuUtilities.getTextOffset(c, parent);
            Dimension s = c.getSize();
            int startX = 0;
            int width = s.width;
            if (parent.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceThemeUtilities.getTheme(parent, ComponentState.DEFAULT).getColorScheme();
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, xOffset, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(parent, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, xOffset - 2, c.getHeight());
                }
                startX = xOffset - 2;
                width = s.width - startX;
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceThemeUtilities.getTheme(parent, ComponentState.DEFAULT).getColorScheme();
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    GradientPaint gp = new GradientPaint(xOffset, 0.0f, leftColor, s.width, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(parent, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(xOffset - 2, 0, s.width, c.getHeight());
                }
                startX = 0;
                width = xOffset - 4;
            }
            graphics.translate(startX, 0);
            graphics.setComposite(TransitionLayout.getAlphaComposite(parent));
            SubstanceCoreUtilities.paintSeparator(c, graphics, colorScheme, SubstanceCoreUtilities.isThemeDark(theme), width, s.height, ((JSeparator)c).getOrientation(), true, 2);
        }
        finally {
            graphics.dispose();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

