/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.TabCloseListener;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.scroll.SubstanceScrollButton;
import org.jvnet.substance.tabbed.BaseTabCloseListener;
import org.jvnet.substance.tabbed.MultipleTabCloseListener;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.tabbed.VetoableMultipleTabCloseListener;
import org.jvnet.substance.tabbed.VetoableTabCloseListener;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.ModifiedFadeStep;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.icon.RotatableIcon;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Point substanceMouseLocation;
    private static Map<String, BufferedImage> backgroundMap = new SoftHashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> closeButtonMap = new SoftHashMap<String, BufferedImage>();
    private Map<Component, Long> fadeModifiedIds;
    private Map<Integer, ComponentState> prevStateMap;
    private Map<Integer, ComponentState> nextStateMap;
    protected MouseRolloverHandler substanceRolloverHandler;
    protected TabbedContainerListener substanceContainerListener;
    protected ChangeListener substanceSelectionListener;
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();

    public static synchronized void reset() {
        backgroundMap.clear();
    }

    public static ComponentUI createUI(JComponent tabPane) {
        SubstanceTabbedPaneUI result = new SubstanceTabbedPaneUI();
        return result;
    }

    public SubstanceTabbedPaneUI() {
        this.prevStateMap = new HashMap<Integer, ComponentState>();
        this.nextStateMap = new HashMap<Integer, ComponentState>();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.substanceRolloverHandler);
        this.tabPane.addMouseListener(this.substanceRolloverHandler);
        this.substanceContainerListener = new TabbedContainerListener();
        this.substanceContainerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComp = this.tabPane.getComponentAt(i);
            if (!SubstanceCoreUtilities.isTabModified(tabComp)) continue;
            long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), this.tabPane, Integer.valueOf(i), false, this.getCallback(i), -1, true);
            this.fadeModifiedIds.put(tabComp, fadeInstanceId);
        }
        this.tabPane.addContainerListener(this.substanceContainerListener);
        this.substanceSelectionListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceTabbedPaneUI.this.tabPane == null) {
                            return;
                        }
                        int selected = SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex();
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (selected >= 0 && selected < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(selected)) {
                            fadeTracker.trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, selected, true, (FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, selected));
                        }
                    }
                });
            }
        };
        this.tabPane.getModel().addChangeListener(this.substanceSelectionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.substanceRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.substanceRolloverHandler);
            this.tabPane.removeMouseListener(this.substanceRolloverHandler);
            this.substanceRolloverHandler = null;
        }
        if (this.substanceContainerListener != null) {
            for (Map.Entry entry : this.substanceContainerListener.listeners.entrySet()) {
                Component comp = (Component)entry.getKey();
                for (PropertyChangeListener pcl : (List)entry.getValue()) {
                    comp.removePropertyChangeListener(pcl);
                }
            }
            this.substanceContainerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.substanceContainerListener);
            this.substanceContainerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.substanceSelectionListener);
        this.substanceSelectionListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.fadeModifiedIds = new HashMap<Component, Long>();
    }

    @Override
    protected void uninstallDefaults() {
        this.fadeModifiedIds.clear();
        super.uninstallDefaults();
    }

    private static synchronized BufferedImage getTabBackground(JTabbedPane tabPane, int width, int height, boolean isSelected, float cyclePos, int tabPlacement, SubstanceConstants.Side side, ColorScheme colorScheme, ColorScheme colorScheme2, ColorScheme borderScheme, ColorScheme borderScheme2, boolean paintOnlyBorder) {
        SubstanceGradientPainter gradientPainter = SubstanceCoreUtilities.getGradientPainter(tabPane);
        if (gradientPainter == null) {
            return null;
        }
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(tabPane);
        int borderDelta = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(tabPane)));
        int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(tabPane)) / 2.0);
        int dx = 0;
        int ox = 0;
        int oy = 0;
        int dy = 0;
        switch (side) {
            case BOTTOM: {
                dy = 2 + borderDelta;
                break;
            }
            case TOP: {
                dy = 2 + borderDelta;
                break;
            }
            case RIGHT: {
                dx = 2 + borderDelta;
                break;
            }
            case LEFT: {
                dx = 2 + borderDelta;
                ox = -2 - borderDelta;
            }
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(tabPane);
        String key = width + dx + ":" + (height + dy) + ":" + isSelected + ":" + cyclePos + ":" + side.toString() + ":" + gradientPainter.getDisplayName() + ":" + borderPainter.getDisplayName() + ":" + shaper.getDisplayName() + ":" + tabPlacement + ":" + side.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + SubstanceCoreUtilities.getSchemeId(borderScheme) + ":" + SubstanceCoreUtilities.getSchemeId(borderScheme2) + ":" + paintOnlyBorder;
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            HashSet<SubstanceConstants.Side> straightSides = new HashSet<SubstanceConstants.Side>();
            straightSides.add(side);
            int cornerRadius = height / 3;
            if (shaper instanceof ClassicButtonShaper) {
                cornerRadius = (int)SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(tabPane));
                if (tabPlacement == 1 || tabPlacement == 3) {
                    --width;
                } else {
                    --height;
                }
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width + dx, height + dy, (float)cornerRadius, straightSides, borderInsets);
            result = gradientPainter.getContourBackground(width + dx, height + dy, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage finalImage = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalImage.getGraphics();
            finalGraphics.translate(ox, oy);
            if (!paintOnlyBorder) {
                finalGraphics.drawImage((Image)result, 0, 0, null);
            }
            int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(tabPane));
            GeneralPath contourInner = BaseButtonShaper.getBaseOutline(width + dx, height + dy, (float)cornerRadius, straightSides, borderThickness + borderInsets);
            borderPainter.paintBorder(finalGraphics, tabPane, width + dx, height + dy, contour, contourInner, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
            backgroundMap.put(key, finalImage);
            result = finalImage;
        }
        return result;
    }

    private static synchronized BufferedImage getCloseButtonImage(JTabbedPane tabPane, int width, int height, float cyclePos10, boolean toPaintBackground, ColorScheme colorScheme, ColorScheme colorScheme2) {
        SubstanceGradientPainter gradientPainter = SubstanceLookAndFeel.getCurrentGradientPainter();
        if (gradientPainter == null) {
            return null;
        }
        String key = width + ":" + height + ":" + toPaintBackground + ":" + cyclePos10 + ":" + gradientPainter.getDisplayName() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2);
        BufferedImage result = closeButtonMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)result.getGraphics();
            finalGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (toPaintBackground) {
                GeneralPath contour = BaseButtonShaper.getBaseOutline(width, height, 1.0f, null);
                BufferedImage background = gradientPainter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos10, true, colorScheme != colorScheme2);
                finalGraphics.drawImage((Image)background, 0, 0, null);
                SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(tabPane);
                borderPainter.paintBorder(finalGraphics, tabPane, width, height, contour, null, colorScheme, colorScheme2, cyclePos10, colorScheme != colorScheme2);
            }
            finalGraphics.setStroke(new BasicStroke(SubstanceSizeUtils.getTabCloseButtonStrokeWidth(SubstanceSizeUtils.getComponentFontSize(tabPane))));
            int delta = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(tabPane)));
            if (delta % 2 == 1) {
                --delta;
            }
            int iconSize = width - delta;
            if (colorScheme == colorScheme2) {
                cyclePos10 = 0.0f;
            }
            if ((double)cyclePos10 > 0.0) {
                Icon closeIcon2 = SubstanceImageCreator.getCloseIcon(iconSize, colorScheme2);
                closeIcon2.paintIcon(tabPane, finalGraphics, delta / 2, delta / 2);
            }
            if ((double)cyclePos10 < 1.0) {
                Icon closeIcon = SubstanceImageCreator.getCloseIcon(iconSize, colorScheme);
                finalGraphics.setComposite(AlphaComposite.getInstance(3, 1.0f - cyclePos10 / 10.0f));
                closeIcon.paintIcon(tabPane, finalGraphics, delta / 2, delta / 2);
            }
            closeButtonMap.put(key, result);
        }
        return result;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, final int tabIndex, final int x, final int y, int w, int h, boolean isSelected) {
        FadeState fadeState;
        BufferedImage backgroundImage = null;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.tabPane, g));
        Component tabComponent = this.tabPane.getComponentAt(tabIndex);
        ComponentState prevState = this.getPrevTabState(tabIndex);
        ComponentState currState = this.getTabState(tabIndex);
        if (prevState == null) {
            prevState = currState;
        }
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(this.tabPane, tabIndex, currState);
        SubstanceTheme theme2 = SubstanceThemeUtilities.getTheme(this.tabPane, tabIndex, prevState);
        ColorScheme colorScheme = theme.getColorScheme();
        ColorScheme colorScheme2 = theme2.getColorScheme();
        ColorScheme borderScheme = theme.getBorderTheme().getColorScheme();
        ColorScheme borderScheme2 = theme2.getBorderTheme().getColorScheme();
        graphics.clip(new Rectangle(x, y, w, h));
        boolean isRollover = this.getRolloverTab() == tabIndex;
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        boolean hasActivePresence = isSelected || isRollover && isEnabled;
        float cyclePos = isRollover && isEnabled ? 5.0f : 0.0f;
        Component comp = this.tabPane.getComponentAt(tabIndex);
        boolean isWindowModified = SubstanceCoreUtilities.isTabModified(comp);
        boolean toMarkModifiedCloseButton = SubstanceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, tabIndex);
        if (isWindowModified && isEnabled && !toMarkModifiedCloseButton) {
            colorScheme2 = SubstanceTheme.YELLOW;
            colorScheme = SubstanceTheme.ORANGE;
            cyclePos = FadeTracker.getInstance().getFade10((Component)this.tabPane, tabIndex, ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND);
            hasActivePresence = true;
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (!isWindowModified && (fadeState = fadeTracker.getFadeState((Component)this.tabPane, tabIndex, FadeKind.ROLLOVER)) != null) {
            hasActivePresence = true;
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                ColorScheme temp = colorScheme;
                colorScheme = colorScheme2;
                colorScheme2 = temp;
                temp = borderScheme;
                borderScheme = borderScheme2;
                borderScheme2 = temp;
            }
        }
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        switch (tabPlacement) {
            case 2: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, toSwap ? 1 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.RIGHT, colorScheme, colorScheme2, borderScheme, borderScheme2, false);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceThemeUtilities.getNonColorizedTheme(this.tabPane, tabIndex);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.drawImage((Image)SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, toSwap ? 1 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.RIGHT, colorScheme, colorScheme2, borderScheme, borderScheme2, true), 0, 0, null);
                if (toSwap) {
                    backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                    break;
                }
                backgroundImage = SubstanceCoreUtilities.blendImagesHorizontal(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                break;
            }
            case 4: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, toSwap ? 3 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.LEFT, colorScheme, colorScheme2, borderScheme, borderScheme2, false);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceThemeUtilities.getNonColorizedTheme(this.tabPane, tabIndex);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.drawImage((Image)SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, toSwap ? 3 : tabPlacement, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.LEFT, colorScheme, colorScheme2, borderScheme, borderScheme2, true), 0, 0, null);
                if (toSwap) {
                    backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
                    break;
                }
                backgroundImage = SubstanceCoreUtilities.blendImagesHorizontal(fade, backgroundImage, 1.0 - tabTheme.getSelectedTabFadeEnd(), 1.0 - tabTheme.getSelectedTabFadeStart());
                break;
            }
            case 3: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2, borderScheme, borderScheme2, false);
                backgroundImage = SubstanceImageCreator.getRotated(backgroundImage, 2);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceThemeUtilities.getNonColorizedTheme(this.tabPane, tabIndex);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2, borderScheme, borderScheme2, true), 2), 0, 0, null);
                backgroundImage = SubstanceCoreUtilities.blendImagesVertical(fade, backgroundImage, 1.0 - tabTheme.getSelectedTabFadeEnd(), 1.0 - tabTheme.getSelectedTabFadeStart());
                break;
            }
            default: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2, borderScheme, borderScheme2, false);
                if (!isSelected) break;
                int fw = backgroundImage.getWidth();
                int fh = backgroundImage.getHeight();
                SubstanceTheme tabTheme = SubstanceThemeUtilities.getNonColorizedTheme(this.tabPane, tabIndex);
                BufferedImage fade = SubstanceCoreUtilities.getBlankImage(fw, fh);
                Graphics2D fadeGraphics = fade.createGraphics();
                fadeGraphics.setColor(tabComponent != null ? tabComponent.getBackground() : this.tabPane.getBackground());
                fadeGraphics.fillRect(0, 0, fw, fh);
                SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(fadeGraphics, this.tabPane, 0, 0, fw, fh);
                fadeGraphics.drawImage((Image)SubstanceTabbedPaneUI.getTabBackground(this.tabPane, w, h, isSelected, cyclePos, tabPlacement, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2, borderScheme, borderScheme2, true), 0, 0, null);
                backgroundImage = SubstanceCoreUtilities.blendImagesVertical(backgroundImage, fade, tabTheme.getSelectedTabFadeStart(), tabTheme.getSelectedTabFadeEnd());
            }
        }
        final BufferedImage result = SubstanceCoreUtilities.getBlankImage(backgroundImage.getWidth(), backgroundImage.getHeight());
        Graphics2D resultGr = result.createGraphics();
        if (backgroundImage != null) {
            ControlBackgroundComposite composite = SubstanceCoreUtilities.getControlBackgroundComposite(this.tabPane);
            resultGr.setComposite(composite.getBackgroundComposite(tabComponent, this.tabPane, tabIndex, hasActivePresence));
            resultGr.drawImage((Image)backgroundImage, 0, 0, null);
        }
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && isEnabled) {
            float alpha;
            float f = alpha = isSelected || isRollover ? 1.0f : 0.0f;
            if (!isSelected && fadeTracker.isTracked((Component)this.tabPane, tabIndex, FadeKind.ROLLOVER)) {
                alpha = fadeTracker.getFade10((Component)this.tabPane, tabIndex, FadeKind.ROLLOVER) / 10.0f;
            }
            if ((double)alpha > 0.0) {
                resultGr.setComposite(AlphaComposite.getInstance(3, alpha));
                Rectangle orig = this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
                boolean toPaintCloseBorder = false;
                if (isRollover && this.substanceMouseLocation != null) {
                    Rectangle rect;
                    Rectangle bounds = new Rectangle();
                    bounds = this.getTabBounds(tabIndex, bounds);
                    if (toSwap) {
                        bounds = new Rectangle(bounds.x, bounds.y, bounds.height, bounds.width);
                    }
                    if ((rect = this.getCloseButtonRectangleForEvents(tabIndex, bounds.x, bounds.y, bounds.width, bounds.height)).contains(this.substanceMouseLocation)) {
                        toPaintCloseBorder = true;
                    }
                }
                if (isWindowModified && isEnabled && toMarkModifiedCloseButton) {
                    colorScheme2 = SubstanceTheme.YELLOW;
                    colorScheme = SubstanceTheme.ORANGE;
                    cyclePos = FadeTracker.getInstance().getFade10((Component)this.tabPane, tabIndex, ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND);
                }
                BufferedImage closeButtonImage = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, orig.width, orig.height, cyclePos, toPaintCloseBorder, colorScheme, colorScheme2);
                resultGr.drawImage((Image)closeButtonImage, orig.x - x, orig.y - y, null);
            }
        }
        final ComponentState state = this.getTabState(tabIndex);
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(this.tabPane, this.getTabRectangle(tabIndex), true);
        if (textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(this.tabPane, this.tabPane.getBackground(), true, x, y);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setComposite(TransitionLayout.getAlphaComposite(SubstanceTabbedPaneUI.this.tabPane, SubstanceThemeUtilities.getTheme(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(tabIndex)).getThemeAlpha(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(tabIndex), state), g));
                    g2d.drawImage((Image)result, x, y, null);
                    g2d.dispose();
                }
            });
        } else {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.tabPane, SubstanceThemeUtilities.getTheme(this.tabPane.getComponentAt(tabIndex)).getThemeAlpha(this.tabPane.getComponentAt(tabIndex), state), g));
            graphics.drawImage((Image)result, x, y, null);
        }
        resultGr.dispose();
        graphics.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected JButton createScrollButton(final int direction) {
        SubstanceScrollButton ssb = new SubstanceScrollButton(direction);
        TransitionAwareIcon icon = new TransitionAwareIcon(ssb, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(SubstanceTabbedPaneUI.this.tabPane);
                return SubstanceImageCreator.getArrowIcon(fontSize, direction, theme);
            }
        });
        ssb.setIcon(icon);
        return ssb;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets result = super.getTabAreaInsets(tabPlacement);
        return result;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets result = super.getTabInsets(tabPlacement, tabIndex);
        return result;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        int result = this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return result;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        if (tabPlacement == 1 || tabPlacement == 3) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
        }
        return result;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return super.getTabRunOverlay(tabPlacement);
        }
        return 0;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        this.bgDelegate.updateIfOpaque(g, this.tabPane);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        Icon superResult = super.getIconForTab(tabIndex);
        if (!SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return superResult;
        }
        if (!SubstanceCoreUtilities.toShowIconUnrotated(this.tabPane, tabIndex)) {
            return superResult;
        }
        boolean rotateClockwise = this.tabPane.getTabPlacement() == 2;
        return new RotatableIcon(superResult, rotateClockwise);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int tabIndex, int x, int y, int width, int height) {
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        int borderDelta = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        int xs = this.tabPane.getComponentOrientation().isLeftToRight() ? x + width - dimension - borderDelta : x + borderDelta;
        int ys = y + (height - dimension) / 2 + 1;
        return new Rectangle(xs, ys, dimension, dimension);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int tabIndex, int x, int y, int w, int h) {
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
        }
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        Point2D transCorner = null;
        Rectangle rectForDraw = this.getCloseButtonRectangleForDraw(tabIndex, x, y, h, w);
        if (tabPlacement == 2) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(-1.5707963267948966, x, y);
            trans.translate(-h, 0.0);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMaxX(), rectForDraw.getMinY());
            transCorner = trans.transform(origCorner, null);
        } else {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966, x, y);
            trans.translate(0.0, -w);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMinX(), rectForDraw.getMaxY());
            transCorner = trans.transform(origCorner, null);
        }
        return new Rectangle((int)transCorner.getX(), (int)transCorner.getY(), dimension, dimension);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            LayoutManager lm = this.tabPane.getLayout();
            if (lm instanceof BasicTabbedPaneUI.TabbedPaneLayout) {
                BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)lm;
                layout.calculateLayoutInfo();
            } else if (lm instanceof TransitionLayout && (lm = ((TransitionLayout)lm).getDelegate()) instanceof TabbedPaneLayout) {
                TabbedPaneLayout layout = (TabbedPaneLayout)lm;
                layout.calculateLayoutInfo();
            }
        }
    }

    public FadeTrackerCallback getCallback(int tabIndex) {
        return new TabRepaintCallback(this.tabPane, tabIndex);
    }

    protected void tryCloseTabs(int tabIndex, SubstanceConstants.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == tabIndex) continue;
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        this.tryCloseTab(tabIndex);
    }

    protected void tryCloseTab(int tabIndex) {
        Component component = this.tabPane.getComponentAt(tabIndex);
        HashSet<Component> componentSet = new HashSet<Component>();
        componentSet.add(component);
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener vetoableListener;
            if (listener instanceof VetoableTabCloseListener) {
                vetoableListener = (VetoableTabCloseListener)listener;
                boolean bl = isVetoed = isVetoed || vetoableListener.vetoTabClosing(this.tabPane, component);
            }
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosing(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        this.tabPane.remove(tabIndex);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosed(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> tabIndexes) {
        HashSet<Component> componentSet = new HashSet<Component>();
        for (int tabIndex : tabIndexes) {
            componentSet.add(this.tabPane.getComponentAt(tabIndex));
        }
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        for (Component toRemove : componentSet) {
            this.tabPane.remove(toRemove);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, this.getTextAlignment(tabPlacement), 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected int getTextAlignment(int tabPlacement) {
        SubstanceConstants.TabTextAlignmentKind textAlignmentKind = SubstanceCoreUtilities.getTabTextAlignmentKind(this.tabPane);
        if (SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return 0;
        }
        if (tabPlacement == 2) {
            switch (textAlignmentKind) {
                case ALWAYS_LEFT: 
                case FOLLOW_PLACEMENT: {
                    return 2;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_RIGHT: {
                    return 4;
                }
            }
        }
        if (tabPlacement == 4) {
            switch (textAlignmentKind) {
                case FOLLOW_PLACEMENT: 
                case ALWAYS_RIGHT: {
                    return 4;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_LEFT: {
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int textAlignment = this.getTextAlignment(tabPlacement);
        int delta = 0;
        if (textAlignment == 2) {
            delta = 10;
        }
        if (textAlignment == 4) {
            delta = -10 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        if (textAlignment == 0 && SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex)) {
            delta = this.tabPane.getComponentOrientation().isLeftToRight() ? 5 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) : SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex) - 5;
        }
        return delta + super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int result = 0;
        result = tabPlacement == 3 ? -1 : 1;
        return result;
    }

    protected int getTabExtraWidth(int tabPlacement, int tabIndex) {
        int extraWidth = 0;
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        extraWidth = shaper instanceof ClassicButtonShaper ? (int)(2.0 * (double)SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.tabPane))) : super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight()) / 3;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && this.tabPane.isEnabledAt(tabIndex)) {
            extraWidth += 4 + SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return extraWidth;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        this.tabAreaInsets = insets;
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceTabbedPaneUI: \n");
        sb.append("\t" + backgroundMap.size() + " backgrounds");
        return sb.toString();
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        int delta;
        Insets insets = SubstanceSizeUtils.getTabbedPaneContentInsets(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        SubstanceConstants.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean isPlacement = kind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        int n = delta = isDouble ? (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane))) : 0;
        if (isPlacement) {
            switch (tabPlacement) {
                case 1: {
                    return new Insets(insets.top + delta, 0, 0, 0);
                }
                case 2: {
                    return new Insets(0, insets.left + delta, 0, 0);
                }
                case 4: {
                    return new Insets(0, 0, 0, insets.right + delta);
                }
                case 3: {
                    return new Insets(0, 0, insets.bottom + delta, 0);
                }
            }
        } else {
            switch (tabPlacement) {
                case 1: {
                    return new Insets(insets.top + delta, insets.left, insets.bottom, insets.right);
                }
                case 2: {
                    return new Insets(insets.top, insets.left + delta, insets.bottom, insets.right);
                }
                case 4: {
                    return new Insets(insets.top, insets.left, insets.bottom, insets.right + delta);
                }
                case 3: {
                    return new Insets(insets.top, insets.left, insets.bottom + delta, insets.right);
                }
            }
        }
        return insets;
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceConstants.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 3) {
            return;
        }
        int ribbonDelta = (int)(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath bottomOutline = new GeneralPath();
            bottomOutline.moveTo(x, y + h - 1);
            bottomOutline.lineTo(selRect.x + borderInsets, y + h - 1);
            int bumpHeight = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            bottomOutline.lineTo(selRect.x + borderInsets, y + h + bumpHeight);
            if (selRect.x + selRect.width < x + w - 1) {
                int selectionEndX = selRect.x + selRect.width - delta - 1 - borderInsets;
                bottomOutline.lineTo(selectionEndX, y + h - 1 + bumpHeight);
                bottomOutline.lineTo(selectionEndX, y + h - 1);
                bottomOutline.lineTo(x + w - 1, y + h - 1);
            }
            g2d.setPaint(new GradientPaint(x, y + h - 1, this.darkShadow, x, y + h - 1 + bumpHeight, SubstanceColorUtilities.getAlphaColor(this.darkShadow, 0)));
            g2d.draw(bottomOutline);
        }
        if (isDouble) {
            if (tabPlacement == 3) {
                g2d.setColor(this.highlight);
                g2d.setColor(this.darkShadow);
                g2d.drawLine(x, y + h - 1 - ribbonDelta, x + w - 1, y + h - 1 - ribbonDelta);
            }
            if (tabPlacement == 2) {
                g2d.setPaint(new GradientPaint(x, y + h - 1, this.darkShadow, x + 4 * ribbonDelta, y + h - 1, this.highlight));
                g2d.drawLine(x, y + h - 1, x + 4 * ribbonDelta, y + h - 1);
            }
            if (tabPlacement == 4) {
                g2d.setPaint(new GradientPaint(x + w - 1 - 4 * ribbonDelta, y + h - 1, this.highlight, x + w - 1, y + h - 1, this.darkShadow));
                g2d.drawLine(x + w - 1 - 4 * ribbonDelta, y + h - 1, x + w - 1, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceConstants.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 2) {
            return;
        }
        int ribbonDelta = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y, x, y + h);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath leftOutline = new GeneralPath();
            leftOutline.moveTo(x, y);
            leftOutline.lineTo(x, selRect.y + borderInsets);
            int bumpWidth = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            leftOutline.lineTo(x - bumpWidth, selRect.y + borderInsets);
            if (selRect.y + selRect.height < y + h) {
                int selectionEndY = selRect.y + selRect.height - delta - 1 - borderInsets;
                leftOutline.lineTo(x - bumpWidth, selectionEndY);
                leftOutline.lineTo(x, selectionEndY);
                leftOutline.lineTo(x, y + h);
            }
            g2d.setPaint(new GradientPaint(x, y, this.darkShadow, x - bumpWidth, y, SubstanceColorUtilities.getAlphaColor(this.darkShadow, 0)));
            g2d.draw(leftOutline);
        }
        if (isDouble) {
            if (tabPlacement == 2) {
                g2d.setColor(this.darkShadow);
                g2d.drawLine(x + ribbonDelta, y, x + ribbonDelta, y + h);
            }
            if (tabPlacement == 1) {
                g2d.setPaint(new GradientPaint(x, y, this.darkShadow, x, y + 4 * ribbonDelta, this.highlight));
                g2d.drawLine(x, y, x, y + 4 * ribbonDelta);
            }
            if (tabPlacement == 3) {
                g2d.setPaint(new GradientPaint(x, y + h - 1 - 4 * ribbonDelta, this.highlight, x, y + h - 1, this.darkShadow));
                g2d.drawLine(x, y + h - 1 - 4 * ribbonDelta, x, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceConstants.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 4) {
            return;
        }
        int ribbonDelta = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x + w - 1, y, x + w - 1, y + h);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath rightOutline = new GeneralPath();
            rightOutline.moveTo(x + w - 1, y);
            rightOutline.lineTo(x + w - 1, selRect.y + borderInsets);
            int bumpWidth = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            rightOutline.lineTo(x + w - 1 + bumpWidth, selRect.y + borderInsets);
            if (selRect.y + selRect.height < y + h) {
                int selectionEndY = selRect.y + selRect.height - delta - 1 - borderInsets;
                rightOutline.lineTo(x + w - 1 + bumpWidth, selectionEndY);
                rightOutline.lineTo(x + w - 1, selectionEndY);
                rightOutline.lineTo(x + w - 1, y + h);
            }
            g2d.setPaint(new GradientPaint(x + w - 1, y, this.darkShadow, x + w - 1 + bumpWidth, y, SubstanceColorUtilities.getAlphaColor(this.darkShadow, 0)));
            g2d.draw(rightOutline);
        }
        if (isDouble) {
            if (tabPlacement == 4) {
                g2d.setColor(this.highlight);
                g2d.setColor(this.darkShadow);
                g2d.drawLine(x + w - 1 - ribbonDelta, y, x + w - 1 - ribbonDelta, y + h);
            }
            if (tabPlacement == 1) {
                g2d.setPaint(new GradientPaint(x + w - 1, y, this.darkShadow, x + w - 1, y + 4 * ribbonDelta, this.highlight));
                g2d.drawLine(x + w - 1, y, x + w - 1, y + 4 * ribbonDelta);
            }
            if (tabPlacement == 3) {
                g2d.setPaint(new GradientPaint(x + w - 1, y + h - 1 - 4 * ribbonDelta, this.highlight, x + w - 1, y + h - 1, this.darkShadow));
                g2d.drawLine(x + w - 1, y + h - 1 - 4 * ribbonDelta, x + w - 1, y + h - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean isPlacement;
        SubstanceConstants.TabContentPaneBorderKind kind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean isDouble = kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl = isPlacement = kind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || kind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (isPlacement && tabPlacement != 1) {
            return;
        }
        int ribbonDelta = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        int offset = (int)((double)strokeWidth / 2.0);
        boolean isUnbroken = tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w;
        x += offset;
        y += offset;
        w -= 2 * offset;
        h -= 2 * offset;
        if (isUnbroken) {
            g2d.setColor(this.highlight);
            g2d.drawLine(x, y, x + w - 1, y);
        } else {
            SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
            int delta = shaper instanceof ClassicButtonShaper ? 1 : 0;
            int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath topOutline = new GeneralPath();
            topOutline.moveTo(x, y);
            topOutline.lineTo(selRect.x + borderInsets, y);
            int bumpHeight = super.calculateTabHeight(tabPlacement, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            topOutline.lineTo(selRect.x + borderInsets, y - bumpHeight);
            if (selRect.x + selRect.width < x + w - 1) {
                int selectionEndX = selRect.x + selRect.width - delta - 1 - borderInsets;
                topOutline.lineTo(selectionEndX, y - bumpHeight);
                topOutline.lineTo(selectionEndX, y);
                topOutline.lineTo(x + w - 1, y);
            }
            g2d.setPaint(new GradientPaint(x, y, this.darkShadow, x, y - bumpHeight, SubstanceColorUtilities.getAlphaColor(this.darkShadow, 0)));
            g2d.draw(topOutline);
        }
        if (isDouble) {
            if (tabPlacement == 1) {
                g2d.setColor(this.darkShadow);
                g2d.drawLine(x, y + ribbonDelta, x + w - 1, y + ribbonDelta);
                g2d.setColor(this.highlight);
            }
            if (tabPlacement == 2) {
                g2d.setPaint(new GradientPaint(x, y, this.darkShadow, x + 4 * ribbonDelta, y, this.highlight));
                g2d.drawLine(x, y, x + 4 * ribbonDelta, y);
            }
            if (tabPlacement == 4) {
                g2d.setPaint(new GradientPaint(x + w - 1 - 4 * ribbonDelta, y, this.highlight, x + w - 1, y, this.darkShadow));
                g2d.drawLine(x + w - 1 - 4 * ribbonDelta, y, x + w - 1, y);
            }
        }
        g2d.dispose();
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    protected ComponentState getPrevTabState(int tabIndex) {
        if (this.prevStateMap.containsKey(tabIndex)) {
            return this.prevStateMap.get(tabIndex);
        }
        return ComponentState.DEFAULT;
    }

    protected ComponentState getTabState(int tabIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.tabPane.isEnabledAt(tabIndex));
        synthModel.setRollover(this.getRolloverTabIndex() == tabIndex);
        synthModel.setSelected(this.tabPane.getSelectedIndex() == tabIndex);
        return ComponentState.getState(synthModel, null);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            ComponentState state = this.getTabState(tabIndex);
            ComponentState prevState = this.getPrevTabState(tabIndex);
            if (prevState == null) {
                prevState = state;
            }
            Color fg = SubstanceCoreUtilities.getForegroundColor(this.tabPane, tabIndex, state, prevState);
            Graphics2D graphics = (Graphics2D)g.create();
            if (!state.isKindActive(FadeKind.ENABLE)) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.tabPane, SubstanceThemeUtilities.getTheme(this.tabPane.getComponentAt(tabIndex)).getThemeAlpha(this.tabPane.getComponentAt(tabIndex), state), g));
            }
            SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
            graphics.clip(this.getTabRectangle(tabIndex));
            textPainter.attachText(this.tabPane, textRect, title, mnemIndex, graphics.getFont(), fg, null);
            textPainter.renderSurface(graphics);
            graphics.dispose();
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return null;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(SubstanceTabbedPaneUI.this);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }

    protected class TabRepaintCallback
    implements FadeTrackerCallback {
        protected JTabbedPane tabbedPane;
        protected int tabIndex;

        public TabRepaintCallback(JTabbedPane tabPane, int tabIndex) {
            this.tabbedPane = tabPane;
            this.tabIndex = tabIndex;
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (SubstanceTabbedPaneUI.this.tabPane == this.tabbedPane && this.tabIndex < this.tabbedPane.getTabCount()) {
                SubstanceTabbedPaneUI.this.nextStateMap.put(this.tabIndex, SubstanceTabbedPaneUI.this.getTabState(this.tabIndex));
            }
            this.repaintTab();
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceTabbedPaneUI.this.tabPane == this.tabbedPane && this.tabIndex < this.tabbedPane.getTabCount()) {
                SubstanceTabbedPaneUI.this.prevStateMap.put(this.tabIndex, SubstanceTabbedPaneUI.this.getTabState(this.tabIndex));
                SubstanceTabbedPaneUI.this.nextStateMap.put(this.tabIndex, SubstanceTabbedPaneUI.this.getTabState(this.tabIndex));
            }
            this.repaintTab();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceTabbedPaneUI.this.tabPane == this.tabbedPane && this.tabIndex < this.tabbedPane.getTabCount()) {
                ComponentState nextState = (ComponentState)((Object)SubstanceTabbedPaneUI.this.nextStateMap.get(this.tabIndex));
                SubstanceTabbedPaneUI.this.prevStateMap.put(this.tabIndex, nextState);
            }
            this.repaintTab();
        }

        protected void repaintTab() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTabbedPaneUI.this.tabPane == null) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.ensureCurrentLayout();
                    int tabCount = SubstanceTabbedPaneUI.this.tabPane.getTabCount();
                    if (tabCount > 0 && TabRepaintCallback.this.tabIndex < tabCount && TabRepaintCallback.this.tabIndex < SubstanceTabbedPaneUI.this.rects.length) {
                        Rectangle rect = SubstanceTabbedPaneUI.this.getTabBounds(SubstanceTabbedPaneUI.this.tabPane, TabRepaintCallback.this.tabIndex);
                        SubstanceTabbedPaneUI.this.tabPane.repaint(rect);
                    }
                }
            });
        }
    }

    protected class TabSelectionHandler
    implements ChangeListener {
        protected TabSelectionHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            tabbedPane.revalidate();
            tabbedPane.repaint();
        }
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;
        boolean prevInCloseButton = false;
        int tabOfPressedCloseButton = -1;

        protected MouseRolloverHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
            if (closeCallback == null) {
                return;
            }
            final SubstanceConstants.TabCloseKind tabCloseKind = closeCallback.onAreaClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
            if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                }
            });
        }

        public void mouseDragged(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        public void mouseEntered(MouseEvent e) {
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
        }

        public void mousePressed(MouseEvent e) {
            if (!SubstanceTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                Rectangle rect = new Rectangle();
                rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                boolean inCloseButton = close.contains(e.getPoint());
                int n = this.tabOfPressedCloseButton = inCloseButton ? tabIndex : -1;
                if (tabIndex != SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (inCloseButton) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (SubstanceTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    SubstanceTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.handleMouseMoveDrag(e);
        }

        private void handleMouseMoveDrag(MouseEvent e) {
            if (e.getSource() != SubstanceTabbedPaneUI.this.tabPane) {
                return;
            }
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY()));
            if (SubstanceLookAndFeel.toIgnoreAnimation(SubstanceTabbedPaneUI.this.tabPane.getClass())) {
                return;
            }
            SubstanceTabbedPaneUI.this.substanceMouseLocation = e.getPoint();
            int currRolledOver = SubstanceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
            if (currRolledOver == this.prevRolledOver) {
                if (currRolledOver >= 0) {
                    Rectangle rect = new Rectangle();
                    rect = SubstanceTabbedPaneUI.this.getTabBounds(currRolledOver, rect);
                    Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(currRolledOver, rect.x, rect.y, rect.width, rect.height);
                    boolean inCloseButton = close.contains(e.getPoint());
                    if (this.prevInCloseButton == inCloseButton) {
                        return;
                    }
                    this.prevInCloseButton = inCloseButton;
                    if (tabCloseCallback != null) {
                        if (inCloseButton) {
                            String closeButtonTooltip = tabCloseCallback.getCloseButtonTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, closeButtonTooltip);
                        } else {
                            String areaTooltip = tabCloseCallback.getAreaTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, areaTooltip);
                        }
                    }
                    if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount()) {
                        FadeTrackerCallback currCallback = SubstanceTabbedPaneUI.this.getCallback(currRolledOver);
                        currCallback.fadePerformed(FadeKind.ROLLOVER, 0.0f);
                    }
                }
            } else {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    fadeTracker.trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, (FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
                }
                if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(currRolledOver)) {
                    fadeTracker.trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, currRolledOver, true, (FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                }
            }
            this.prevRolledOver = currRolledOver;
        }

        public void mouseExited(MouseEvent e) {
            SubstanceTabbedPaneUI.this.setRolloverTab(-1);
            if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, (FadeTrackerCallback)new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
                if (SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver) != null) {
                    SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(this.prevRolledOver, null);
                }
            }
            this.prevRolledOver = -1;
        }

        public void mouseReleased(final MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (SubstanceCoreUtilities.hasCloseButton(SubstanceTabbedPaneUI.this.tabPane, tabIndex) && tabIndex == this.tabOfPressedCloseButton) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                            Rectangle rect = new Rectangle();
                            rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                            Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                            if (close.contains(e.getPoint())) {
                                TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
                                SubstanceConstants.TabCloseKind tabCloseKind = closeCallback == null ? SubstanceConstants.TabCloseKind.THIS : closeCallback.onCloseButtonClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
                                SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                            }
                        }
                    }
                });
                this.tabOfPressedCloseButton = -1;
            }
        }
    }

    protected final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        protected void trackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        protected void trackTab(final Component tabComponent) {
            int tabIndex;
            if (tabComponent == null) {
                return;
            }
            PropertyChangeListener tabModifiedListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("windowModified".equals(evt.getPropertyName())) {
                        int tabIndex;
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        boolean wasModified = Boolean.TRUE.equals(oldValue);
                        boolean isModified = Boolean.TRUE.equals(newValue);
                        if (wasModified) {
                            if (!isModified) {
                                long fadeInstanceId = (Long)SubstanceTabbedPaneUI.this.fadeModifiedIds.get(tabComponent);
                                FadeTracker.getInstance().cancelFadeInstance(fadeInstanceId);
                            }
                        } else if (isModified && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                            long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), SubstanceTabbedPaneUI.this.tabPane, Integer.valueOf(tabIndex), false, SubstanceTabbedPaneUI.this.getCallback(tabIndex), -1, true);
                            SubstanceTabbedPaneUI.this.fadeModifiedIds.put(tabComponent, fadeInstanceId);
                        }
                    }
                }
            };
            tabComponent.addPropertyChangeListener(tabModifiedListener);
            List<PropertyChangeListener> currList = this.listeners.get(tabComponent);
            if (currList == null) {
                currList = new LinkedList<PropertyChangeListener>();
            }
            currList.add(tabModifiedListener);
            this.listeners.put(tabComponent, currList);
            if (tabComponent instanceof JComponent && Boolean.TRUE.equals(((JComponent)tabComponent).getClientProperty("windowModified")) && (tabIndex = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(tabComponent)) >= 0) {
                long fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(ModifiedFadeStep.MARKED_MODIFIED_FADE_KIND, new LafConstants.AnimationKind(new ModifiedFadeStep(), "modified"), SubstanceTabbedPaneUI.this.tabPane, Integer.valueOf(tabIndex), false, SubstanceTabbedPaneUI.this.getCallback(tabIndex), -1, true);
                SubstanceTabbedPaneUI.this.fadeModifiedIds.put(tabComponent, fadeInstanceId);
            }
        }

        protected void stopTrackTab(Component tabComponent) {
            if (tabComponent == null) {
                return;
            }
            List<PropertyChangeListener> pclList = this.listeners.get(tabComponent);
            if (pclList != null) {
                for (PropertyChangeListener pcl : pclList) {
                    tabComponent.removePropertyChangeListener(pcl);
                }
            }
            this.listeners.put(tabComponent, null);
        }

        protected void stopTrackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.stopTrackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        public void componentAdded(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent instanceof UIResource) {
                return;
            }
            this.trackTab(tabComponent);
        }

        public void componentRemoved(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent == null) {
                return;
            }
            if (tabComponent instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener pcl : this.listeners.get(tabComponent)) {
                tabComponent.removePropertyChangeListener(pcl);
            }
            this.listeners.get(tabComponent).clear();
            this.listeners.remove(tabComponent);
        }
    }
}

