/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Highlighter;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.text.SubstanceHighlighter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceTextPaneUI
extends BasicTextPaneUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JTextPane textPane;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTextPaneUI(c);
    }

    public SubstanceTextPaneUI(JComponent c) {
        this.textPane = (JTextPane)c;
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textPane, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTextPaneUI.this.textPane.updateUI();
                        }
                    });
                }
            }
        };
        this.textPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void installDefaults() {
        super.installDefaults();
        Border b = this.textPane.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textPane))), new BasicBorders.MarginBorder());
            this.textPane.setBorder(newB);
        }
    }

    protected void paintBackground(Graphics g) {
        SubstanceCoreUtilities.paintTextCompBackground(g, this.textPane);
    }

    protected Highlighter createHighlighter() {
        return new SubstanceHighlighter();
    }
}

