/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.GlowingIcon;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI {
    private ButtonBackgroundDelegate delegate = new ButtonBackgroundDelegate();
    private RolloverButtonListener substanceButtonListener;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected FadeStateListener substanceFadeStateListener;

    public static ComponentUI createUI(JComponent b) {
        ((AbstractButton)b).setRolloverEnabled(true);
        return new SubstanceToggleButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        if (b.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            b.putClientProperty("substancelaf.buttonborderoriginal", b.getBorder());
        }
        this.trackGlowingIcon(b);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof SubstanceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                SubstanceButtonBorder sbCurrBorder = (SubstanceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty("substancelaf.buttonborderoriginal"));
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceButtonListener = new RolloverButtonListener(b);
        b.addMouseListener(this.substanceButtonListener);
        b.addMouseMotionListener(this.substanceButtonListener);
        b.addFocusListener(this.substanceButtonListener);
        b.addPropertyChangeListener(this.substanceButtonListener);
        b.addChangeListener(this.substanceButtonListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.buttonShaper".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(b);
                        }
                    });
                }
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceToggleButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceToggleButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceToggleButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
                    SubstanceToggleButtonUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("icon".equals(evt.getPropertyName())) {
                    SubstanceToggleButtonUI.this.trackGlowingIcon(b);
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
        this.substanceFadeStateListener.registerListeners();
    }

    protected void uninstallListeners(AbstractButton b) {
        b.removeMouseListener(this.substanceButtonListener);
        b.removeMouseMotionListener(this.substanceButtonListener);
        b.removeFocusListener(this.substanceButtonListener);
        b.removePropertyChangeListener(this.substanceButtonListener);
        b.removeChangeListener(this.substanceButtonListener);
        this.substanceButtonListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners(b);
    }

    public void paint(Graphics g, JComponent c) {
        JButton jb;
        final AbstractButton b = (AbstractButton)c;
        if (b instanceof JButton && PulseTracker.isPulsating(jb = (JButton)b)) {
            PulseTracker.update(jb);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        final Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        boolean hasEmptyText = text == null || text.length() == 0;
        final View v = (View)c.getClientProperty("html");
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init(b, null, v != null);
        g2d.setFont(f);
        if (!hasEmptyText && textPainter.needsBackgroundImage()) {
            textPainter.setBackgroundFill(b, b.getParent().getBackground(), true, 0, 0);
            textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                public void paintBackground(Graphics g) {
                    SubstanceToggleButtonUI.this.delegate.updateBackground(g, b);
                }
            });
        } else {
            this.delegate.updateBackground(g2d, b);
        }
        float textAlpha = 1.0f;
        if (v != null) {
            if (textPainter.needsBackgroundImage()) {
                textPainter.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback(){

                    public void paintBackground(Graphics g) {
                        v.paint(g, textRect);
                    }
                });
            } else {
                v.paint(g2d, textRect);
            }
        } else {
            textAlpha = this.paintButtonText(g, b, textRect, text);
        }
        g2d.setComposite(TransitionLayout.getAlphaComposite(b, textAlpha, g));
        textPainter.renderSurface(g2d);
        g2d.setComposite(TransitionLayout.getAlphaComposite(b, 1.0f, g));
        if (b.getIcon() != null) {
            this.paintIcon((Graphics)g2d, c, iconRect);
        }
        if (b.isFocusPainted() && (b.hasFocus() || FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            this.paintFocus(g2d, b, viewRect, textRect, iconRect);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JToggleButton)c, x, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!b.isFocusPainted()) {
            return;
        }
        SubstanceCoreUtilities.paintFocus(g, b, b, null, textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        Icon icon = SubstanceCoreUtilities.getIcon(b, null, this.glowingIcon, false);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)b, g));
        if (fadeTracker.isTracked(b, FadeKind.ROLLOVER)) {
            ComponentState state = ComponentState.getState(b.getModel(), b);
            if (state.isKindActive(FadeKind.ROLLOVER)) {
                SubstanceCoreUtilities.getIcon(b, null, this.glowingIcon, true).paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
            } else {
                icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
                graphics.setComposite(TransitionLayout.getAlphaComposite(b, fadeTracker.getFade10(b, FadeKind.ROLLOVER) / 10.0f, g));
                b.getIcon().paintIcon(b, graphics, iconRect.x, iconRect.y);
            }
        } else {
            icon.paintIcon(b, graphics, iconRect.x, iconRect.y);
        }
        graphics.dispose();
    }

    protected float paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        return SubstanceCoreUtilities.paintText(button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    protected void trackGlowingIcon(AbstractButton b) {
        Icon currIcon = b.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, b);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }
}

