/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceToolBarSeparatorUI();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(c).getDefaultTheme();
        ColorScheme colorScheme = theme.getColorScheme();
        SubstanceCoreUtilities.paintSeparator(c, graphics, colorScheme, SubstanceCoreUtilities.isThemeDark(theme), c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
        graphics.dispose();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension size = ((JToolBar.Separator)c).getSeparatorSize();
        if (size != null) {
            size = size.getSize();
        } else {
            size = new Dimension(6, 6);
            if (((JSeparator)c).getOrientation() == 1) {
                size.height = 0;
            } else {
                size.width = 0;
            }
        }
        return size;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension pref = this.getPreferredSize(c);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(pref.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, pref.height);
    }
}

